/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.servicedesk.suggested;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.feature.servicedesk.suggested.SDSuggestedItem;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskSuggestedService {
    private static final int SUGGESTED_LIMIT = 5;
    private final InternalServiceDeskService internalServiceDeskService;
    private final ServiceDeskProjectService serviceDeskProjectService;

    @Autowired
    public ServiceDeskSuggestedService(InternalServiceDeskService internalServiceDeskService, ServiceDeskProjectService serviceDeskProjectService) {
        this.internalServiceDeskService = internalServiceDeskService;
        this.serviceDeskProjectService = serviceDeskProjectService;
    }

    public List<SDSuggestedItem> getSDSuggested(CheckedUser checkedUser) {
        List serviceDesks = this.internalServiceDeskService.getServiceDesksVisibleAsAgent(checkedUser, 5);
        return serviceDesks.stream().map(sd -> this.tryAndGetSDSuggestedItem(checkedUser, (ServiceDesk)sd)).filter(Maybe::isDefined).map(Maybe::get).collect(Collectors.toList());
    }

    private Option<SDSuggestedItem> tryAndGetSDSuggestedItem(CheckedUser user, ServiceDesk sd) {
        Either<AnError, Project> projectById = this.serviceDeskProjectService.getProjectById(user, sd.getProjectId());
        return projectById.toOption().map(p -> new SDSuggestedItem(sd, (Project)p));
    }
}

