/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.servicedesk;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ServiceDeskServiceImpl
implements ServiceDeskService {
    private final InternalServiceDeskService internalServiceDeskService;
    private final UserFactory userFactory;

    @Autowired
    public ServiceDeskServiceImpl(InternalServiceDeskService internalServiceDeskService, UserFactory userFactory) {
        this.internalServiceDeskService = internalServiceDeskService;
        this.userFactory = userFactory;
    }

    public Either<AnError, ServiceDesk> getServiceDeskForProject(ApplicationUser user, Project project) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> StepsConverters.olderEither((io.atlassian.fugue.Either)this.internalServiceDeskService.getServiceDeskForProject(checkedUser, project, false))).yield((checkedUser, serviceDesk) -> serviceDesk);
    }

    public Either<AnError, ServiceDesk> getServiceDeskById(ApplicationUser user, long serviceDeskId) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> StepsConverters.olderEither((io.atlassian.fugue.Either)this.internalServiceDeskService.getServiceDeskById(checkedUser, serviceDeskId))).yield((checkedUser, serviceDesk) -> serviceDesk);
    }

    public Either<AnError, PagedResponse<ServiceDesk>> getServiceDesks(ApplicationUser user, PagedRequest pagedRequest) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(this::getVisibleServiceDesk).yield((checkedUser, visibleServiceDesks) -> this.paginateServiceDeskList((List<ServiceDesk>)visibleServiceDesks, pagedRequest));
    }

    private Either<AnError, List<ServiceDesk>> getVisibleServiceDesk(CheckedUser checkedUser) {
        return Either.right((Object)this.internalServiceDeskService.getVisibleServiceDesks(checkedUser));
    }

    private PagedResponse<ServiceDesk> paginateServiceDeskList(List<ServiceDesk> serviceDesks, PagedRequest pagedRequest) {
        return PagedResponseImpl.sortAndToPagedResponse((LimitedPagedRequest)LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)100), serviceDesks, (sd1, sd2) -> sd1.getProjectName().compareTo(sd2.getProjectName()));
    }
}

