/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.validation;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.search.user.UserEmailMatcherActiveState;
import com.atlassian.servicedesk.internal.api.search.user.UserEmailMatcherUsernames;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerServiceValidator;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import com.atlassian.servicedesk.internal.feature.reqparticipants.error.RequestParticipantError;
import com.atlassian.servicedesk.internal.feature.reqparticipants.validation.RequestParticipantValidationResult;
import com.atlassian.servicedesk.internal.feature.reqparticipants.validation.RequestParticipantValidator;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestParticipantValidatorImpl
implements RequestParticipantValidator {
    private static final Function<RequestParticipantValidationResult, CheckedUser> validResultToUser = validResult -> (CheckedUser)validResult.getUser().right().get();
    private static final Function<CheckedUser, RequestParticipantValidationResult> userToValidResult = RequestParticipantValidationResult::ok;
    private final IssueHelper issueHelper;
    private final UserSearchManager userSearchManager;
    private final UserSearchManagerHelper userSearchManagerHelper;
    private final RequestParticipantError requestParticipantError;
    private final CustomerServiceValidator customerServiceValidator;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final UserFactory userFactory;

    @Autowired
    public RequestParticipantValidatorImpl(UserSearchManager userSearchManager, UserSearchManagerHelper userSearchManagerHelper, UserFactory userFactory, IssueHelper issueHelper, RequestParticipantError requestParticipantError, ServiceDeskInternalManager serviceDeskInternalManager, CustomerServiceValidator customerServiceValidator) {
        this.userSearchManagerHelper = userSearchManagerHelper;
        this.issueHelper = issueHelper;
        this.userSearchManager = userSearchManager;
        this.requestParticipantError = requestParticipantError;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.customerServiceValidator = customerServiceValidator;
        this.userFactory = userFactory;
    }

    @Override
    public boolean canUserBeParticipant(CheckedUser potentialParticipant, Issue issue) {
        return !this.issueHelper.getReporterOpt(issue).exists(reporter -> reporter.equals(potentialParticipant)) && this.canUserBeParticipantOnProject(potentialParticipant, issue.getProjectObject());
    }

    @Override
    public boolean canUserBeParticipantOnProject(CheckedUser potentialParticipant, Project project) {
        return this.customerServiceValidator.isCustomerForProject(potentialParticipant, project);
    }

    @Override
    public Collection<String> getParticipantsValidationErrorMessage(Collection<CheckedUser> users, Collection<CheckedUser> existingParticipants, Issue issue) {
        io.atlassian.fugue.Option errorsMessagesOpt = Steps.begin((io.atlassian.fugue.Option)this.issueHelper.getProjectFromIssue(issue).toOption()).then(project -> StepsConverters.newerOption((Option)this.userFactory.getCheckedUser().toOption())).yield((project, user) -> {
            if (this.serviceDeskInternalManager.isServiceDeskEnabled((Project)project)) {
                return this.getValidationErrorMessages((CheckedUser)user, users, existingParticipants, issue, (Project)project);
            }
            return Collections.emptyList();
        });
        return (Collection)errorsMessagesOpt.getOrElse(Collections.emptyList());
    }

    @Override
    public Collection<CheckedUser> filterUsersWhoCannotBeParticipants(Collection<CheckedUser> users, Issue issue) {
        return users.stream().filter(user -> this.canUserBeParticipant((CheckedUser)user, issue)).collect(Collectors.toList());
    }

    @Override
    public Collection<CheckedUser> getParticipantsByEmails(Collection<String> emailAddresses, Project project) {
        Collection<RequestParticipantValidationResult> requestParticipantValidationResults = this.validateParticipantByEmails(emailAddresses, project);
        return this.getParticipantsByValidationResults(requestParticipantValidationResults);
    }

    @Override
    public Collection<CheckedUser> getParticipantsByUsernames(Collection<String> usernames, Project project) {
        Collection<RequestParticipantValidationResult> requestParticipantValidationResults = this.validateParticipantByUsernames(usernames, project);
        return this.getParticipantsByValidationResults(requestParticipantValidationResults);
    }

    @Override
    public Collection<CheckedUser> getParticipantsByEmails(Collection<String> emailAddresses, Issue issue) {
        Collection<RequestParticipantValidationResult> requestParticipantValidationResults = this.validateParticipantByEmails(emailAddresses, issue);
        return this.getParticipantsByValidationResults(requestParticipantValidationResults);
    }

    @Override
    public Collection<RequestParticipantValidationResult> validateParticipantByEmails(Collection<String> emailAddresses, Issue issue) {
        return this.transformCollection(emailAddresses, emailAddress -> this.validateEmailForParticipantOnIssue((String)emailAddress, issue));
    }

    private Collection<RequestParticipantValidationResult> validateParticipantByEmails(Collection<String> emailAddresses, Project project) {
        return this.transformCollection(emailAddresses, emailAddress -> this.validateEmailForParticipantOnProject((String)emailAddress, project));
    }

    private Collection<RequestParticipantValidationResult> validateEmailForParticipantOnProject(String emailAddress, Project project) {
        return this.validateParticipantByEmail(emailAddress, (Predicate<CheckedUser>)((Predicate)user -> this.canUserBeParticipantOnProject((CheckedUser)user, project)));
    }

    private Collection<RequestParticipantValidationResult> validateEmailForParticipantOnIssue(String emailAddress, Issue issue) {
        return this.validateParticipantByEmail(emailAddress, (Predicate<CheckedUser>)((Predicate)user -> this.canUserBeParticipant((CheckedUser)user, issue)));
    }

    private Collection<RequestParticipantValidationResult> validateParticipantByEmail(String emailAddress, Predicate<CheckedUser> validateFunction) {
        Collection<CheckedUser> foundUsers = this.findActiveUsersByEmail(emailAddress);
        Collection<RequestParticipantValidationResult> results = this.transform(foundUsers, validateFunction, userToValidResult);
        if (results.isEmpty()) {
            return Collections.singleton(RequestParticipantValidationResult.errorEmailAddress(emailAddress, this.requestParticipantError.NO_CUSTOMER_FOUND_FOR_PROVIDED_EMAIL_ADDRESS()));
        }
        return results;
    }

    private Collection<CheckedUser> findActiveUsersByEmail(String emailAddress) {
        UserSearchParams params = this.userSearchManagerHelper.buildEmailMatcherUserSearchParams(emailAddress, UserEmailMatcherActiveState.ACTIVE_USERS_ONLY, UserEmailMatcherUsernames.DO_NOT_MATCH_USERNAMES);
        return this.userSearchManager.searchUnlimited(emailAddress, params).flatMap(appUser -> (Stream)this.userFactory.wrap(appUser).fold(anError -> Stream.empty(), Stream::of)).collect(Collectors.toList());
    }

    private Collection<CheckedUser> getParticipantsByValidationResults(Collection<RequestParticipantValidationResult> requestParticipantValidationResults) {
        return this.transform(requestParticipantValidationResults, RequestParticipantValidationResult::isValid, validResultToUser);
    }

    private Collection<RequestParticipantValidationResult> validateParticipantByUsernames(Collection<String> usernames, Project project) {
        return this.transformCollection(usernames, username -> this.validateUsernamesForParticipantOnProject((String)username, project));
    }

    private Collection<RequestParticipantValidationResult> validateUsernamesForParticipantOnProject(String username, Project project) {
        return this.validateParticipantByUsername(username, (Predicate<CheckedUser>)((Predicate)user -> this.canUserBeParticipantOnProject((CheckedUser)user, project)));
    }

    private Collection<RequestParticipantValidationResult> validateParticipantByUsername(String username, Predicate<CheckedUser> validateFunction) {
        ImmutableList foundUsers = ImmutableList.copyOf((Iterable)this.userFactory.wrapUsername(username).toOption());
        Collection<RequestParticipantValidationResult> results = this.transform((Collection)foundUsers, (Predicate)validateFunction, (Function)userToValidResult);
        if (results.isEmpty()) {
            return Collections.singleton(RequestParticipantValidationResult.errorUsername(username, this.requestParticipantError.NO_CUSTOMER_FOUND_FOR_PROVIDED_USERNAME()));
        }
        return results;
    }

    private Collection<String> getValidationErrorMessages(CheckedUser validatingUser, Collection<CheckedUser> users, Collection<CheckedUser> existingParticipants, Issue issue, Project project) {
        return Lists.newArrayList((Iterable)Iterables.concat(this.getReporterExcludedErrorMessage(validatingUser, issue, users), this.getNonCustomersErrorMessage(validatingUser, project, users, existingParticipants)));
    }

    private io.atlassian.fugue.Option<String> getReporterExcludedErrorMessage(CheckedUser validatingUser, Issue issue, Collection<CheckedUser> users) {
        return this.issueHelper.getReporterOpt(issue).filter(users::contains).map(foundReporter -> validatingUser.i18NHelper().getText("sd.request.participants.validation.reporter", foundReporter.getName()));
    }

    private io.atlassian.fugue.Option<String> getNonCustomersErrorMessage(CheckedUser validatingUser, Project project, Collection<CheckedUser> users, Collection<CheckedUser> existingParticipants) {
        List nonCustomers = users.stream().filter(user -> !existingParticipants.contains(user) && !this.customerServiceValidator.isCustomerForProject((CheckedUser)user, project)).map(CheckedUser::getDisplayName).collect(Collectors.toList());
        if (nonCustomers.isEmpty()) {
            return io.atlassian.fugue.Option.none();
        }
        Object dumbObjectPlaceholderImSorry = null;
        return io.atlassian.fugue.Option.some((Object)validatingUser.i18NHelper().getText("sd.request.participants.validation.not.customer", (Object)nonCustomers.size(), (Object)StringUtils.join(nonCustomers, (String)", "), dumbObjectPlaceholderImSorry));
    }

    private <Input, Output> Collection<Output> transform(Collection<Input> input, Predicate<Input> filter2, Function<Input, Output> iterator) {
        Collection filtered = Collections2.filter(input, filter2);
        return Collections2.transform((Collection)filtered, iterator);
    }

    private <Input, Output> Collection<Output> transformCollection(Collection<Input> input, Function<Input, Collection<Output>> iterator) {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Collections2.transform(input, iterator)));
    }
}

