/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.settings;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.workinprogressapi.participantsettings.ParticipantSettingsConfiguration;
import com.atlassian.servicedesk.workinprogressapi.participantsettings.ParticipantSettingsUpdate;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ParticipantSettingsServiceImpl
implements ParticipantSettingsService {
    private final ParticipantSettingsManager participantSettingsManager;
    private final InternalServiceDeskService serviceDeskService;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public ParticipantSettingsServiceImpl(ParticipantSettingsManager participantSettingsManager, InternalServiceDeskService serviceDeskService, ServiceDeskPermissions serviceDeskPermissions, ErrorResultHelper errorResultHelper) {
        this.participantSettingsManager = participantSettingsManager;
        this.serviceDeskService = serviceDeskService;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public Either<AnError, ParticipantSettingsConfiguration> getSettingsForProject(CheckedUser user, Project project) {
        return Steps.begin(this.checkManageParticipantSettingsPermission(user, project)).then(success -> this.serviceDeskService.getServiceDeskForProject(user, project, false)).yield((jsdSuccess, serviceDesk) -> this.participantSettingsManager.getSettings((ServiceDesk)serviceDesk));
    }

    @Override
    public ParticipantSettingsConfiguration getSettingsForServiceDesk(CheckedUser user, ServiceDesk serviceDesk) {
        return this.participantSettingsManager.getSettings(serviceDesk);
    }

    @Override
    public Either<AnError, ParticipantSettingsConfiguration> updateSettings(CheckedUser user, Project project, ParticipantSettingsUpdate settingsUpdate) {
        return Steps.begin(this.checkManageParticipantSettingsPermission(user, project)).then(success -> this.participantSettingsManager.updateSettings(settingsUpdate)).yield((jsdSuccess, updatedSettings) -> updatedSettings);
    }

    @Override
    public boolean isManageParticipantsSettingEnabled(ServiceDesk serviceDesk) {
        return this.participantSettingsManager.getSettings(serviceDesk).getParticipantManagementEnabled();
    }

    private Either<AnError, JSDSuccess> checkManageParticipantSettingsPermission(CheckedUser user, Project project) {
        if (!this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.left((Object)this.errorResultHelper.forbidden403("sd.request.participants.no.permission.manage.settings", new Object[0]).build());
        }
        return Either.right((Object)((Object)JSDSuccess.success()));
    }
}

