/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.settings;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsModel;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsQStore;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParticipantSettingsQStoreImpl
implements ParticipantSettingsQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public ParticipantSettingsQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    static ConstructorExpression<ParticipantSettingsModel> MAPPER() {
        return Projections.constructor(ParticipantSettingsModel.class, (Expression[])new Expression[]{Tables.PARTICIPANT_SETTINGS.SERVICE_DESK_ID, Tables.PARTICIPANT_SETTINGS.MANAGE_ENABLED, Tables.PARTICIPANT_SETTINGS.AUTOCOMPLETE_ENABLED});
    }

    @Override
    public Option<ParticipantSettingsModel> getSettings(ServiceDesk serviceDesk) {
        return Option.option((Object)this.databaseAccessor.run(conn -> ParticipantSettingsQStoreImpl.loadSettings(serviceDesk, conn)));
    }

    @Override
    public Option<ParticipantSettingsModel> createOrUpdateSettings(ServiceDesk serviceDesk, ParticipantSettingsModel participantSettingsModel) {
        return Option.option((Object)this.databaseAccessor.run(conn -> {
            ParticipantSettingsModel settings = ParticipantSettingsQStoreImpl.loadSettings(serviceDesk, conn);
            Object clause = settings == null ? conn.insert((RelationalPath)Tables.PARTICIPANT_SETTINGS).set(Tables.PARTICIPANT_SETTINGS.SERVICE_DESK_ID, (Object)serviceDesk.getId()) : conn.update((RelationalPath)Tables.PARTICIPANT_SETTINGS).where((Predicate)Tables.PARTICIPANT_SETTINGS.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()));
            clause.set((Path)Tables.PARTICIPANT_SETTINGS.MANAGE_ENABLED, (Object)participantSettingsModel.isManageEnabled()).set((Path)Tables.PARTICIPANT_SETTINGS.AUTOCOMPLETE_ENABLED, (Object)participantSettingsModel.isAutocompleteEnabled()).execute();
            return ParticipantSettingsQStoreImpl.loadSettings(serviceDesk, conn);
        }));
    }

    @Override
    public void deleteSettings(ServiceDesk serviceDesk) {
        this.databaseAccessor.run(conn -> conn.delete((RelationalPath)Tables.PARTICIPANT_SETTINGS).where((Predicate)Tables.PARTICIPANT_SETTINGS.SERVICE_DESK_ID.eq((Object)serviceDesk.getId())).execute());
    }

    private static ParticipantSettingsModel loadSettings(ServiceDesk serviceDesk, DatabaseConnection conn) {
        return (ParticipantSettingsModel)((SQLQuery)((SQLQuery)conn.select(ParticipantSettingsQStoreImpl.MAPPER()).from((Expression)Tables.PARTICIPANT_SETTINGS)).where((Predicate)Tables.PARTICIPANT_SETTINGS.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()))).fetchFirst();
    }
}

