/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.settings;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.feature.reqparticipants.error.RequestParticipantError;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsModel;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsQStore;
import com.atlassian.servicedesk.workinprogressapi.participantsettings.ParticipantSettingsConfiguration;
import com.atlassian.servicedesk.workinprogressapi.participantsettings.ParticipantSettingsUpdate;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParticipantSettingsManagerImpl
implements ParticipantSettingsManager {
    private final ParticipantSettingsQStore participantSettingsStore;
    private final RequestParticipantError requestParticipantError;

    @Autowired
    public ParticipantSettingsManagerImpl(ParticipantSettingsQStore participantSettingsStore, RequestParticipantError requestParticipantError) {
        this.participantSettingsStore = participantSettingsStore;
        this.requestParticipantError = requestParticipantError;
    }

    @Override
    public ParticipantSettingsConfiguration getSettings(ServiceDesk serviceDesk) {
        Option<ParticipantSettingsModel> storedSettingOpt = this.participantSettingsStore.getSettings(serviceDesk);
        ParticipantSettingsModel settingsModel = (ParticipantSettingsModel)storedSettingOpt.getOrElse((Object)this.getDefaultParticipantSettings(serviceDesk));
        return this.toValidatedConfiguration(settingsModel);
    }

    @Override
    public Either<AnError, ParticipantSettingsConfiguration> updateSettings(ParticipantSettingsUpdate participantSettingsUpdate) {
        return Steps.begin(this.validateUpdate(participantSettingsUpdate)).then(validatedSettings -> this.participantSettingsStore.createOrUpdateSettings(participantSettingsUpdate.getServiceDesk(), (ParticipantSettingsModel)validatedSettings).toRight(this.requestParticipantError::FAILED_TO_UPDATE_PARTICIPANT_SETTINGS)).yield((validatedSettings, updatedSettings) -> this.toValidatedConfiguration((ParticipantSettingsModel)updatedSettings));
    }

    @Override
    public void deleteSettings(ServiceDesk serviceDesk) {
        this.participantSettingsStore.deleteSettings(serviceDesk);
    }

    private Either<AnError, ParticipantSettingsModel> validateUpdate(ParticipantSettingsUpdate participantSettingsUpdate) {
        return Either.right((Object)new ParticipantSettingsModel(participantSettingsUpdate.getServiceDesk().getId(), participantSettingsUpdate.isManageEnabled(), participantSettingsUpdate.isAutocompleteEnabled()));
    }

    private ParticipantSettingsConfiguration toValidatedConfiguration(ParticipantSettingsModel participantSettingsModel) {
        boolean manageEnabled = participantSettingsModel.isManageEnabled();
        boolean autoCompleteEnabled = participantSettingsModel.isAutocompleteEnabled();
        return new ParticipantSettingsConfiguration(manageEnabled, autoCompleteEnabled);
    }

    private ParticipantSettingsModel getDefaultParticipantSettings(ServiceDesk serviceDesk) {
        return new ParticipantSettingsModel(serviceDesk.getId());
    }
}

