/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.error;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestParticipantError {
    private final ErrorResultHelper errorHelper;

    @Autowired
    public RequestParticipantError(ErrorResultHelper errorHelper) {
        this.errorHelper = errorHelper;
    }

    public AnError NO_VIEW_PARTICIPANT_OF_ISSUE_PERMISSION() {
        return this.errorHelper.forbidden403("sd.request.participants.no.permission.view.participants", new Object[0]).build();
    }

    public AnError INVALID_PARTICIPANT_USERNAMES_ERROR(Collection<String> invalidParticipantUserNames) {
        return this.errorHelper.badRequest400("sd.request.participants.username.error", new Object[]{StringUtils.join(invalidParticipantUserNames, (String)", ")}).build();
    }

    public AnError NO_EDIT_PARTICIPANT_PERMISSION() {
        return this.errorHelper.forbidden403("sd.request.participant.api.no.permission.to.change.participant", new Object[0]).build();
    }

    public AnError NO_CUSTOMER_FOUND_FOR_PROVIDED_EMAIL_ADDRESS() {
        return this.errorHelper.badRequest400("sd.request.participants.portal.validate.not.customer", new Object[0]).build();
    }

    public AnError NO_CUSTOMER_FOUND_FOR_PROVIDED_USERNAME() {
        return this.errorHelper.badRequest400("sd.request.participants.portal.validate.username.not.customer", new Object[0]).build();
    }

    public AnError FAILED_TO_RETRIEVE_VALUE_FROM_REQUEST_PARTICIPANT_CUSTOM_FIELD() {
        return this.errorHelper.internalServiceError500("sd.request.participants.error.field.value", new Object[0]).build();
    }

    public AnError FAILED_TO_UPDATE_REQUEST_PARTICIPANT_CUSTOM_FIELD_UNKNOWN() {
        return this.errorHelper.internalServiceError500("sd.request.participants.error.field.update.failed.unknown", new Object[0]).build();
    }

    public AnError FAILED_TO_UPDATE_REQUEST_PARTICIPANT_CUSTOM_FIELD(ErrorCollection errorCollection) {
        Collection errorMessages2 = errorCollection.getErrorMessages();
        String join = StringUtils.join((Collection)errorMessages2, (String)", ");
        return this.errorHelper.internalServiceError500("sd.request.participants.error.field.update.failed", new Object[]{join}).build();
    }

    public AnError RATE_LIMIT_REQUEST_PARTICIPANT_FAIL(int maxLimit) {
        return this.errorHelper.internalServiceError500("sd.request.participants.invite.rate.limit.exceeded", new Object[]{maxLimit}).build();
    }

    public AnError FAILED_TO_UPDATE_PARTICIPANT_SETTINGS() {
        return this.errorHelper.internalServiceError500("sd.request.participants.failed.update.settings", new Object[0]).build();
    }
}

