/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.notifications.GlobalNotificationsManager;
import com.atlassian.servicedesk.internal.api.notifications.recipients.RecipientConfiguration;
import com.atlassian.servicedesk.internal.api.notifications.recipients.RecipientResolutionManager;
import com.atlassian.servicedesk.internal.api.notifications.recipients.RecipientType;
import com.atlassian.servicedesk.internal.api.permission.security.CustomerInvolvedService;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.ServiceDeskNotificationHelper;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ServiceDeskNotificationHelperImpl
implements ServiceDeskNotificationHelper {
    private final VpOriginManager originManager;
    private final CommentPermissionManager commentPermissionManager;
    private final GlobalNotificationsManager globalNotificationManager;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final CustomerInvolvedService customerInvolvedService;
    private final RecipientResolutionManager recipientResolutionManager;

    @Autowired
    public ServiceDeskNotificationHelperImpl(VpOriginManager originManager, CommentPermissionManager commentPermissionManager, GlobalNotificationsManager globalNotificationManager, ServiceDeskInternalManager serviceDeskManager, CustomerInvolvedService customerInvolvedService, RecipientResolutionManager recipientResolutionManager) {
        this.originManager = originManager;
        this.commentPermissionManager = commentPermissionManager;
        this.globalNotificationManager = globalNotificationManager;
        this.serviceDeskManager = serviceDeskManager;
        this.customerInvolvedService = customerInvolvedService;
        this.recipientResolutionManager = recipientResolutionManager;
    }

    @Override
    public List<CheckedUser> getSubscribedNotificationRecipientsExcludingSender(Issue issue, CheckedUser sender) {
        if (!this.canSendNotification(issue)) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.retrieveAllCustomersSubscribedExcludingSender(issue, sender));
    }

    @Override
    public List<CheckedUser> getSubscribedNotificationRecipientsExcludingSenderAlwaysIncludingReporter(Issue issue, CheckedUser sender) {
        if (!this.canSendNotification(issue)) {
            return Collections.emptyList();
        }
        Set<CheckedUser> recipientsWithReporter = this.addReporterIgnoringSubscription(issue, this.retrieveAllCustomersSubscribedExcludingSender(issue, sender));
        return ImmutableList.copyOf(recipientsWithReporter);
    }

    private Set<CheckedUser> retrieveAllCustomersSubscribedExcludingSender(Issue issue, CheckedUser sender) {
        RecipientConfiguration configuration = RecipientConfiguration.newBuilder().addRecipient(RecipientType.ALL_CUSTOMERS_INVOLVED).setExcludedUser(Option.some((Object)sender)).build();
        return (Set)this.recipientResolutionManager.resolveRecipients(issue, configuration).fold(anError -> Collections.emptySet(), ImmutableSet::copyOf);
    }

    private Set<CheckedUser> addReporterIgnoringSubscription(Issue issue, Set<CheckedUser> recipients) {
        return ImmutableSet.builder().addAll(recipients).addAll((Iterable)this.customerInvolvedService.getMembersForTypes(issue, new CustomerInvolvedType[]{CustomerInvolvedType.REPORTER})).build();
    }

    private boolean hasAccessToRequest(Issue issue, CheckedUser reporter) {
        return this.customerInvolvedService.hasAccessToRequest(reporter, issue);
    }

    @Override
    public boolean doSDNotificationSendingRulesApply(CheckedUser recipient, Issue issue) {
        return this.canSendNotification(issue) && this.hasAccessToRequest(issue, recipient);
    }

    @Override
    public boolean canSendNotification(Issue issue) {
        return this.isGlobalNotifcationOnAndSDEnabledAndHasOriginField(issue);
    }

    @Override
    public boolean doSDNotificationFilteringRulesApply(CheckedUser recipient, Issue issue) {
        return this.isGlobalNotifcationOnAndSDEnabledAndHasOriginField(issue) && this.hasAccessToRequest(issue, recipient);
    }

    private boolean isGlobalNotifcationOnAndSDEnabledAndHasOriginField(Issue issue) {
        return !this.globalNotificationManager.isNotificationDisabled() && this.serviceDeskManager.isServiceDeskEnabled(issue.getProjectObject()) && this.hasOriginField(issue);
    }

    @Override
    public boolean canUserViewComment(CheckedUser user, Comment comment) {
        return this.commentPermissionManager.hasBrowsePermission(user.forJIRA(), comment);
    }

    private boolean hasOriginField(Issue issue) {
        return Option.option((Object)this.originManager.lookup(issue)).isDefined();
    }
}

