/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantUpdateParameters;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;

@Internal
public class RequestParticipantUpdateParametersImpl
implements RequestParticipantUpdateParameters {
    private final CustomerRequest customerRequest;
    private final Set<ApplicationUser> requestParticipants;

    private RequestParticipantUpdateParametersImpl(CustomerRequest customerRequest, Set<ApplicationUser> requestParticipants) {
        this.customerRequest = customerRequest;
        this.requestParticipants = requestParticipants;
    }

    public CustomerRequest customerRequest() {
        return this.customerRequest;
    }

    public Set<ApplicationUser> requestParticipants() {
        return this.requestParticipants;
    }

    public static RequestParticipantUpdateParameters.Builder builder() {
        return new RequestParticipantUpdateParametersBuilderImpl();
    }

    private static final class RequestParticipantUpdateParametersBuilderImpl
    implements RequestParticipantUpdateParameters.Builder {
        private CustomerRequest customerRequest;
        private Set<ApplicationUser> requestParticipants = new HashSet<ApplicationUser>();

        private RequestParticipantUpdateParametersBuilderImpl() {
        }

        public RequestParticipantUpdateParameters.Builder customerRequest(CustomerRequest customerRequest) {
            this.customerRequest = customerRequest;
            return this;
        }

        public RequestParticipantUpdateParameters.Builder requestParticipant(ApplicationUser requestParticipant) {
            this.requestParticipants.add(requestParticipant);
            return this;
        }

        public RequestParticipantUpdateParameters.Builder requestParticipants(Set<ApplicationUser> requestParticipants) {
            this.requestParticipants.addAll(requestParticipants);
            return this;
        }

        public RequestParticipantUpdateParameters build() {
            return new RequestParticipantUpdateParametersImpl(this.customerRequest, (Set)ImmutableSet.copyOf(this.requestParticipants));
        }
    }
}

