/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.report;

import com.atlassian.servicedesk.internal.api.report.SeriesDataType;
import com.atlassian.servicedesk.internal.feature.report.series.SeriesImpl;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import io.atlassian.fugue.Option;
import org.apache.log4j.Logger;

class SeriesMapper
extends MappingProjection<SeriesImpl> {
    private static final Logger LOG = Logger.getLogger(SeriesMapper.class);

    SeriesMapper() {
        super(SeriesImpl.class, new Expression[]{Tables.SERIES.ID, Tables.SERIES.REPORT_ID, Tables.SERIES.SERIES_LABEL, Tables.SERIES.JQL, Tables.SERIES.COLOR, Tables.SERIES.SERIES_DATA_TYPE, Tables.SERIES.TIME_METRIC_ID, Tables.SERIES.GOAL_ID});
    }

    protected SeriesImpl map(Tuple tuple) {
        if (tuple.get(Tables.SERIES.ID) == null) {
            return null;
        }
        Integer reportIdInt = (Integer)tuple.get(Tables.SERIES.REPORT_ID);
        Long reportId = reportIdInt != null ? Long.valueOf(reportIdInt.longValue()) : null;
        Option timeMetricId = Option.option((Object)tuple.get(Tables.SERIES.TIME_METRIC_ID));
        String label = (String)tuple.get((Expression)Tables.SERIES.SERIES_LABEL);
        Option jqlOption = Option.option((Object)tuple.get((Expression)Tables.SERIES.JQL));
        String color = (String)tuple.get((Expression)Tables.SERIES.COLOR);
        SeriesDataType dType = (SeriesDataType)SeriesDataType.getByKey((String)((String)tuple.get((Expression)Tables.SERIES.SERIES_DATA_TYPE))).getOrNull();
        if (dType == null) {
            LOG.warn((Object)("SeriesDataType value=" + (String)tuple.get((Expression)Tables.SERIES.SERIES_DATA_TYPE) + " is unknown"));
        }
        Option goalId = Option.option((Object)tuple.get(Tables.SERIES.GOAL_ID));
        return new SeriesImpl(((Integer)tuple.get(Tables.SERIES.ID)).longValue(), reportId, label, (String)jqlOption.getOrElse((Object)""), color, dType, (Option<Long>)timeMetricId, (Option<Integer>)goalId);
    }
}

