/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.report;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.api.report.ReportTimescale;
import com.atlassian.servicedesk.internal.api.report.ReportTimescaleManager;
import com.atlassian.servicedesk.internal.feature.report.ReportTimescaleImpl;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ReportTimescaleManagerImpl
implements ReportTimescaleManager {
    private final ReportTimescale defaultTimescale = new ReportTimescaleImpl(2L, ReportTimescale.DateRange.PAST_7_DAYS, ReportTimescale.TimeBreakdown.DAY, "sd.report.timescale.past7");
    @TenantAware(value=TenancyScope.TENANTLESS)
    private final Map<Long, ReportTimescale> timescales = new HashMap<Long, ReportTimescale>(){
        {
            this.put(1L, new ReportTimescaleImpl(1L, ReportTimescale.DateRange.PAST_48_HOURS, ReportTimescale.TimeBreakdown.HOUR, "sd.report.timescale.past48"));
            this.put(2L, ReportTimescaleManagerImpl.this.defaultTimescale);
            this.put(3L, new ReportTimescaleImpl(3L, ReportTimescale.DateRange.PAST_14_DAYS, ReportTimescale.TimeBreakdown.DAY, "sd.report.timescale.past14"));
            this.put(4L, new ReportTimescaleImpl(4L, ReportTimescale.DateRange.PAST_30_DAYS, ReportTimescale.TimeBreakdown.DAY, "sd.report.timescale.past30"));
            this.put(5L, new ReportTimescaleImpl(5L, ReportTimescale.DateRange.PAST_3_MONTHS, ReportTimescale.TimeBreakdown.DAY, "sd.report.timescale.past3byday"));
            this.put(6L, new ReportTimescaleImpl(6L, ReportTimescale.DateRange.PAST_3_MONTHS, ReportTimescale.TimeBreakdown.WEEK, "sd.report.timescale.past3byweek"));
            this.put(7L, new ReportTimescaleImpl(7L, ReportTimescale.DateRange.PAST_12_MONTHS, ReportTimescale.TimeBreakdown.WEEK, "sd.report.timescale.past12byweek"));
            this.put(8L, new ReportTimescaleImpl(8L, ReportTimescale.DateRange.PAST_12_MONTHS, ReportTimescale.TimeBreakdown.MONTH, "sd.report.timescale.past12bymonth"));
        }
    };

    public ReportTimescale getTimescale(long timescaleId) {
        return this.timescales.get(timescaleId);
    }

    public ReportTimescale getDefaultTimescale() {
        return this.defaultTimescale;
    }

    public DateTime getTimeScaleStartDate(DateTime endDate, ReportTimescale timescale) {
        DateTime unFlattenedStartDate = endDate.minus((ReadablePeriod)timescale.getRange().asJodaPeriod()).plus((ReadablePeriod)timescale.getBreakdown().asJodaPeriod());
        return timescale.getBreakdown().flattenDate(unFlattenedStartDate);
    }
}

