/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.report;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.report.Report;
import com.atlassian.servicedesk.internal.feature.report.ReportQStore;
import com.atlassian.servicedesk.internal.feature.report.SeriesMapper;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

@Component
@Repository
public class ReportQStoreImpl
implements ReportQStore {
    private final DatabaseAccessor dbAccessor;

    @Autowired
    public ReportQStoreImpl(DatabaseAccessor dbAccessor) {
        this.dbAccessor = dbAccessor;
    }

    @Override
    public Option<Report> getReport(int id) {
        return this.getReportWith((Predicate)Tables.REPORT.ID.eq((Object)id));
    }

    @Override
    public Option<Report> getReport(int id, ServiceDesk serviceDesk) {
        return this.getReportWith((Predicate)Tables.REPORT.ID.eq((Object)id));
    }

    private Option<Report> getReportWith(Predicate predicate) {
        Map reportSeriesMap = (Map)this.dbAccessor.runInTransaction(conn -> (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression)new ReportMapper()).from((Expression)Tables.REPORT)).leftJoin((EntityPath)Tables.SERIES)).on((Predicate)Tables.SERIES.REPORT_ID.eq(Tables.REPORT.ID))).where(predicate)).orderBy(Tables.SERIES.ID.asc())).transform(GroupBy.groupBy((Expression)new ReportMapper()).as((Expression)GroupBy.list((Expression)new SeriesMapper()))));
        Iterator iterator = reportSeriesMap.keySet().iterator();
        if (iterator.hasNext()) {
            Report report = (Report)iterator.next();
            return Option.option((Object)report.withSeries(new ArrayList(reportSeriesMap.getOrDefault(report, new ArrayList()))));
        }
        return Option.none();
    }

    @Override
    public Option<List<Report>> getAllReports(ServiceDesk serviceDesk) {
        List reports = (List)this.dbAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select((Expression)new ReportMapper()).from((Expression)Tables.REPORT)).where((Predicate)Tables.REPORT.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()))).fetch());
        return Option.some(new ArrayList(reports));
    }

    @Override
    public List<Report> getReportsForGoalIds(ServiceDesk serviceDesk, List<Integer> goalIds) {
        List reports = (List)this.dbAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression)new ReportMapper()).distinct()).from((Expression)Tables.REPORT)).leftJoin((EntityPath)Tables.SERIES)).on((Predicate)Tables.SERIES.REPORT_ID.eq(Tables.REPORT.ID))).where((Predicate)Tables.REPORT.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.SERIES.GOAL_ID.in((Collection)goalIds)))).fetch());
        return reports.stream().map(r -> r).collect(Collectors.toList());
    }

    @Override
    public List<Report> getReportsForTimeMetric(ServiceDesk serviceDesk, long timeMetric) {
        List reports = (List)this.dbAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression)new ReportMapper()).distinct()).from((Expression)Tables.REPORT)).leftJoin((EntityPath)Tables.SERIES)).on((Predicate)Tables.SERIES.REPORT_ID.eq(Tables.REPORT.ID))).where((Predicate)Tables.REPORT.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.SERIES.TIME_METRIC_ID.eq((Object)timeMetric)))).fetch());
        return reports.stream().map(r -> r).collect(Collectors.toList());
    }

    @Override
    public Option<Report> createReport(ServiceDesk serviceDesk, Report report) {
        Timestamp now = new Timestamp(new Date().getTime());
        Integer id = (Integer)this.dbAccessor.runInTransaction(conn -> (Integer)conn.insert((RelationalPath)Tables.REPORT).set((Path)Tables.REPORT.NAME, (Object)report.getName()).set(Tables.REPORT.REPORT_ORDER, (Object)report.getOrder()).set((Path)Tables.REPORT.REPORT_TYPE, (Object)report.getReportTypeKey()).set(Tables.REPORT.TARGET, (Object)report.getTarget()).set(Tables.REPORT.SERVICE_DESK_ID, (Object)serviceDesk.getId()).set(Tables.REPORT.CREATED_DATE, (Object)now).set(Tables.REPORT.UPDATED_DATE, (Object)now).executeWithKey(Tables.REPORT.ID));
        return this.getReport(id, serviceDesk);
    }

    @Override
    public boolean deleteReport(int reportId) {
        long deleted = (Long)this.dbAccessor.runInTransaction(conn -> {
            conn.delete((RelationalPath)Tables.SERIES).where((Predicate)Tables.SERIES.REPORT_ID.eq((Object)reportId)).execute();
            return conn.delete((RelationalPath)Tables.REPORT).where((Predicate)Tables.REPORT.ID.eq((Object)reportId)).execute();
        });
        return deleted > 0L;
    }

    @Override
    public Option<Report> updateReport(Report report) {
        Timestamp now = new Timestamp(new Date().getTime());
        this.dbAccessor.runInTransaction(conn -> conn.update((RelationalPath)Tables.REPORT).set((Path)Tables.REPORT.NAME, (Object)report.getName()).set(Tables.REPORT.REPORT_ORDER, (Object)report.getOrder()).set((Path)Tables.REPORT.REPORT_TYPE, (Object)report.getReportTypeKey()).set(Tables.REPORT.UPDATED_DATE, (Object)now).set(Tables.REPORT.TARGET, (Object)report.getTarget()).where((Predicate)Tables.REPORT.ID.eq((Object)report.getId().intValue())).execute());
        return this.getReport(report.getId().intValue());
    }

    class ReportMapper
    extends MappingProjection<Report> {
        ReportMapper() {
            super(Report.class, new Expression[]{Tables.REPORT.ID, Tables.REPORT.SERVICE_DESK_ID, Tables.REPORT.NAME, Tables.REPORT.REPORT_TYPE, Tables.REPORT.REPORT_ORDER, Tables.REPORT.TARGET});
        }

        protected Report map(Tuple tuple) {
            return new Report(Long.valueOf(((Integer)tuple.get(Tables.REPORT.ID)).longValue()), Long.valueOf(((Integer)tuple.get(Tables.REPORT.SERVICE_DESK_ID)).longValue()), (String)tuple.get((Expression)Tables.REPORT.NAME), Option.option((Object)tuple.get((Expression)Tables.REPORT.REPORT_TYPE)), (Integer)tuple.get(Tables.REPORT.REPORT_ORDER), new ArrayList(), (Long)tuple.get(Tables.REPORT.TARGET));
        }
    }
}

