/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.queue;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.thread.OffRequestThreadExecutor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.queue.Queue;
import com.atlassian.servicedesk.api.queue.QueueQuery;
import com.atlassian.servicedesk.api.queue.QueueRequestQuery;
import com.atlassian.servicedesk.api.queue.QueueService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.queues.InternalQueueService;
import com.atlassian.servicedesk.internal.cache.CacheClearer;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueSearchService;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectServiceScala;
import com.atlassian.servicedesk.internal.feature.queue.QueueImpl;
import com.atlassian.servicedesk.internal.feature.queue.QueueInternal;
import com.atlassian.servicedesk.internal.feature.queue.QueueQueryImpl;
import com.atlassian.servicedesk.internal.feature.queue.QueueRequestQueryImpl;
import com.atlassian.servicedesk.internal.feature.queue.QueueServiceInternal;
import com.atlassian.servicedesk.internal.feature.queue.QueueServiceOffThreadRegistration;
import com.atlassian.servicedesk.internal.utils.CacheUtil;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import io.atlassian.fugue.Suppliers;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={QueueService.class, InternalQueueService.class})
public class QueueServiceImpl
implements InternalQueueService,
QueueService,
QueueServiceOffThreadRegistration {
    private static final Logger log = LoggerFactory.getLogger(QueueServiceImpl.class);
    private static final int POOL_SIZE = 5;
    private static final int KEEP_ALIVE_MINUTES = 10;
    public static final String EXPIRY_MILLIS_PROPERTY_KEY = "sd.query.service.cache.expiry.timeout.millis";
    public static final int EXPIRY_MILLIS_DEFAULT = (int)TimeUnit.MINUTES.toMillis(2L);
    private final UserFactory userFactory;
    private final QueueServiceInternal queueServiceInternal;
    private final InternalServiceDeskService internalServiceDeskService;
    private final ServiceDeskIssueSearchService serviceDeskIssueSearchService;
    private final OffRequestThreadExecutor offRequestThreadExecutor;
    private final GlobalPropertyDao globalPropertyDao;
    private final CacheClearer cacheClearer;
    private final ServiceDeskProjectServiceScala serviceDeskProjectService;
    private final ServiceDeskIssueService serviceDeskIssueService;
    private final Cache<String, Pair<Long, Option<Long>>> queueCountCache;
    private final AtomicReference<ThreadPoolExecutor> threadPoolExecutorRef;

    @Autowired
    public QueueServiceImpl(UserFactory userFactory, QueueServiceInternal queueServiceInternal, InternalServiceDeskService internalServiceDeskService, ServiceDeskIssueSearchService serviceDeskIssueSearchService, OffRequestThreadExecutor offRequestThreadExecutor, ServiceDeskProjectServiceScala serviceDeskProjectService, ServiceDeskIssueService serviceDeskIssueService, CacheManager cacheManager, GlobalPropertyDao globalPropertyDao, CacheClearer cacheClearer) {
        this.userFactory = userFactory;
        this.queueServiceInternal = queueServiceInternal;
        this.internalServiceDeskService = internalServiceDeskService;
        this.serviceDeskIssueSearchService = serviceDeskIssueSearchService;
        this.offRequestThreadExecutor = offRequestThreadExecutor;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.serviceDeskIssueService = serviceDeskIssueService;
        this.globalPropertyDao = globalPropertyDao;
        this.cacheClearer = cacheClearer;
        this.threadPoolExecutorRef = new AtomicReference();
        this.queueCountCache = cacheManager.getCache(CacheUtil.standardName(this, "queueCountCache"), null, new CacheSettingsBuilder().expireAfterWrite(1L, TimeUnit.HOURS).expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(5000).build());
        this.queueCountCache.removeAll();
    }

    @PostConstruct
    private void postConstruction() {
        this.cacheClearer.registerCacheClearing(() -> this.queueCountCache.removeAll());
    }

    @Override
    public void register() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), ThreadFactories.named((String)"ServiceDeskQueueCount").type(ThreadFactories.Type.DAEMON).uncaughtExceptionHandler((thread, exception) -> log.error("Uncaught exception thrown from executor", exception)).build());
        executor.allowCoreThreadTimeOut(true);
        log.debug("Created executor for handing lazy cache loading of queue counts");
        this.threadPoolExecutorRef.set(executor);
    }

    @Override
    public void unregister() {
        ThreadPoolExecutor oldValue = this.threadPoolExecutorRef.getAndSet(null);
        if (oldValue != null) {
            List<Runnable> runnables = oldValue.shutdownNow();
            log.debug("Shutting down executor that had {} runnables left in queue", (Object)runnables.size());
        }
    }

    public QueueQuery.Builder newQueueQueryBuilder() {
        return QueueQueryImpl.newBuilder();
    }

    public io.atlassian.fugue.Either<AnError, PagedResponse<Queue>> getQueuesWithCachedCount(ApplicationUser user, QueueQuery query) {
        return StepsConverters.newerEither(this.performGetQueues(user, query, true));
    }

    public Either<AnError, PagedResponse<Queue>> getQueues(ApplicationUser user, QueueQuery query) {
        return this.performGetQueues(user, query, false);
    }

    private Either<AnError, PagedResponse<Queue>> performGetQueues(ApplicationUser user, QueueQuery query, boolean useCacheCount) {
        io.atlassian.fugue.Either result = query.queueId().isPresent() ? Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.internalServiceDeskService.getServiceDeskById(checkedUser, query.serviceDeskId())).then(this::getProjectFromServiceDesk).then((checkedUser, serviceDeskInternal, project) -> this.queueServiceInternal.getQueue((Long)query.queueId().get(), (CheckedUser)checkedUser, (Project)project)).yield((checkedUser, serviceDeskInternal, project, queueInternal) -> PagedResponseImpl.fromSingle((boolean)false, (Object)this.toApiQueue((CheckedUser)checkedUser, (QueueInternal)queueInternal, (ServiceDesk)serviceDeskInternal, (Project)project, query.includeIssueCount(), useCacheCount)).build()) : Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.internalServiceDeskService.getServiceDeskById(checkedUser, query.serviceDeskId())).then(this::getProjectFromServiceDesk).then((checkedUser, serviceDeskInternal, project) -> this.queueServiceInternal.getQueuesForProject((CheckedUser)checkedUser, (Project)project)).yield((checkedUser, serviceDeskInternal, project, serviceDeskQueueInternals) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)query.pagedRequest(), (List)serviceDeskQueueInternals).map(internalQueue -> this.toApiQueue((CheckedUser)checkedUser, (QueueInternal)internalQueue, (ServiceDesk)serviceDeskInternal, (Project)project, query.includeIssueCount(), useCacheCount)));
        return StepsConverters.olderEither((io.atlassian.fugue.Either)result);
    }

    public QueueRequestQuery.Builder newQueueRequestQueryBuilder() {
        return QueueRequestQueryImpl.newBuilder();
    }

    public Either<AnError, PagedResponse<Issue>> getRequestsByQueue(ApplicationUser user, QueueRequestQuery query) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.internalServiceDeskService.getServiceDeskById(checkedUser, query.serviceDeskId())).then(this::getProjectFromServiceDesk).then((checkedUser, serviceDeskInternal, project) -> this.queueServiceInternal.getQueue(query.queueId(), (CheckedUser)checkedUser, (Project)project)).then((checkedUser, serviceDeskInternal, project, queueInternal) -> this.getIssueInQueue((CheckedUser)checkedUser, (QueueInternal)queueInternal, (Project)project, query)).yield((checkedUser, serviceDeskInternal, queueInternal, project, searchResults) -> PagedResponseImpl.from((Iterable)searchResults.getIssues(), (searchResults.getEnd() < searchResults.getTotal() ? 1 : 0) != 0).pageRequest(query.pagedRequest()).build()));
    }

    public int getQueueLimitForProject() {
        return this.queueServiceInternal.getQueuesLimitForProject();
    }

    private io.atlassian.fugue.Either<AnError, SearchResults> getIssueInQueue(CheckedUser user, QueueInternal queueInternal, Project project, QueueRequestQuery requestQuery) {
        return Steps.begin((io.atlassian.fugue.Either)this.internalServiceDeskService.getServiceDeskForProject(user, project, false)).then(() -> this.buildQueueJql(user, queueInternal, project)).then((serviceDesk, query) -> this.serviceDeskIssueSearchService.getIssues(user, (ServiceDesk)serviceDesk, (Query)query, requestQuery.pagedRequest().getStart(), requestQuery.pagedRequest().getLimit())).yield((serviceDesk, query, searchResults) -> searchResults);
    }

    private Queue toApiQueue(CheckedUser checkedUser, QueueInternal queueInternal, ServiceDesk serviceDesk, Project project, boolean shouldCount, boolean useCachedCount) {
        String completeJql = this.serviceDeskIssueService.limitToProject(checkedUser, queueInternal.getJql(), project);
        return new QueueImpl(queueInternal.getId(), serviceDesk.getId(), queueInternal.getName(), completeJql, this.getIssueCountIfNeeded(shouldCount, useCachedCount, checkedUser, queueInternal, serviceDesk, project), queueInternal.getColumns());
    }

    private io.atlassian.fugue.Either<AnError, Query> buildQueueJql(CheckedUser checkedUser, QueueInternal queue, Project project) {
        return this.serviceDeskIssueSearchService.parseQuery(checkedUser, this.serviceDeskIssueService.limitToProject(checkedUser, queue.getJql(), project));
    }

    private io.atlassian.fugue.Either<AnError, Project> getProjectFromServiceDesk(CheckedUser checkedUser, ServiceDesk serviceDesk) {
        return this.serviceDeskProjectService.getProjectById(checkedUser, serviceDesk.getProjectId());
    }

    private Optional<Long> getIssueCountIfNeeded(boolean shouldCount, boolean useCachedCount, CheckedUser checkedUser, QueueInternal queueInternal, ServiceDesk serviceDesk, Project project) {
        if (shouldCount) {
            return Steps.begin((Option)this.buildQueueJql(checkedUser, queueInternal, project).toOption()).then(query -> this.getCountForQueue(useCachedCount, checkedUser, serviceDesk, (Query)query)).yield((query, issueCount) -> issueCount).toOptional();
        }
        return Optional.empty();
    }

    private Option<Long> getCountForQueue(boolean useCachedCount, CheckedUser checkedUser, ServiceDesk serviceDesk, Query query) {
        String cacheKey = QueueServiceImpl.buildQueryCountCacheKey(checkedUser, serviceDesk, query.getQueryString());
        if (useCachedCount) {
            Option pairOption = Option.option((Object)this.queueCountCache.get((Object)cacheKey));
            boolean considerExpired = (Boolean)pairOption.map(Pair::left).map(DateTime::new).map(time -> time.plusMillis(this.getCacheExpiryTimeout()).isBeforeNow()).getOr(Suppliers.alwaysTrue());
            if (considerExpired) {
                this.executeTask(() -> this.performAndCacheQueryCountIssueSearch(checkedUser, cacheKey, serviceDesk, query));
            }
            return pairOption.flatMap(Pair::right);
        }
        return this.performAndCacheQueryCountIssueSearch(checkedUser, cacheKey, serviceDesk, query);
    }

    private Option<Long> performAndCacheQueryCountIssueSearch(CheckedUser checkedUser, String cacheKey, ServiceDesk serviceDesk, Query query) {
        Option count = this.serviceDeskIssueSearchService.countIssues(checkedUser, serviceDesk, query).toOption();
        this.queueCountCache.put((Object)cacheKey, (Object)Pair.pair((Object)System.currentTimeMillis(), (Object)count));
        return count;
    }

    private void executeTask(Runnable runnable) {
        ThreadPoolExecutor executor = this.threadPoolExecutorRef.get();
        if (executor != null) {
            executor.execute(() -> this.offRequestThreadExecutor.execute(runnable));
        } else {
            runnable.run();
        }
    }

    private int getCacheExpiryTimeout() {
        Long longProperty = this.globalPropertyDao.getLongProperty(EXPIRY_MILLIS_PROPERTY_KEY);
        if (longProperty == null) {
            try {
                this.globalPropertyDao.setLongProperty(EXPIRY_MILLIS_PROPERTY_KEY, Long.valueOf(EXPIRY_MILLIS_DEFAULT));
            }
            catch (Exception e) {
                log.debug("There was a problem saving the property '{}'", (Object)EXPIRY_MILLIS_PROPERTY_KEY);
            }
            return EXPIRY_MILLIS_DEFAULT;
        }
        return longProperty.intValue();
    }

    private static String buildQueryCountCacheKey(CheckedUser user, ServiceDesk serviceDesk, String queryString) {
        return ImmutableList.of((Object)user.getKey(), (Object)String.valueOf(serviceDesk.getProjectId()), (Object)queryString).stream().collect(Collectors.joining("..++.."));
    }
}

