/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.queue;

import com.atlassian.servicedesk.api.queue.QueueRequestQuery;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;

class QueueRequestQueryImpl
implements QueueRequestQuery {
    private final long serviceDeskId;
    private final long queueId;
    private final LimitedPagedRequest pagedRequest;

    private QueueRequestQueryImpl(long serviceDeskId, long queueId, LimitedPagedRequest pagedRequest) {
        this.serviceDeskId = serviceDeskId;
        this.queueId = queueId;
        this.pagedRequest = pagedRequest;
    }

    public long serviceDeskId() {
        return this.serviceDeskId;
    }

    public long queueId() {
        return this.queueId;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.pagedRequest;
    }

    static QueueRequestQuery.Builder newBuilder() {
        return new QueueRequestBuilderImpl();
    }

    private static class QueueRequestBuilderImpl
    implements QueueRequestQuery.Builder {
        private long serviceDeskId;
        private long queueId;
        private LimitedPagedRequest pagedRequest = LimitedPagedRequestImpl.create((int)50);

        private QueueRequestBuilderImpl() {
        }

        public QueueRequestQuery.Builder serviceDeskId(long serviceDeskId) {
            this.serviceDeskId = serviceDeskId;
            return this;
        }

        public QueueRequestQuery.Builder queueId(long queueId) {
            this.queueId = queueId;
            return this;
        }

        public QueueRequestQuery.Builder pagedRequest(PagedRequest pagedRequest) {
            this.pagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)50);
            return this;
        }

        public QueueRequestQuery build() {
            return new QueueRequestQueryImpl(this.serviceDeskId, this.queueId, this.pagedRequest);
        }
    }
}

