/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.queue;

import com.atlassian.servicedesk.api.queue.QueueQuery;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;

class QueueQueryImpl
implements QueueQuery {
    private final long serviceDeskId;
    private final Optional<Long> queueId;
    private final boolean includeIssueCount;
    private final LimitedPagedRequest pagedRequest;

    private QueueQueryImpl(long serviceDeskId, Optional<Long> queueId, boolean includeIssueCount, LimitedPagedRequest pagedRequest) {
        this.serviceDeskId = serviceDeskId;
        this.includeIssueCount = includeIssueCount;
        this.queueId = (Optional)Preconditions.checkNotNull(queueId);
        this.pagedRequest = pagedRequest;
    }

    public long serviceDeskId() {
        return this.serviceDeskId;
    }

    public Optional<Long> queueId() {
        return this.queueId;
    }

    public boolean includeIssueCount() {
        return this.includeIssueCount;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.pagedRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueQueryImpl that = (QueueQueryImpl)o;
        return Objects.equal((Object)this.serviceDeskId, (Object)that.serviceDeskId) && Objects.equal((Object)this.includeIssueCount, (Object)that.includeIssueCount) && Objects.equal(this.queueId, that.queueId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.serviceDeskId, this.queueId, this.includeIssueCount});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("serviceDeskId", this.serviceDeskId).add("queueId", this.queueId).add("includeIssueCount", this.includeIssueCount).toString();
    }

    static QueueQuery.Builder newBuilder() {
        return new QueueQueryBuilderImpl();
    }

    private static class QueueQueryBuilderImpl
    implements QueueQuery.Builder {
        private long serviceDeskId;
        private Optional<Long> queueId = Optional.empty();
        private boolean includeIssueCount = false;
        private LimitedPagedRequest pagedRequest = LimitedPagedRequestImpl.create((int)50);

        private QueueQueryBuilderImpl() {
        }

        public QueueQuery.Builder serviceDeskId(long serviceDeskId) {
            this.serviceDeskId = serviceDeskId;
            return this;
        }

        public QueueQuery.Builder queueId(long queueId) {
            this.queueId = Optional.of(queueId);
            return this;
        }

        public QueueQuery.Builder includeIssueCount(boolean includeIssueCount) {
            this.includeIssueCount = includeIssueCount;
            return this;
        }

        public QueueQuery.Builder pagedRequest(PagedRequest pagedRequest) {
            this.pagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)50);
            return this;
        }

        public QueueQuery build() {
            return new QueueQueryImpl(this.serviceDeskId, this.queueId, this.includeIssueCount, this.pagedRequest);
        }
    }
}

