/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.people;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.api.util.CollectorsHelper;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueService;
import com.atlassian.servicedesk.internal.feature.people.AgentWithIssuesCount;
import com.atlassian.servicedesk.internal.feature.people.AgentWorkloadSearchResults;
import com.atlassian.servicedesk.internal.feature.people.AgentWorkloadService;
import com.atlassian.servicedesk.internal.feature.people.AgentWorkloadServiceHelper;
import com.atlassian.servicedesk.internal.feature.usermanagement.AgentService;
import com.atlassian.servicedesk.internal.rest.responses.AgentWorkloadDetails;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgentWorkloadServiceImpl
implements AgentWorkloadService {
    private final ServiceDeskIssueService serviceDeskIssueService;
    private final AgentService agentService;
    private final UserSearchManager userSearchManager;
    private final UserSearchManagerHelper userSearchManagerHelper;
    private final AgentWorkloadServiceHelper agentWorkloadServiceHelper;
    private static final int DEFAULT_AGENT_ISSUE_COUNT = 0;
    private static final int AGENTS_BY_PROJECT_LIMIT = -1;

    @Autowired
    public AgentWorkloadServiceImpl(ServiceDeskIssueService serviceDeskIssueService, AgentService agentService, UserSearchManager userSearchManager, UserSearchManagerHelper userSearchManagerHelper, AgentWorkloadServiceHelper agentWorkloadServiceHelper) {
        this.serviceDeskIssueService = serviceDeskIssueService;
        this.agentService = agentService;
        this.userSearchManager = userSearchManager;
        this.userSearchManagerHelper = userSearchManagerHelper;
        this.agentWorkloadServiceHelper = agentWorkloadServiceHelper;
    }

    @Override
    @TenantAware(value=TenancyScope.SUPPRESS)
    public Either<AnError, List<AgentWithIssuesCount>> getAgentsWithUnresolvedIssueCountSortedByHighestCountFirst(CheckedUser user, ServiceDesk sd, Project project) {
        return this.agentService.getAgentsByProject(user, project, -1).map(agentsByProject -> {
            Map<String, Integer> userKeyToCount = this.serviceDeskIssueService.getAssignedAndUnresolvedIssueCountByUserKey(user, project);
            return agentsByProject.stream().map(agent -> this.extractAgentWithIssueCount((CheckedUser)agent, userKeyToCount)).sorted(this::compareAgentWithCount).collect(Collectors.toList());
        });
    }

    @Override
    public Either<AnError, AgentWorkloadSearchResults> getFilteredAgentsWithWorkloadDetails(CheckedUser user, ServiceDesk sd, Project project, String query, LimitedPagedRequest pagedRequest) {
        return this.getAgentsWithUnresolvedIssueCountSortedByHighestCountFirst(user, sd, project).map(agentWithIssuesCounts -> this.getAllAgentWorkloadSearchResults((List<AgentWithIssuesCount>)agentWithIssuesCounts, user, sd, project, query, pagedRequest));
    }

    private AgentWorkloadSearchResults getAllAgentWorkloadSearchResults(List<AgentWithIssuesCount> agentsWithAssignedIssueCounts, CheckedUser user, ServiceDesk sd, Project project, String query, LimitedPagedRequest pagedRequest) {
        List<Issue> currentIssueBatch;
        List<AgentWithIssuesCount> allFilteredAgentsWithIssueCounts = this.filterAgentsForQuery(agentsWithAssignedIssueCounts, query);
        List pagedAgentsWithIssueCounts = allFilteredAgentsWithIssueCounts.stream().skip(pagedRequest.getStart()).limit(this.getSearchLimit(pagedRequest)).collect(Collectors.toList());
        List<CheckedUser> topAgents = pagedAgentsWithIssueCounts.stream().map(AgentWithIssuesCount::getAgent).collect(Collectors.toList());
        int currentPage = 0;
        HashMap<String, AgentWorkloadDetails> resultsMap = new HashMap<String, AgentWorkloadDetails>();
        do {
            currentIssueBatch = this.serviceDeskIssueService.getPagedAssignedAndUnresolvedIssues(user, project, topAgents, currentPage);
            Map<String, List<Issue>> currentBatchGroupedByAssignee = this.groupBatchByAssignee(currentIssueBatch);
            Map<String, AgentWorkloadDetails> workloadDataForCurrentBatch = this.agentWorkloadServiceHelper.getAgentWorkloadData(user, sd, project, currentBatchGroupedByAssignee);
            resultsMap.putAll(this.combineWorkloadDataMaps(workloadDataForCurrentBatch, resultsMap));
            ++currentPage;
        } while (!currentIssueBatch.isEmpty());
        return new AgentWorkloadSearchResults(allFilteredAgentsWithIssueCounts.size(), topAgents, resultsMap);
    }

    private Map<String, List<Issue>> groupBatchByAssignee(List<Issue> issueList) {
        return issueList.stream().collect(Collectors.groupingBy(Issue::getAssigneeId));
    }

    private List<AgentWithIssuesCount> filterAgentsForQuery(List<AgentWithIssuesCount> agentsWithIssuesCount, String query) {
        String trimmedQuery = StringUtils.trim((String)query);
        if (StringUtils.isNotEmpty((String)trimmedQuery)) {
            UserSearchParams userSearchParams = this.userSearchManagerHelper.buildActiveOnlyUserSearchParams(Option.none());
            Map agentsToFilter = (Map)agentsWithIssuesCount.stream().collect(CollectorsHelper.toLinkedHashMap(agentWithIssuesCount -> agentWithIssuesCount.getAgent().forJIRA(), Function.identity()));
            return this.userSearchManager.filterUsers((List)ImmutableList.copyOf(agentsToFilter.keySet()), query, userSearchParams, false).map(agentsToFilter::get).collect(Collectors.toList());
        }
        return agentsWithIssuesCount;
    }

    private Map<String, AgentWorkloadDetails> combineWorkloadDataMaps(Map<String, AgentWorkloadDetails> workloadDataMapA, Map<String, AgentWorkloadDetails> workloadDataMapB) {
        workloadDataMapA.replaceAll((agentKey, newWorkloadDetailsEntry) -> {
            Option existingAgentWorkloadDetailsOption = Option.option(workloadDataMapB.get(agentKey));
            return (AgentWorkloadDetails)existingAgentWorkloadDetailsOption.fold(() -> newWorkloadDetailsEntry, existingAgentWorkloadDetails -> this.joinWorkloadDetails((AgentWorkloadDetails)newWorkloadDetailsEntry, (AgentWorkloadDetails)existingAgentWorkloadDetails));
        });
        return workloadDataMapA;
    }

    private AgentWorkloadDetails joinWorkloadDetails(AgentWorkloadDetails agentWorkloadDetailsA, AgentWorkloadDetails agentWorkloadDetailsB) {
        return new AgentWorkloadDetails(agentWorkloadDetailsA.getTotal() + agentWorkloadDetailsB.getTotal(), agentWorkloadDetailsA.getBreachedCount() + agentWorkloadDetailsB.getBreachedCount(), agentWorkloadDetailsA.getUrgentCount() + agentWorkloadDetailsB.getUrgentCount(), agentWorkloadDetailsA.getNormalCount() + agentWorkloadDetailsB.getNormalCount(), agentWorkloadDetailsA.getJql());
    }

    private AgentWithIssuesCount extractAgentWithIssueCount(CheckedUser agent, Map<String, Integer> userKeysToCounts) {
        return new AgentWithIssuesCount(agent, userKeysToCounts.getOrDefault(agent.getKey(), 0));
    }

    private int compareAgentWithCount(AgentWithIssuesCount agentWithIssuesCountA, AgentWithIssuesCount agentWithIssuesCountB) {
        return Integer.compare(agentWithIssuesCountB.getIssuesCount(), agentWithIssuesCountA.getIssuesCount());
    }

    private int getSearchLimit(LimitedPagedRequest pagedRequest) {
        return (int)this.maxInt(this.getActualRequestLimit(pagedRequest));
    }

    private int getActualRequestLimit(LimitedPagedRequest pagedRequest) {
        return Math.min(pagedRequest.getLimit(), pagedRequest.getMaxLimit() - pagedRequest.getStart());
    }

    private long maxInt(long number) {
        return Math.min(Integer.MAX_VALUE, number);
    }

    @Override
    public Either<AnError, AgentWorkloadSearchResults> getFilteredAgentsWithWorkloadDetails(CheckedUser user, ServiceDesk sd, Project project, String query, int limit) {
        return this.getAgentsWithUnresolvedIssueCountSortedByHighestCountFirst(user, sd, project).map(agentWithIssuesCounts -> this.getAllAgentWorkloadSearchResults((List<AgentWithIssuesCount>)agentWithIssuesCounts, user, sd, project, query, limit));
    }

    private AgentWorkloadSearchResults getAllAgentWorkloadSearchResults(List<AgentWithIssuesCount> agentsWithAssignedIssueCounts, CheckedUser user, ServiceDesk sd, Project project, String query, int limit) {
        List<Issue> currentIssueBatch;
        List<AgentWithIssuesCount> allFilteredAgentsWithIssueCounts = this.filterAgentsForQuery(agentsWithAssignedIssueCounts, query);
        List<AgentWithIssuesCount> topAgentsWithIssueCounts = this.getTopAgentResults(allFilteredAgentsWithIssueCounts, limit);
        List<CheckedUser> topAgents = topAgentsWithIssueCounts.stream().map(AgentWithIssuesCount::getAgent).collect(Collectors.toList());
        int currentPage = 0;
        HashMap<String, AgentWorkloadDetails> resultsMap = new HashMap<String, AgentWorkloadDetails>();
        do {
            currentIssueBatch = this.serviceDeskIssueService.getPagedAssignedAndUnresolvedIssues(user, project, topAgents, currentPage);
            Map<String, List<Issue>> currentBatchGroupedByAssignee = this.groupBatchByAssignee(currentIssueBatch);
            Map<String, AgentWorkloadDetails> workloadDataForCurrentBatch = this.agentWorkloadServiceHelper.getAgentWorkloadData(user, sd, project, currentBatchGroupedByAssignee);
            resultsMap.putAll(this.combineWorkloadDataMaps(workloadDataForCurrentBatch, resultsMap));
            ++currentPage;
        } while (!currentIssueBatch.isEmpty());
        return new AgentWorkloadSearchResults(allFilteredAgentsWithIssueCounts.size(), topAgents, resultsMap);
    }

    private List<AgentWithIssuesCount> getTopAgentResults(List<AgentWithIssuesCount> agentsResults, int limit) {
        int size = agentsResults.size();
        return agentsResults.subList(0, limit > size ? size : limit);
    }
}

