/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.passwordpolicy;

import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.rest.responses.PasswordPolicyDisabledResponse;
import com.atlassian.servicedesk.internal.rest.responses.PasswordPolicyResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PasswordPolicyResponseHelper {
    private final UserFactory userFactory;
    private final PasswordPolicyManager passwordPolicyManager;

    @Autowired
    public PasswordPolicyResponseHelper(UserFactory userFactory, PasswordPolicyManager passwordPolicyManager) {
        this.userFactory = userFactory;
        this.passwordPolicyManager = passwordPolicyManager;
    }

    public PasswordPolicyResponse getPasswordPolicyResponse() {
        UncheckedUser uncheckedUser = this.userFactory.getUncheckedUser();
        List<String> descriptionList = this.getDescriptionFromPasswordPolicyManager(!uncheckedUser.isAnonymous());
        return new PasswordPolicyDisabledResponse(descriptionList);
    }

    private List<String> getDescriptionFromPasswordPolicyManager(boolean hasLoggedInUser) {
        return this.passwordPolicyManager.getPolicyDescription(hasLoggedInUser);
    }
}

