/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.member;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.feature.organization.member.CustomerOrganizationMemberService;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.organization.setting.CustomerOrganizationSettingService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CustomerOrganizationMemberServiceImpl
implements CustomerOrganizationMemberService {
    private final FeatureManager featureManager;
    private final CommonErrors commonErrors;
    private final CustomerOrganizationError customerOrganizationError;
    private final CustomerOrganizationMemberManager organizationMemberManager;
    private final CustomerOrganizationSettingService customerOrganizationSettingService;
    private final ServiceDeskPermissions serviceDeskPermissions;

    @Autowired
    public CustomerOrganizationMemberServiceImpl(FeatureManager featureManager, CommonErrors commonErrors, CustomerOrganizationError customerOrganizationError, CustomerOrganizationMemberManager organizationMemberManager, CustomerOrganizationSettingService customerOrganizationSettingService, ServiceDeskPermissions serviceDeskPermissions) {
        this.featureManager = featureManager;
        this.commonErrors = commonErrors;
        this.customerOrganizationError = customerOrganizationError;
        this.organizationMemberManager = organizationMemberManager;
        this.customerOrganizationSettingService = customerOrganizationSettingService;
        this.serviceDeskPermissions = serviceDeskPermissions;
    }

    public Either<AnError, Unit> removeUsersFromOrganization(CheckedUser executingUser, CustomerOrganization customerOrganization, Set<CheckedUser> usersToRemove) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.customerOrganizationSettingService.canManageOrganizations(executingUser)) {
            return Either.left((Object)this.customerOrganizationError.NO_MANAGE_ORGANIZATION_PERMISSION());
        }
        this.organizationMemberManager.removeUserFromOrganization(usersToRemove, customerOrganization);
        return Either.right((Object)Unit.VALUE);
    }

    public Either<AnError, Set<ApplicationUser>> getOrganizationMembers(CheckedUser executingUser, Set<Integer> organizationIds) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.customerOrganizationSettingService.canViewAllOrganizations(executingUser)) {
            return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        return Either.right(this.organizationMemberManager.getOrganizationMembers(organizationIds));
    }

    public Set<ApplicationUser> getOrganizationMembersIgnorePermissionCheck(Set<Integer> organizationIds) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return new HashSet<ApplicationUser>();
        }
        return this.organizationMemberManager.getOrganizationMembers(organizationIds);
    }

    public Either<AnError, Collection<CustomerOrganization>> getUserOrganizationsInProjectAsAgent(CheckedUser executingUser, CheckedUser customer, Project project) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewAgentView((SDUser)executingUser, project)) {
            return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        return this.organizationMemberManager.getUserOrganizationsInProject(customer, project);
    }

    public Either<AnError, Collection<CustomerOrganization>> getUserOrganizationsInProjectAsCustomer(@Nonnull CheckedUser checkedUser, @Nonnull Project project) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewServiceDesk((SDUser)checkedUser, project)) {
            return Either.left((Object)this.commonErrors.SERVICE_DESK_PERMISSION_VIOLATION());
        }
        return this.organizationMemberManager.getUserOrganizationsInProject(checkedUser, project);
    }

    public Either<AnError, Collection<CustomerOrganization>> getMyOrganizations(@Nonnull CheckedUser executingUser) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return Either.right(this.organizationMemberManager.getOrganizationsForUser(executingUser));
    }

    public Either<AnError, Collection<CheckedUser>> addUsersToExistingOrganization(@Nonnull CheckedUser executingUser, @Nonnull Collection<CheckedUser> usersToAdd, @Nonnull Project project, @Nonnull CustomerOrganization customerOrganization) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.customerOrganizationSettingService.canManageOrganizationsInProject(executingUser, project)) {
            return Either.left((Object)this.customerOrganizationError.NO_MANAGE_ORGANIZATION_PERMISSION());
        }
        return this.organizationMemberManager.addUsersToExistingOrganization(usersToAdd, project, customerOrganization);
    }

    public Either<AnError, Collection<CheckedUser>> addUsersToNewOrExistingOrganization(@Nonnull CheckedUser executingUser, @Nonnull Collection<CheckedUser> usersToAdd, @Nonnull Project project, @Nonnull String orgName) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.customerOrganizationSettingService.canManageOrganizationsInProject(executingUser, project)) {
            return Either.left((Object)this.customerOrganizationError.NO_MANAGE_ORGANIZATION_PERMISSION());
        }
        return this.organizationMemberManager.addUsersToNewOrExistingOrganization(usersToAdd, project, orgName);
    }

    public Either<AnError, Unit> addUsers(@Nonnull CheckedUser executingUser, Set<CheckedUser> users, CustomerOrganization organization) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return Steps.begin(this.customerOrganizationSettingService.canManageOrganizationsEither(executingUser)).then(permissions -> this.organizationMemberManager.addUsers(users, organization)).yield((permissions, unit) -> unit);
    }
}

