/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.member;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationMemberQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationProjectQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.exceptions.OrganizationNotFoundException;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.organization.model.OrganizationProjectsList;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationUtil;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class CustomerOrganizationMemberManagerImpl
implements CustomerOrganizationMemberManager {
    private final CustomerOrganizationMemberQStore memberQStore;
    private final CustomerOrganizationProjectQStore projectQStore;
    private final CustomerOrganizationQStore organizationQStore;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final CommonErrors commonErrors;
    private final UserManager userManager;
    private final DatabaseAccessor databaseAccessor;
    private final CustomerOrganizationError organizationError;

    @Autowired
    public CustomerOrganizationMemberManagerImpl(CustomerOrganizationMemberQStore memberQStore, ServiceDeskInternalManager serviceDeskManager, CommonErrors commonErrors, UserManager userManager, DatabaseAccessor databaseAccessor, CustomerOrganizationError organizationError, CustomerOrganizationProjectQStore projectQStore, CustomerOrganizationQStore organizationQStore) {
        this.memberQStore = memberQStore;
        this.serviceDeskManager = serviceDeskManager;
        this.userManager = userManager;
        this.commonErrors = commonErrors;
        this.databaseAccessor = databaseAccessor;
        this.organizationError = organizationError;
        this.projectQStore = projectQStore;
        this.organizationQStore = organizationQStore;
    }

    @Override
    public void removeUserFromOrganization(Set<CheckedUser> usersToRemove, CustomerOrganization customerOrganization) {
        this.memberQStore.removeMembersFromOrganization(customerOrganization.getId(), CustomerOrganizationUtil.transformToUserKeys(usersToRemove));
    }

    @Override
    public Option<CustomerOrganization> getUserDefaultOrganizationInProject(CheckedUser user, Project project) {
        if (!this.serviceDeskManager.isServiceDeskEnabled(project)) {
            return Option.none();
        }
        List<CustomerOrganization> userOrganizations = this.memberQStore.getOrganizationsForUser(user.getKey(), project.getId());
        if (userOrganizations.size() == 1) {
            return Option.some((Object)userOrganizations.get(0));
        }
        return Option.none();
    }

    @Override
    public Either<AnError, Collection<CustomerOrganization>> getUserOrganizationsInProject(CheckedUser customer, Project project) {
        if (!this.serviceDeskManager.isServiceDeskEnabled(project)) {
            return Either.left((Object)this.commonErrors.NOT_A_SERVICEDESK_PROJECT());
        }
        return Either.right(this.memberQStore.getOrganizationsForUser(customer.getKey(), project.getId()));
    }

    @Override
    public Set<ApplicationUser> getOrganizationMembers(Set<Integer> organizationIds) {
        Set<String> memberUserKeys = this.memberQStore.getOrganizationMembers(organizationIds);
        return memberUserKeys.stream().map(arg_0 -> ((UserManager)this.userManager).getUserByKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Set<ApplicationUser> getOrganizationMembersForProject(Project project) {
        Set<Integer> organizationIds = this.projectQStore.getOrganizationsForProject(project.getId()).stream().map(CustomerOrganization::getId).collect(Collectors.toSet());
        return this.getOrganizationMembers(organizationIds);
    }

    @Override
    public boolean isMemberOfOrganization(CheckedUser user, int orgId) {
        return this.memberQStore.isMemberOfOrganization(user.getKey(), orgId);
    }

    @Override
    public List<CustomerOrganization> getOrganizationsForUser(CheckedUser checkedUser) {
        return this.memberQStore.getOrganizationsForUser(checkedUser.getKey());
    }

    @Override
    public Either<AnError, Collection<CheckedUser>> addUsersToExistingOrganization(Collection<CheckedUser> users, Project project, CustomerOrganization customerOrganization) {
        Either<AnError, Unit> validateResult = this.validateInput(users, project);
        if (validateResult.isLeft()) {
            return Either.left((Object)validateResult.left().get());
        }
        try {
            this.databaseAccessor.runInTransaction(databaseConnection -> {
                this.projectQStore.addOrganizationsToProject(Sets.newHashSet((Object[])new Integer[]{customerOrganization.getId()}), project.getId(), (DatabaseConnection)databaseConnection);
                this.memberQStore.addOrganizationMembers(customerOrganization.getId(), CustomerOrganizationUtil.transformToUserKeys(users), (DatabaseConnection)databaseConnection);
                return customerOrganization;
            });
        }
        catch (OrganizationNotFoundException ex) {
            return Either.left((Object)this.organizationError.ORGANISATION_NOT_FOUND(Sets.newHashSet((Object[])new Integer[]{customerOrganization.getId()})));
        }
        return Either.right(users);
    }

    @Override
    public Either<AnError, Collection<CheckedUser>> addUsersToNewOrExistingOrganization(Collection<CheckedUser> users, Project project, String orgName) {
        Either<AnError, Unit> validateResult = this.validateInput(users, project, orgName);
        if (validateResult.isLeft()) {
            return Either.left((Object)validateResult.left().get());
        }
        this.databaseAccessor.runInTransaction(databaseConnection -> {
            CustomerOrganization newOrgs = this.organizationQStore.getOrCreate(orgName, (DatabaseConnection)databaseConnection);
            this.projectQStore.addOrganizationsToProject(Sets.newHashSet((Object[])new Integer[]{newOrgs.getId()}), project.getId(), (DatabaseConnection)databaseConnection);
            this.memberQStore.addOrganizationMembers(newOrgs.getId(), CustomerOrganizationUtil.transformToUserKeys(users), (DatabaseConnection)databaseConnection);
            return newOrgs;
        });
        return Either.right(users);
    }

    @Override
    public Collection<CheckedUser> filterUsersNotInMyOrganization(CheckedUser user, Project project, Collection<CheckedUser> usersToCheck) {
        List<String> sameOrganizationMemberUserKeys = this.memberQStore.getMembersOfSameOrganizations(user.getKey(), project.getId(), true);
        return usersToCheck.stream().filter(userToAdd -> !sameOrganizationMemberUserKeys.contains(userToAdd.getKey())).collect(Collectors.toSet());
    }

    @Override
    public Collection<String> getUsernamesInOrganizations(Collection<String> organizationNames) {
        Objects.requireNonNull(organizationNames, "organizationNames");
        return this.toUserNames(this.memberQStore.getUserKeysForOrganizations(organizationNames));
    }

    @Override
    public Collection<String> getUserKeysOfOrganizationMembers(Project project) {
        Objects.requireNonNull(project, "project");
        return this.memberQStore.getOrganizationMembers(project.getId());
    }

    @Override
    public boolean isMemberOfAnyOrganizationsInProject(CheckedUser checkedUser, Project project) {
        Objects.requireNonNull(checkedUser, "checkedUser");
        Objects.requireNonNull(project, "project");
        return this.memberQStore.isMemberOfAnyOrganizationInProject(project.getId(), checkedUser.getKey());
    }

    @Override
    public boolean isMemberOfAnyOrganizationsInProject(Set<Integer> orgIds, CheckedUser checkedUser, Project project) {
        Objects.requireNonNull(orgIds, "orgIds");
        Objects.requireNonNull(checkedUser, "checkedUser");
        Objects.requireNonNull(project, "project");
        return this.memberQStore.isMemberOfAnyOrganizationInProject(orgIds, project.getId(), checkedUser.getKey());
    }

    @Override
    public Collection<String> getUserKeysInOrganizations(Collection<String> organizationNames) {
        Objects.requireNonNull(organizationNames, "organizationNames");
        return this.memberQStore.getUserKeysForOrganizations(organizationNames);
    }

    @Override
    public Collection<String> getUserKeysInOrganization(CustomerOrganization organization) {
        Objects.requireNonNull(organization, "organization");
        return this.memberQStore.getOrganizationMembers(organization.getId());
    }

    @Override
    public List<String> getMembersOfSameOrganizations(CheckedUser searcher, Project project, boolean removeSearcherFromResults) {
        Objects.requireNonNull(searcher, "searcher");
        Objects.requireNonNull(project, "project");
        return this.memberQStore.getMembersOfSameOrganizations(searcher.getKey(), project.getId(), removeSearcherFromResults);
    }

    @Override
    public Either<AnError, Unit> addUsers(Set<CheckedUser> users, CustomerOrganization organization) {
        return Either.right((Object)this.databaseAccessor.runInTransaction(databaseConnection -> {
            this.memberQStore.addOrganizationMembers(organization.getId(), CustomerOrganizationUtil.transformToUserKeys(users), (DatabaseConnection)databaseConnection);
            return Unit.VALUE;
        }));
    }

    @Override
    public List<OrganizationProjectsList> getOrganizationProjectLists(CheckedUser forUser) {
        return this.memberQStore.getOrganizationProjectLists(forUser.getKey());
    }

    @Override
    public Collection<CustomerOrganization> filterOrganizationsUserDoesNotBelongTo(CheckedUser user, Project project, Collection<CustomerOrganization> organizations) {
        List<CustomerOrganization> userOrganizations = this.memberQStore.getOrganizationsForUser(user.getKey(), project.getId());
        return organizations.stream().filter(organization -> !userOrganizations.contains(organization)).collect(Collectors.toSet());
    }

    private Either<AnError, Unit> validateInput(Collection<CheckedUser> users, Project project) {
        if (users.isEmpty()) {
            return Either.left((Object)this.organizationError.USERS_IS_NOT_DEFINED_FOR_ADD_TO_ORG());
        }
        if (!this.serviceDeskManager.isServiceDeskEnabled(project)) {
            return Either.left((Object)this.commonErrors.NOT_A_SERVICEDESK_PROJECT());
        }
        return Either.right((Object)Unit.Unit());
    }

    private Either<AnError, Unit> validateInput(Collection<CheckedUser> users, Project project, String orgName) {
        Objects.requireNonNull(orgName, "orgName");
        if (StringUtils.isBlank((String)orgName)) {
            return Either.left((Object)this.organizationError.ORGANIZATION_NAME_EMPTY());
        }
        if (orgName.length() > 200) {
            return Either.left((Object)this.organizationError.ORGANISATION_NAME_LIMIT(200));
        }
        return this.validateInput(users, project);
    }

    private Collection<String> toUserNames(Collection<String> userKeys) {
        return userKeys.stream().map(this::getUsername).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getUsername(String userKey) {
        ApplicationUser userByKey = this.userManager.getUserByKey(userKey);
        return userByKey != null ? userByKey.getName() : null;
    }
}

