/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.jql;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.query.Query;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganisationJQLHelper {
    private static final Logger logger = LoggerFactory.getLogger(OrganisationJQLHelper.class);
    private final SearchService searchService;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;

    @Autowired
    public OrganisationJQLHelper(SearchService searchService, VpOriginCustomFieldService vpOriginCustomFieldService) {
        this.searchService = searchService;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
    }

    public long countClosedRequest(@Nonnull CheckedUser user, @Nonnull CustomerOrganization organisation, @Nonnull Project project) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(organisation, "organisation");
        Objects.requireNonNull(project, "project");
        CustomField vpOriginCustomField = this.vpOriginCustomFieldService.getVpOriginCustomField();
        try {
            return this.searchService.searchCount(user.forJIRA(), this.getClosedIssueQuery(organisation, project, vpOriginCustomField));
        }
        catch (SearchException e) {
            logger.error("Failed to search for number of closed issue", (Throwable)e);
            return 0L;
        }
    }

    public long countOpenedRequest(@Nonnull CheckedUser user, @Nonnull CustomerOrganization organisation, @Nonnull Project project) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(organisation, "organisation");
        Objects.requireNonNull(project, "project");
        CustomField vpOriginCustomField = this.vpOriginCustomFieldService.getVpOriginCustomField();
        try {
            return this.searchService.searchCount(user.forJIRA(), this.getOpenedIssueQuery(organisation, project, vpOriginCustomField));
        }
        catch (SearchException e) {
            logger.error("Failed to search for number of closed issue", (Throwable)e);
            return 0L;
        }
    }

    public String getClosedRequestJql(@Nonnull CustomerOrganization organisation, @Nonnull Project project) {
        Objects.requireNonNull(organisation, "organisation");
        Objects.requireNonNull(project, "project");
        CustomField vpOriginCustomField = this.vpOriginCustomFieldService.getVpOriginCustomField();
        return this.searchService.getJqlString(this.getClosedIssueQuery(organisation, project, vpOriginCustomField));
    }

    public String getOpenedRequestJql(@Nonnull CustomerOrganization organisation, @Nonnull Project project) {
        Objects.requireNonNull(organisation, "organisation");
        Objects.requireNonNull(project, "project");
        CustomField vpOriginCustomField = this.vpOriginCustomFieldService.getVpOriginCustomField();
        return this.searchService.getJqlString(this.getOpenedIssueQuery(organisation, project, vpOriginCustomField));
    }

    private Query getClosedIssueQuery(CustomerOrganization organisation, Project project, CustomField vpOriginField) {
        JqlClauseBuilder jqlClauseBuilder = JqlQueryBuilder.newBuilder().where();
        Query query = this.reporterInOrganisation(jqlClauseBuilder, organisation).and().not().unresolved().and().project(new String[]{project.getKey()}).and().field(vpOriginField.getName()).isNotEmpty().buildQuery();
        return query;
    }

    private Query getOpenedIssueQuery(CustomerOrganization organisation, Project project, CustomField vpOriginField) {
        JqlClauseBuilder jqlClauseBuilder = JqlQueryBuilder.newBuilder().where();
        Query query = this.reporterInOrganisation(jqlClauseBuilder, organisation).and().unresolved().and().project(new String[]{project.getKey()}).and().field(vpOriginField.getName()).isNotEmpty().buildQuery();
        return query;
    }

    private JqlClauseBuilder reporterInOrganisation(JqlClauseBuilder clauseBuilder, CustomerOrganization organisation) {
        clauseBuilder.addCondition(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new FunctionOperand("organizationMembers", new String[]{organisation.getName()}));
        return clauseBuilder;
    }
}

