/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.jql;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.servicedesk.internal.feature.organization.jql.InOrganisationValidator;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class InOrganisationFunction
extends AbstractJqlFunction {
    public static final String FUNCTION_NAME = "organizationMembers";
    public static final int MINIMUM_AMOUNT_OF_ARGUMENTS = 1;
    private final InOrganisationValidator inOrganisationValidator;
    private final CustomerOrganizationMemberManager customerOrganizationMemberManager;

    public InOrganisationFunction(CustomerOrganizationMemberManager customerOrganizationMemberManager, InOrganisationValidator inOrganisationValidator) {
        this.customerOrganizationMemberManager = customerOrganizationMemberManager;
        this.inOrganisationValidator = inOrganisationValidator;
    }

    @Nonnull
    public MessageSet validate(ApplicationUser applicationUser, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        return this.inOrganisationValidator.validate(applicationUser, functionOperand);
    }

    @Nonnull
    public List<QueryLiteral> getValues(@Nonnull QueryCreationContext queryCreationContext, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        if (!functionOperand.getArgs().isEmpty()) {
            return this.customerOrganizationMemberManager.getUsernamesInOrganizations(functionOperand.getArgs()).stream().map(userName -> new QueryLiteral((Operand)functionOperand, userName)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    @Nonnull
    public JiraDataType getDataType() {
        return JiraDataTypes.USER;
    }

    @Nonnull
    public String getFunctionName() {
        return FUNCTION_NAME;
    }
}

