/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.event;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.api.feature.organization.event.OrganizationParticipantsIssueEventService;
import com.atlassian.servicedesk.internal.api.util.IssueEventHelper;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsCFManager;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.organization.CustomerOrganizationParticipantManager;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@Component
@ExportAsService
public class OrganizationParticipantsIssueEventServiceImpl
implements OrganizationParticipantsIssueEventService {
    private final CustomerOrganizationsCFManager customerOrganizationsCFManager;
    private final CustomerOrganizationManager customerOrganizationManager;
    private final CustomerOrganizationParticipantManager organizationParticipantManager;
    private final IssueEventHelper issueEventUtil;

    @Autowired
    public OrganizationParticipantsIssueEventServiceImpl(CustomerOrganizationsCFManager customerOrganizationsCFManager, CustomerOrganizationManager customerOrganizationManager, CustomerOrganizationParticipantManager organizationParticipantManager, IssueEventHelper issueEventUtil) {
        this.customerOrganizationsCFManager = customerOrganizationsCFManager;
        this.customerOrganizationManager = customerOrganizationManager;
        this.organizationParticipantManager = organizationParticipantManager;
        this.issueEventUtil = issueEventUtil;
    }

    public Set<Integer> getNewOrganizationParticipants(IssueEvent issueEvent) {
        Objects.requireNonNull(issueEvent, "issueEvent");
        Issue issue = issueEvent.getIssue();
        if (issue == null) {
            return Collections.emptySet();
        }
        Set<Integer> addedOrganizationIds = this.issueEventUtil.isCreatedEvent(issueEvent) ? this.getNewOrganizationParticipantsOnCreate(issue) : this.getNewOrganizationParticipantsOnChange(issueEvent);
        return ImmutableSet.copyOf(this.getValidAddedOrganizationIds(issue, addedOrganizationIds));
    }

    public Set<Integer> getNewOrganizationParticipants(IssueChangedEvent issueChangedEvent) {
        Objects.requireNonNull(issueChangedEvent, "issueChangedEvent");
        Issue issue = issueChangedEvent.getIssue();
        if (issue == null) {
            return Collections.emptySet();
        }
        Set<Integer> addedOrganizationIds = this.customerOrganizationsCFManager.getAddedOrganizationIds(issueChangedEvent.getChangeItems());
        return ImmutableSet.copyOf(this.getValidAddedOrganizationIds(issue, addedOrganizationIds));
    }

    private Set<Integer> getNewOrganizationParticipantsOnChange(IssueEvent issueEvent) {
        List changeItemBeans = this.issueEventUtil.getChangeItemBeans(issueEvent);
        return this.customerOrganizationsCFManager.getAddedOrganizationIds(changeItemBeans);
    }

    private Set<Integer> getNewOrganizationParticipantsOnCreate(Issue issue) {
        return ((Collection)this.organizationParticipantManager.getOrganizationsForIssue(issue).getOrElse(Collections.emptySet())).stream().map(CustomerOrganization::getId).collect(Collectors.toSet());
    }

    private Set<Integer> getValidAddedOrganizationIds(Issue issue, Set<Integer> addedOrganizationIds) {
        Collection organizationsInProject = (Collection)this.customerOrganizationManager.getOrganizationsForProject(issue.getProjectObject()).getOrElse(Collections.emptyList());
        Set organizationIdsInProject = organizationsInProject.stream().map(CustomerOrganization::getId).collect(Collectors.toSet());
        addedOrganizationIds.retainAll(organizationIdsInProject);
        return addedOrganizationIds;
    }
}

