/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.feature.organization.event.OrganizationParticipantsIssueEventService;
import com.atlassian.servicedesk.internal.api.util.IssueEventHelper;
import com.atlassian.servicedesk.internal.feature.organization.event.OrganisationsAddedToIssueEventImpl;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import io.atlassian.fugue.Option;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganisationsAddedToIssueEventPublisher {
    private final EventPublisher eventPublisher;
    private final OrganizationParticipantsIssueEventService organisationIssueEventService;
    private final IssueEventHelper issueEventUtil;
    private final FeatureManager featureManager;
    private final ServiceDeskManager serviceDeskManager;

    @Autowired
    public OrganisationsAddedToIssueEventPublisher(EventPublisher eventPublisher, OrganizationParticipantsIssueEventService organisationIssueEventService, IssueEventHelper issueEventUtil, FeatureManager featureManager, ServiceDeskManager serviceDeskManager) {
        this.eventPublisher = eventPublisher;
        this.organisationIssueEventService = organisationIssueEventService;
        this.issueEventUtil = issueEventUtil;
        this.featureManager = featureManager;
        this.serviceDeskManager = serviceDeskManager;
    }

    public void onIssueChangedEvent(@Nonnull IssueChangedEvent issueChangedEvent) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return;
        }
        if (!this.isIssueBelongToServiceDeskProject(issueChangedEvent.getIssue())) {
            return;
        }
        Set newOrganisationParticipants = this.organisationIssueEventService.getNewOrganizationParticipants(issueChangedEvent);
        this.publishOrganisationSharedEvent((Option<ApplicationUser>)Option.fromOptional((Optional)issueChangedEvent.getAuthor()), newOrganisationParticipants, issueChangedEvent.getIssue(), issueChangedEvent.getTime());
    }

    public void onIssueCreatedEvent(@Nonnull IssueEvent issueEvent) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return;
        }
        if (!this.issueEventUtil.isCreatedEvent(issueEvent)) {
            return;
        }
        if (!this.isIssueBelongToServiceDeskProject(issueEvent.getIssue())) {
            return;
        }
        Set newOrganisationParticipants = this.organisationIssueEventService.getNewOrganizationParticipants(issueEvent);
        this.publishOrganisationSharedEvent((Option<ApplicationUser>)Option.option((Object)issueEvent.getUser()), newOrganisationParticipants, issueEvent.getIssue(), issueEvent.getTime());
    }

    private void publishOrganisationSharedEvent(Option<ApplicationUser> initiator, Set<Integer> addedOrganisationIds, Issue issue, Date eventTime) {
        if (CollectionUtils.isEmpty(addedOrganisationIds)) {
            return;
        }
        Date checkedEventTime = eventTime != null ? eventTime : new Date();
        OrganisationsAddedToIssueEventImpl organisationsAddedToIssueEvent = new OrganisationsAddedToIssueEventImpl(issue, addedOrganisationIds, initiator, checkedEventTime);
        this.eventPublisher.publish((Object)organisationsAddedToIssueEvent);
    }

    private boolean isIssueBelongToServiceDeskProject(Issue issue) {
        Project project = issue.getProjectObject();
        if (project == null) {
            return false;
        }
        return this.serviceDeskManager.isServiceDeskEnabled(project);
    }
}

