/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.error;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOrganizationError {
    private final ErrorResultHelper errorHelper;

    @Autowired
    public CustomerOrganizationError(ErrorResultHelper errorHelper) {
        this.errorHelper = errorHelper;
    }

    public AnError ORGANISATION_ALREADY_EXISTS(Set<String> organisationNames) {
        String joinedOrganisationNames = StringUtils.join((Collection)organisationNames.stream().collect(Collectors.toSet()), (String)", ");
        return this.errorHelper.badRequest400("sd.customer.organisation.error.already.exists", new Object[]{joinedOrganisationNames}).build();
    }

    public AnError ORGANISATION_NOT_FOUND(Set<Integer> organisationIds) {
        String joinedOrganisationIds = StringUtils.join((Collection)organisationIds.stream().collect(Collectors.toSet()), (String)", ");
        return this.errorHelper.notFound404("sd.customer.organisation.ids.error.not.found", new Object[]{joinedOrganisationIds}).build();
    }

    public AnError FAILED_TO_DELETE_ORGANISATION(Set<String> organisationNames) {
        String joinedOrganisationNames = StringUtils.join((Collection)organisationNames.stream().collect(Collectors.toSet()), (String)", ");
        return this.errorHelper.internalServiceError500("sd.customer.organisation.error.fail.to.delete.organisation", new Object[0]).build();
    }

    public AnError FAILED_TO_ADD_USERS_TO_ORGANISATION(Set<String> organisationNames) {
        String joinedOrganisationNames = StringUtils.join((Collection)organisationNames.stream().collect(Collectors.toSet()), (String)", ");
        return this.errorHelper.internalServiceError500("sd.customer.organisation.error.fail.to.add.users", new Object[0]).build();
    }

    public AnError ORGANISATIONS_NOT_ASSOCIATED_WITH_PROJECT(Collection<CustomerOrganization> organisations) {
        Set organisationNames = organisations.stream().map(CustomerOrganization::getName).collect(Collectors.toSet());
        String joinedOrganisationNames = StringUtils.join((Collection)organisationNames.stream().collect(Collectors.toSet()), (String)", ");
        return this.errorHelper.badRequest400("sd.customer.organisation.error.organisation.not.associated.with.project", new Object[]{joinedOrganisationNames}).build();
    }

    public AnError ORGANIZATION_NAME_EMPTY() {
        return this.errorHelper.badRequest400("sd.customer.organisation.error.organisation.name.is.empty", new Object[0]).build();
    }

    public AnError ORGANISATION_NAME_LIMIT(int limit) {
        return this.errorHelper.badRequest400("sd.customer.organisation.error.organisation.name.is.too.long", new Object[]{limit}).build();
    }

    public AnError USERS_IS_NOT_DEFINED_FOR_ADD_TO_ORG() {
        return this.errorHelper.badRequest400("sd.customer.organisation.error.no.user.is.defined.for.adding.to.org", new Object[0]).build();
    }

    public AnError ORGANISATION_FEATURE_NOT_SUPPORTED() {
        return this.errorHelper.badRequest400("sd.customer.organisations.not.supported", new Object[0]).build();
    }

    public AnError ORGANISATIONS_CUSTOM_FIELD_NOT_FOUND() {
        return this.errorHelper.internalServiceError500("sd.customer.organisations.custom.field.not.found", new Object[0]).build();
    }

    public AnError FAILED_TO_UPDATE_ORGANISATIONS_CUSTOM_FIELD() {
        return this.errorHelper.internalServiceError500("sd.customer.organisations.custom.field.update.failed.unknown", new Object[0]).build();
    }

    public AnError FAILED_TO_UPDATE_ORGANISATIONS_CUSTOM_FIELD(@Nonnull ErrorCollection errorCollection) {
        Collection errorMessages2 = errorCollection.getErrorMessages();
        String join = StringUtils.join((Collection)errorMessages2, (String)", ");
        return this.errorHelper.internalServiceError500("sd.customer.organisations.custom.field.update.failed", new Object[]{join}).build();
    }

    public AnError NO_MANAGE_ORGANIZATION_PERMISSION() {
        return this.errorHelper.forbidden403("sd.customer.organisation.error.manage.organisation.permission.violation", new Object[0]).build();
    }

    public AnError INVALID_ORGANISATION_ID() {
        return this.errorHelper.badRequest400("sd.customer.organisation.error.invalid.id", new Object[0]).build();
    }

    public AnError USER_DOES_NOT_BELONG_TO_ORGANISATIONS_ERROR(Collection<CustomerOrganization> organisations) {
        Set organisationNames = organisations.stream().map(CustomerOrganization::getName).collect(Collectors.toSet());
        return this.errorHelper.badRequest400("sd.customer.organisation.error.user.not.belong.to", new Object[]{StringUtils.join(organisationNames, (String)", ")}).build();
    }

    public AnError USER_DOES_NOT_HAVE_VIEW_ORGANIZATION_PERMISSION() {
        return this.errorHelper.forbidden403("sd.customer.organisation.error.user.no.view.permission", new Object[0]).build();
    }

    public AnError NO_DELETE_ORGANIZATION_PERMISSION() {
        return this.errorHelper.forbidden403("sd.customer.organisation.error.delete.organisation.permission.violation", new Object[0]).build();
    }

    public AnError NO_EDIT_PERMISSION_ORGANIZATION() {
        return this.errorHelper.forbidden403("sd.customer.organisation.error.no.permission.to.change.organisation", new Object[0]).build();
    }
}

