/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationQStoreHelper;
import com.atlassian.servicedesk.internal.feature.organization.dao.exceptions.IllegalOrganizationNameException;
import com.atlassian.servicedesk.internal.feature.organization.dao.exceptions.OrganizationExistsException;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.google.common.collect.Sets;
import com.querydsl.core.QueryException;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class CustomerOrganizationQStoreImpl
implements CustomerOrganizationQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public CustomerOrganizationQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    @Nonnull
    public CustomerOrganization getOrCreate(String name, DatabaseConnection connection) {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(name, "name");
        return this.createCustomerOrganizations(Sets.newHashSet((Object[])new String[]{name}), connection).iterator().next();
    }

    @Override
    @Nonnull
    public Collection<CustomerOrganization> getOrCreate(Set<String> names, DatabaseConnection connection) {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(names, "names");
        return names.isEmpty() ? Collections.emptySet() : this.createCustomerOrganizations(names, connection);
    }

    @Override
    @Nonnull
    public CustomerOrganization update(int organizationId, String newName) throws OrganizationExistsException, IllegalOrganizationNameException {
        Objects.requireNonNull(newName, "newName");
        CustomerOrganizationQStoreHelper.validateNameLength(Sets.newHashSet((Object[])new String[]{newName}));
        String sanitizedName = CustomerOrganizationQStoreHelper.sanitizeSpacesInName(newName);
        return (CustomerOrganization)this.databaseAccessor.runInTransaction(connection -> {
            try {
                connection.update((RelationalPath)Tables.ORGANIZATION).set((Path)Tables.ORGANIZATION.NAME, (Object)sanitizedName).set((Path)Tables.ORGANIZATION.LOWER_NAME, (Object)"deprecated").set((Path)Tables.ORGANIZATION.SEARCH_NAME, (Object)sanitizedName.toLowerCase()).where((Predicate)Tables.ORGANIZATION.ID.eq((Object)organizationId)).execute();
                return this.getById(organizationId, (DatabaseConnection)connection);
            }
            catch (QueryException e) {
                throw new OrganizationExistsException(String.format("Organization with name %s already exists", newName), Sets.newHashSet((Object[])new String[]{newName}), e);
            }
        });
    }

    @Override
    @Nonnull
    public Collection<CustomerOrganization> getByNames(Set<String> names) {
        Objects.requireNonNull(names, "names");
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        return (Collection)this.databaseAccessor.runInTransaction(connection -> this.getByNames(CustomerOrganizationQStoreHelper.toSearchNames(names), (DatabaseConnection)connection));
    }

    @Override
    @Nonnull
    public List<CustomerOrganization> getByIds(Set<Integer> ids) {
        Objects.requireNonNull(ids);
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)this.databaseAccessor.runInTransaction(connection -> this.doGetByIds(ids, (DatabaseConnection)connection));
    }

    @Override
    @Nonnull
    public List<CustomerOrganization> getByIds(Set<Integer> ids, DatabaseConnection connection) {
        Objects.requireNonNull(ids);
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.doGetByIds(ids, connection);
    }

    private List<CustomerOrganization> doGetByIds(Set<Integer> ids, DatabaseConnection connection) {
        return this.get((SimpleExpression)Tables.ORGANIZATION.ID, (Collection)ids, connection);
    }

    @Override
    @Nonnull
    public Collection<Integer> findInvalidIds(Set<Integer> ids) {
        Objects.requireNonNull(ids);
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return (Collection)this.databaseAccessor.runInTransaction(connection -> {
            HashSet connectionIds = Sets.newHashSet((Iterable)ids);
            ids.removeAll(this.getByIds(ids, (DatabaseConnection)connection).stream().map(CustomerOrganization::getId).collect(Collectors.toSet()));
            return connectionIds;
        });
    }

    @Override
    @Nonnull
    public Collection<CustomerOrganization> findByNameQuery(String query) {
        Objects.requireNonNull(query);
        if (query.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return (Collection)this.databaseAccessor.runInTransaction(connection -> ((SQLQuery)((SQLQuery)connection.select(CustomerOrganizationQStoreHelper.toCustomerOrganization()).from((Expression)Tables.ORGANIZATION)).where(CustomerOrganizationQStoreHelper.getOrganizationNameLikeExp(query))).fetch());
    }

    @Override
    public void delete(int organizationId, DatabaseConnection connection) {
        connection.delete((RelationalPath)Tables.ORGANIZATION).where((Predicate)Tables.ORGANIZATION.ID.eq((Object)organizationId)).execute();
    }

    @Override
    public List<CustomerOrganization> getAllOrganizations() {
        return (List)this.databaseAccessor.runInTransaction(connection -> ((SQLQuery)connection.select(CustomerOrganizationQStoreHelper.toCustomerOrganization()).from((Expression)Tables.ORGANIZATION)).fetch());
    }

    private Collection<CustomerOrganization> createCustomerOrganizations(Set<String> names, DatabaseConnection connection) {
        CustomerOrganizationQStoreHelper.validateNameLength(names);
        Set<String> namesToCreate = CustomerOrganizationQStoreHelper.sanitizeSpacesInNames(names);
        Map<String, String> searchNamesToCreate = namesToCreate.stream().collect(Collectors.toMap(String::toLowerCase, s -> s));
        List<CustomerOrganization> existingOrgs = this.getByNames(namesToCreate, connection);
        Set existingOrgNames = existingOrgs.stream().map(existingOrg -> CustomerOrganizationQStoreHelper.toSearchName(existingOrg.getName())).collect(Collectors.toSet());
        searchNamesToCreate.keySet().removeAll(existingOrgNames);
        if (searchNamesToCreate.size() > 0) {
            SQLInsertClause insertClause = connection.insert((RelationalPath)Tables.ORGANIZATION);
            searchNamesToCreate.entrySet().stream().forEach(entry -> insertClause.set((Path)Tables.ORGANIZATION.NAME, entry.getValue()).set((Path)Tables.ORGANIZATION.LOWER_NAME, (Object)"deprecated").set((Path)Tables.ORGANIZATION.SEARCH_NAME, entry.getKey()).addBatch());
            insertClause.execute();
            existingOrgs.addAll(this.getByNames(Sets.newHashSet(searchNamesToCreate.values()), connection));
        }
        return existingOrgs;
    }

    private List<CustomerOrganization> getByNames(Set<String> names, DatabaseConnection connection) {
        return this.get((SimpleExpression)Tables.ORGANIZATION.SEARCH_NAME, names.stream().map(String::toLowerCase).collect(Collectors.toSet()), connection);
    }

    private CustomerOrganization getById(int organizationId, DatabaseConnection connection) {
        return this.getByIds(Sets.newHashSet((Object[])new Integer[]{organizationId}), connection).get(0);
    }

    private <B> List<CustomerOrganization> get(SimpleExpression<B> column, Collection<B> values2, DatabaseConnection connection) {
        return ((SQLQuery)((SQLQuery)connection.select(CustomerOrganizationQStoreHelper.toCustomerOrganization()).from((Expression)Tables.ORGANIZATION)).where((Predicate)CustomerOrganizationQStoreHelper.buildInClauses(column, values2))).fetch();
    }
}

