/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.dao;

import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.feature.organization.dao.exceptions.IllegalOrganizationNameException;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationImpl;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.google.common.collect.Iterables;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

class CustomerOrganizationQStoreHelper {
    private static final int MAX_IN_CLAUSE_EXPRESSIONS = 1000;

    CustomerOrganizationQStoreHelper() {
    }

    static ConstructorExpression<CustomerOrganization> toCustomerOrganization() {
        return Projections.constructor(CustomerOrganizationImpl.class, (Expression[])new Expression[]{Tables.ORGANIZATION.ID, Tables.ORGANIZATION.NAME});
    }

    static <B> BooleanExpression buildInClauses(SimpleExpression<B> column, Collection<B> collection, int maxInClauseExpression) {
        if (collection.size() <= maxInClauseExpression) {
            return column.in(collection);
        }
        return Expressions.anyOf((BooleanExpression[])((BooleanExpression[])StreamSupport.stream(Iterables.partition(collection, (int)maxInClauseExpression).spliterator(), false).map(arg_0 -> column.in(arg_0)).toArray(BooleanExpression[]::new)));
    }

    static <B> BooleanExpression buildInClauses(SimpleExpression<B> column, Collection<B> collection) {
        return CustomerOrganizationQStoreHelper.buildInClauses(column, collection, 1000);
    }

    static String sanitizeSpacesInName(String name) {
        return name.trim().replaceAll("\\s+", " ");
    }

    static Set<String> sanitizeSpacesInNames(Collection<String> names) {
        return names.stream().map(CustomerOrganizationQStoreHelper::sanitizeSpacesInName).collect(Collectors.toSet());
    }

    static String toSearchName(String name) {
        return CustomerOrganizationQStoreHelper.sanitizeSpacesInName(name).toLowerCase();
    }

    static Set<String> toSearchNames(Collection<String> names) {
        return names.stream().map(CustomerOrganizationQStoreHelper::sanitizeSpacesInName).map(String::toLowerCase).collect(Collectors.toSet());
    }

    static void validateNameLength(Set<String> names) throws IllegalOrganizationNameException {
        names.stream().forEach(name -> {
            if (name.trim().isEmpty() || name.trim().length() > 200) {
                throw new IllegalOrganizationNameException(String.format("'%s' is an illegal organization name", name), (String)name);
            }
        });
    }

    static Predicate getOrganizationNameLikeExp(String prefixQuery) {
        String query = prefixQuery.toLowerCase().trim();
        return Tables.ORGANIZATION.SEARCH_NAME.like(query + "%").or((Predicate)Tables.ORGANIZATION.SEARCH_NAME.like("% " + query + "%"));
    }
}

