/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationProjectQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationQStoreHelper;
import com.atlassian.servicedesk.internal.feature.organization.dao.exceptions.OrganizationNotFoundException;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithOtherProjectCount;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationUtil;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Sets;
import com.querydsl.core.QueryException;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class CustomerOrganizationProjectQStoreImpl
implements CustomerOrganizationProjectQStore {
    private static final Logger LOG = LoggerFactory.getLogger(CustomerOrganizationProjectQStoreImpl.class);
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public CustomerOrganizationProjectQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public void addOrganizationsToProject(Set<Integer> organizationsIds, long projectId, DatabaseConnection databaseConnection) throws OrganizationNotFoundException {
        Assertions.notNull((String)"organizationsIds", organizationsIds);
        if (organizationsIds.isEmpty()) {
            return;
        }
        Set<Integer> existingIds = CustomerOrganizationUtil.transformToIds(this.getOrganizationsByProjectId(projectId, databaseConnection));
        Sets.SetView newIds = Sets.difference(organizationsIds, existingIds);
        SQLInsertClause insertClause = databaseConnection.insert((RelationalPath)Tables.ORGANIZATION_PROJECT);
        if (newIds.isEmpty()) {
            return;
        }
        newIds.stream().forEach(id -> {
            insertClause.set(Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID, id).set(Tables.ORGANIZATION_PROJECT.PROJECT_ID, (Object)projectId);
            insertClause.addBatch();
        });
        try {
            insertClause.execute();
        }
        catch (QueryException ex) {
            LOG.debug(ex.getMessage());
            throw new OrganizationNotFoundException(Sets.newHashSet());
        }
    }

    @Override
    public void removeOrganizationsFromProject(Set<Integer> organizationsIds, long projectId) {
        Assertions.notNull((String)"organizationsIds", organizationsIds);
        if (organizationsIds.isEmpty()) {
            return;
        }
        this.databaseAccessor.runInTransaction(databaseConnection -> databaseConnection.delete((RelationalPath)Tables.ORGANIZATION_PROJECT).where((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.in((Collection)organizationsIds).and((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId))).execute());
    }

    @Override
    public Collection<CustomerOrganization> getOrganizationsForProject(long projectId) {
        return (Collection)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(CustomerOrganizationQStoreHelper.toCustomerOrganization()).from((Expression)Tables.ORGANIZATION)).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId))).fetch());
    }

    @Override
    public Collection<Long> getProjectsForOrganization(int organizationId) {
        return (Collection)this.databaseAccessor.run(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(Tables.ORGANIZATION_PROJECT.PROJECT_ID).from((Expression)Tables.ORGANIZATION_PROJECT)).innerJoin((EntityPath)Tables.ORGANIZATION)).on((Predicate)Tables.ORGANIZATION.ID.eq(Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID))).where((Predicate)Tables.ORGANIZATION.ID.eq((Object)organizationId))).fetch());
    }

    @Override
    public Collection<CustomerOrganization> findUserOrganization(String userKey, long projectId, String prefixQuery) {
        Assertions.notNull((String)"userKey", (Object)userKey);
        Assertions.notNull((String)"prefixQuery", (Object)prefixQuery);
        if (userKey.trim().isEmpty() || prefixQuery.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return (Collection)this.databaseAccessor.run(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(CustomerOrganizationQStoreHelper.toCustomerOrganization()).from((Expression)Tables.ORGANIZATION)).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).innerJoin((EntityPath)Tables.ORGANIZATION_MEMBER)).on((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId).and((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.eq((Object)userKey)).and(CustomerOrganizationQStoreHelper.getOrganizationNameLikeExp(prefixQuery)))).fetch());
    }

    @Override
    public Collection<CustomerOrganization> findOrganizationsInProject(long projectId, String prefixQuery) {
        Assertions.notNull((String)"prefixQuery", (Object)prefixQuery);
        if (prefixQuery.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return (Collection)this.databaseAccessor.run(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(CustomerOrganizationQStoreHelper.toCustomerOrganization()).from((Expression)Tables.ORGANIZATION)).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId).and(CustomerOrganizationQStoreHelper.getOrganizationNameLikeExp(prefixQuery)))).fetch());
    }

    @Override
    public List<Integer> filterOrganizationsInProject(Set<Integer> organizationIds, long projectId) {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.select(Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID).distinct()).from((Expression)Tables.ORGANIZATION_PROJECT)).where((Predicate)CustomerOrganizationQStoreHelper.buildInClauses(Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID, organizationIds).and((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId)))).fetch());
    }

    @Override
    public void disassociateProjectAndOrganization(long projectId, int organizationId) {
        this.databaseAccessor.runInTransaction(conn -> conn.delete((RelationalPath)Tables.ORGANIZATION_PROJECT).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId).and((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq((Object)organizationId))).execute());
    }

    @Override
    public List<CustomerOrganizationWithOtherProjectCount> findAllOrganizationsWithOtherProjectsCount(long projectIdToExcludeFromCount, String prefixQuery, int limit) {
        if (limit <= 0) {
            return Collections.emptyList();
        }
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression)Projections.constructor(CustomerOrganizationWithOtherProjectCount.class, (Expression[])new Expression[]{Tables.ORGANIZATION.ID, Tables.ORGANIZATION.NAME, Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.count()})).from((Expression)Tables.ORGANIZATION)).leftJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID).and((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.notIn((Object[])new Long[]{projectIdToExcludeFromCount})))).where((Predicate)Tables.ORGANIZATION.ID.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.ORGANIZATION.ID).from((Expression)Tables.ORGANIZATION)).leftJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where(CustomerOrganizationQStoreHelper.getOrganizationNameLikeExp(prefixQuery))))).groupBy(new Expression[]{Tables.ORGANIZATION.ID, Tables.ORGANIZATION.NAME})).orderBy(Tables.ORGANIZATION.NAME.asc())).limit((long)limit)).fetch());
    }

    @Override
    public Option<CustomerOrganizationWithOtherProjectCount> getOrganizationWithOtherProjectCount(long projectIdToExcludeFromCount, int organizationId) {
        CustomerOrganizationWithOtherProjectCount customerOrganizationWithOtherProjectCount = (CustomerOrganizationWithOtherProjectCount)this.databaseAccessor.runInTransaction(conn -> (CustomerOrganizationWithOtherProjectCount)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression)Projections.constructor(CustomerOrganizationWithOtherProjectCount.class, (Expression[])new Expression[]{Tables.ORGANIZATION.ID, Tables.ORGANIZATION.NAME, Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.count()})).from((Expression)Tables.ORGANIZATION)).leftJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID).and((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.notIn((Object[])new Long[]{projectIdToExcludeFromCount})))).groupBy(new Expression[]{Tables.ORGANIZATION.ID, Tables.ORGANIZATION.NAME})).where((Predicate)Tables.ORGANIZATION.ID.eq((Object)organizationId))).fetchFirst());
        return Option.option((Object)customerOrganizationWithOtherProjectCount);
    }

    @Override
    public void removeAllFromProject(long projectId) {
        this.databaseAccessor.runInTransaction(conn -> conn.delete((RelationalPath)Tables.ORGANIZATION_PROJECT).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId)).execute());
    }

    @Override
    public void removeOrganizationFromAllProjects(int organizationId, DatabaseConnection databaseConnection) {
        this.removeOrganizationById(organizationId, databaseConnection);
    }

    private long removeOrganizationById(int organizationId, DatabaseConnection databaseConnection) {
        return databaseConnection.delete((RelationalPath)Tables.ORGANIZATION_PROJECT).where((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq((Object)organizationId)).execute();
    }

    private Collection<CustomerOrganization> getOrganizationsByProjectId(long projectId, DatabaseConnection databaseConnection) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(CustomerOrganizationQStoreHelper.toCustomerOrganization()).from((Expression)Tables.ORGANIZATION)).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId))).fetch();
    }
}

