/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationMemberQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationQStoreHelper;
import com.atlassian.servicedesk.internal.feature.organization.dao.exceptions.OrganizationNotFoundException;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationImpl;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithMemberCount;
import com.atlassian.servicedesk.internal.feature.organization.model.OrganizationProjectsList;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

@Component
@Repository
@ParametersAreNonnullByDefault
public class CustomerOrganizationMemberQStoreImpl
implements CustomerOrganizationMemberQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public CustomerOrganizationMemberQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public void addOrganizationMembers(int organizationId, Set<String> userKeys, DatabaseConnection databaseConnection) throws OrganizationNotFoundException {
        Objects.requireNonNull(userKeys);
        if (userKeys.isEmpty()) {
            return;
        }
        List<String> existingMembers = this.filterOrganizationMembers(organizationId, userKeys, databaseConnection);
        Sets.SetView newMembers = Sets.difference(userKeys, (Set)Sets.newHashSet(existingMembers));
        this.addOrganizationMembers(organizationId, (Collection<String>)newMembers, databaseConnection);
    }

    @Override
    public void removeMembersFromOrganization(int organizationId, Set<String> userKeys) {
        Objects.requireNonNull(userKeys);
        if (userKeys.isEmpty()) {
            return;
        }
        this.databaseAccessor.runInTransaction(connection -> {
            this.removeMembersFromOrganization(organizationId, userKeys, (DatabaseConnection)connection);
            return null;
        });
    }

    @Override
    public void removeMembersFromOrganization(int organizationId, Set<String> userKeys, DatabaseConnection databaseConnection) {
        Objects.requireNonNull(userKeys);
        if (userKeys.isEmpty()) {
            return;
        }
        databaseConnection.delete((RelationalPath)Tables.ORGANIZATION_MEMBER).where((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq((Object)organizationId).and((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.in(userKeys))).execute();
    }

    @Override
    public List<String> getOrganizationMembers(int organizationId) {
        return (List)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.ORGANIZATION_MEMBER.USER_KEY).from((Expression)Tables.ORGANIZATION_MEMBER)).innerJoin((EntityPath)Tables.ORGANIZATION)).on((Predicate)Tables.ORGANIZATION.ID.eq(Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID))).where((Predicate)Tables.ORGANIZATION.ID.eq((Object)organizationId))).fetch());
    }

    @Override
    public List<String> getOrganizationMembers(long projectId) {
        return (List)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.ORGANIZATION_MEMBER.USER_KEY).distinct()).from((Expression)Tables.ORGANIZATION_MEMBER)).innerJoin((EntityPath)Tables.ORGANIZATION)).on((Predicate)Tables.ORGANIZATION.ID.eq(Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID))).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId))).fetch());
    }

    @Override
    public List<CustomerOrganization> getOrganizationsForUser(String userKey) {
        Objects.requireNonNull(userKey);
        if (userKey.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return (List)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(CustomerOrganizationQStoreHelper.toCustomerOrganization()).from((Expression)Tables.ORGANIZATION)).innerJoin((EntityPath)Tables.ORGANIZATION_MEMBER)).on((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.eq((Object)userKey))).fetch());
    }

    @Override
    public List<CustomerOrganization> getOrganizationsForUser(String userKey, long projectId) {
        Objects.requireNonNull(userKey);
        if (userKey.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return (List)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(CustomerOrganizationQStoreHelper.toCustomerOrganization()).from((Expression)Tables.ORGANIZATION)).innerJoin((EntityPath)Tables.ORGANIZATION_MEMBER)).on((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.eq((Object)userKey).and((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId)))).fetch());
    }

    @Override
    public List<String> getMembersOfSameOrganizations(String searcherUserKey, long projectId, boolean removeSearcherFromResults) {
        Objects.requireNonNull(searcherUserKey);
        if (searcherUserKey.trim().isEmpty()) {
            return Collections.emptyList();
        }
        BooleanExpression inWhere = Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.ORGANIZATION.ID).from((Expression)Tables.ORGANIZATION)).innerJoin((EntityPath)Tables.ORGANIZATION_MEMBER)).on((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId).and((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.eq((Object)searcherUserKey))));
        BooleanExpression wherePredicate = removeSearcherFromResults ? Tables.ORGANIZATION_MEMBER.USER_KEY.ne((Object)searcherUserKey).and((Predicate)inWhere) : inWhere;
        return (List)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.ORGANIZATION_MEMBER.USER_KEY).distinct()).from((Expression)Tables.ORGANIZATION_MEMBER)).where((Predicate)wherePredicate)).fetch());
    }

    @Override
    public List<CustomerOrganizationWithMemberCount> findOrganizationWithMemberCount(String query) {
        Objects.requireNonNull(query);
        if (query.trim().isEmpty()) {
            return Collections.emptyList();
        }
        Map transformation = (Map)this.databaseAccessor.runInTransaction(databaseConnection -> (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(new Expression[]{Tables.ORGANIZATION.ID, Tables.ORGANIZATION.NAME, Tables.ORGANIZATION_MEMBER.ID}).from((Expression)Tables.ORGANIZATION)).leftJoin((EntityPath)Tables.ORGANIZATION_MEMBER)).on((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where(CustomerOrganizationQStoreHelper.getOrganizationNameLikeExp(query))).orderBy(Tables.ORGANIZATION.NAME.asc())).transform(GroupBy.groupBy(Tables.ORGANIZATION.ID).as(new Expression[]{Projections.tuple((Expression[])new Expression[]{Tables.ORGANIZATION.ID, Tables.ORGANIZATION.NAME}), GroupBy.list(Tables.ORGANIZATION_MEMBER.ID)})));
        return this.toCustomerOrganizationWithMemberCount(transformation);
    }

    @Override
    public boolean isMemberOfAnyOrganizationInProject(long projectId, String userKey) {
        Objects.requireNonNull(userKey);
        if (userKey.trim().isEmpty()) {
            return false;
        }
        long membershipCount = (Long)this.databaseAccessor.runInTransaction(databaseConnection -> (Long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.ORGANIZATION_MEMBER.ID.count()).from((Expression)Tables.ORGANIZATION_MEMBER)).innerJoin((EntityPath)Tables.ORGANIZATION)).on((Predicate)Tables.ORGANIZATION.ID.eq(Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID))).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId).and((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.eq((Object)userKey)))).fetchFirst());
        return membershipCount > 0L;
    }

    @Override
    public boolean isMemberOfAnyOrganizationInProject(Set<Integer> orgIds, long projectId, String userKey) {
        Objects.requireNonNull(orgIds);
        Objects.requireNonNull(userKey);
        if (userKey.trim().isEmpty() || orgIds.isEmpty()) {
            return false;
        }
        long membershipCount = (Long)this.databaseAccessor.runInTransaction(databaseConnection -> (Long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.ORGANIZATION_MEMBER.ID.count()).from((Expression)Tables.ORGANIZATION_MEMBER)).innerJoin((EntityPath)Tables.ORGANIZATION)).on((Predicate)Tables.ORGANIZATION.ID.eq(Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID))).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId).and((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.eq((Object)userKey)).and((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.in((Collection)orgIds)))).fetchFirst());
        return membershipCount > 0L;
    }

    @Override
    public List<String> filterProjectMembers(long projectId, Set<String> userKeys) {
        Objects.requireNonNull(userKeys);
        if (userKeys.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.ORGANIZATION_MEMBER.USER_KEY).distinct()).from((Expression)Tables.ORGANIZATION_MEMBER)).innerJoin((EntityPath)Tables.ORGANIZATION)).on((Predicate)Tables.ORGANIZATION.ID.eq(Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID))).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId).and((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.in((Collection)userKeys)))).fetch());
    }

    @Override
    public List<String> filterUsersByMyOrganizationsForProject(String searchingUserKey, long projectId, Set<String> userKeys) {
        Objects.requireNonNull(searchingUserKey);
        Objects.requireNonNull(userKeys);
        if (searchingUserKey.trim().isEmpty() || userKeys.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.ORGANIZATION_MEMBER.USER_KEY).distinct()).from((Expression)Tables.ORGANIZATION_MEMBER)).where((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.in((Collection)userKeys).and((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.ORGANIZATION.ID).from((Expression)Tables.ORGANIZATION)).innerJoin((EntityPath)Tables.ORGANIZATION_MEMBER)).on((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_PROJECT.PROJECT_ID.eq((Object)projectId).and((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.eq((Object)searchingUserKey))))))).fetch());
    }

    @Override
    public List<String> getUserKeysForOrganizations(Collection<String> organizationNames) {
        Objects.requireNonNull(organizationNames, "organizationNames");
        if (organizationNames.isEmpty()) {
            return new ArrayList<String>();
        }
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression)Tables.ORGANIZATION_MEMBER.USER_KEY).distinct()).from((Expression)Tables.ORGANIZATION_MEMBER)).join((EntityPath)Tables.ORGANIZATION)).on((Predicate)Tables.ORGANIZATION.ID.eq(Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID))).where((Predicate)CustomerOrganizationQStoreHelper.buildInClauses(Tables.ORGANIZATION.SEARCH_NAME, CustomerOrganizationQStoreHelper.toSearchNames(organizationNames)))).fetch());
    }

    @Override
    public Set<String> getOrganizationMembers(Set<Integer> organizationIds) {
        if (CollectionUtils.isEmpty(organizationIds)) {
            return new HashSet<String>();
        }
        List userKeys = (List)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.ORGANIZATION_MEMBER.USER_KEY).from((Expression)Tables.ORGANIZATION_MEMBER)).innerJoin((EntityPath)Tables.ORGANIZATION)).on((Predicate)Tables.ORGANIZATION.ID.eq(Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID))).where((Predicate)CustomerOrganizationQStoreHelper.buildInClauses(Tables.ORGANIZATION.ID, organizationIds))).fetch());
        return ImmutableSet.copyOf((Collection)userKeys);
    }

    @Override
    public boolean isMemberOfOrganization(String userKey, int organizationId) {
        Long rows = (Long)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select(Tables.ORGANIZATION_MEMBER.ID).from((Expression)Tables.ORGANIZATION_MEMBER)).where((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.eq((Object)userKey).and((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq((Object)organizationId)))).fetchCount());
        return rows > 0L;
    }

    @Override
    public List<OrganizationProjectsList> getOrganizationProjectLists(String userKey) {
        Map results = (Map)this.databaseAccessor.runInTransaction(conn -> (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(new Expression[]{Tables.ORGANIZATION.NAME, Tables.ORGANIZATION_PROJECT.PROJECT_ID}).from((Expression)Tables.ORGANIZATION)).innerJoin((EntityPath)Tables.ORGANIZATION_MEMBER)).on((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).innerJoin((EntityPath)Tables.ORGANIZATION_PROJECT)).on((Predicate)Tables.ORGANIZATION_PROJECT.ORGANIZATION_ID.eq(Tables.ORGANIZATION.ID))).where((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.eq((Object)userKey))).transform(GroupBy.groupBy((Expression)Tables.ORGANIZATION.NAME).as((Expression)GroupBy.list(Tables.ORGANIZATION_PROJECT.PROJECT_ID))));
        return results.entrySet().stream().map(entry -> new OrganizationProjectsList((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public void removeAllMembers(int organizationId, DatabaseConnection databaseConnection) {
        databaseConnection.delete((RelationalPath)Tables.ORGANIZATION_MEMBER).where((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq((Object)organizationId)).execute();
    }

    private List<CustomerOrganizationWithMemberCount> toCustomerOrganizationWithMemberCount(Map<Integer, Group> transformation) {
        ArrayList<CustomerOrganizationWithMemberCount> result = new ArrayList<CustomerOrganizationWithMemberCount>();
        transformation.values().stream().forEach(group -> result.add(this.transformGroup((Group)group)));
        return result;
    }

    private CustomerOrganizationWithMemberCount transformGroup(Group group) {
        Tuple orgTuple = (Tuple)group.getOne((Expression)Projections.tuple((Expression[])new Expression[]{Tables.ORGANIZATION.ID, Tables.ORGANIZATION.NAME}));
        CustomerOrganizationImpl org = new CustomerOrganizationImpl((Integer)orgTuple.get(Tables.ORGANIZATION.ID), (String)orgTuple.get((Expression)Tables.ORGANIZATION.NAME));
        int membersCount = group.getList(Tables.ORGANIZATION_MEMBER.ID).size();
        return new CustomerOrganizationWithMemberCount(org, membersCount);
    }

    private void addOrganizationMembers(int organizationId, Collection<String> newMembers, DatabaseConnection databaseConnection) {
        if (newMembers.isEmpty()) {
            return;
        }
        SQLInsertClause insertClause = databaseConnection.insert((RelationalPath)Tables.ORGANIZATION_MEMBER);
        newMembers.forEach(userKey -> insertClause.set(Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID, (Object)organizationId).set((Path)Tables.ORGANIZATION_MEMBER.USER_KEY, userKey).addBatch());
        try {
            insertClause.execute();
        }
        catch (QueryException ex) {
            throw new OrganizationNotFoundException(String.format("Could not find Organization of the given id: %s", organizationId), Sets.newHashSet((Object[])new Integer[]{organizationId}));
        }
    }

    private List<String> filterOrganizationMembers(int organizationId, Set<String> userKeys, DatabaseConnection databaseConnection) {
        return ((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.ORGANIZATION_MEMBER.USER_KEY).from((Expression)Tables.ORGANIZATION_MEMBER)).where((Predicate)Tables.ORGANIZATION_MEMBER.ORGANIZATION_ID.eq((Object)organizationId).and((Predicate)Tables.ORGANIZATION_MEMBER.USER_KEY.in(userKeys)))).fetch();
    }
}

