/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.api;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Unit;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.organization.CreateOrganizationParameters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.organization.OrganizationService;
import com.atlassian.servicedesk.api.organization.OrganizationServiceDeskUpdateParameters;
import com.atlassian.servicedesk.api.organization.OrganizationsQuery;
import com.atlassian.servicedesk.api.organization.UsersInOrganizationQuery;
import com.atlassian.servicedesk.api.organization.UsersOrganizationUpdateParameters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.feature.organization.member.CustomerOrganizationMemberService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationService;
import com.atlassian.servicedesk.internal.feature.organization.InviteCustomerOrganizationsParams;
import com.atlassian.servicedesk.internal.feature.organization.InviteCustomerOrganizationsResult;
import com.atlassian.servicedesk.internal.feature.organization.api.CreateOrganizationParametersImpl;
import com.atlassian.servicedesk.internal.feature.organization.api.OrganizationServiceDeskUpdateParametersImpl;
import com.atlassian.servicedesk.internal.feature.organization.api.OrganizationsQueryImpl;
import com.atlassian.servicedesk.internal.feature.organization.api.UsersInOrganizationQueryImpl;
import com.atlassian.servicedesk.internal.feature.organization.api.UsersOrganizationUpdateParametersImpl;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.feature.organization.project.CustomerOrganizationProjectService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class OrganizationServiceImpl
implements OrganizationService {
    private CustomerOrganizationService customerOrganizationService;
    private UserFactory userFactory;
    private CustomerOrganizationMemberService memberService;
    private CustomerOrganizationProjectService customerOrganizationProjectService;
    private ServiceDeskProjectService serviceDeskProjectService;
    private ServiceDeskService serviceDeskService;
    private CustomerOrganizationError customerOrganizationError;

    @Autowired
    public OrganizationServiceImpl(CustomerOrganizationService customerOrganizationService, UserFactory userFactory, CustomerOrganizationMemberService memberService, CustomerOrganizationProjectService customerOrganizationProjectService, ServiceDeskProjectService serviceDeskProjectService, ServiceDeskService serviceDeskService, CustomerOrganizationError customerOrganizationError) {
        this.customerOrganizationService = customerOrganizationService;
        this.userFactory = userFactory;
        this.memberService = memberService;
        this.customerOrganizationProjectService = customerOrganizationProjectService;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.serviceDeskService = serviceDeskService;
        this.customerOrganizationError = customerOrganizationError;
    }

    public Either<AnError, CustomerOrganization> getById(@Nonnull ApplicationUser user, @Nonnull Integer organisationId) {
        Objects.requireNonNull(user);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.customerOrganizationService.getOrganization((CheckedUser)checkedUser, organisationId)).yield((checkedUser, customerOrganisation) -> customerOrganisation));
    }

    public Either<AnError, CustomerOrganization> createOrganization(@Nonnull ApplicationUser user, @Nonnull CreateOrganizationParameters parameters) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(parameters);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.customerOrganizationService.createOrganization((CheckedUser)checkedUser, parameters)).yield((checkedUser, customerOrganisation) -> customerOrganisation));
    }

    public CreateOrganizationParameters.Builder newCreateBuilder() {
        return new CreateOrganizationParametersImpl.BuilderImpl();
    }

    public Either<AnError, PagedResponse<ApplicationUser>> getUsersInOrganization(@Nonnull ApplicationUser user, @Nonnull UsersInOrganizationQuery query) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(query);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.memberService.getOrganizationMembers(checkedUser, (Set)Sets.newHashSet((Object[])new Integer[]{query.organization().getId()}))).yield((checkedUser, users) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)query.pagedRequest(), (List)Lists.newArrayList((Iterable)users))));
    }

    public UsersInOrganizationQuery.Builder newUsersInOrganizationQuery() {
        return new UsersInOrganizationQueryImpl.BuilderImpl();
    }

    public Either<AnError, Unit> addUsersToOrganization(@Nonnull ApplicationUser executingUser, @Nonnull UsersOrganizationUpdateParameters parameters) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(executingUser))).then(executingCheckedUser -> StepsConverters.newerEither((Either)this.userFactory.wrap((Collection)parameters.users()))).then((executingCheckedUser, users) -> this.memberService.addUsers(executingCheckedUser, (Set)Sets.newHashSet((Iterable)users), parameters.organization())).yield((executingCheckedUser, users, unit) -> Unit.Unit()));
    }

    public UsersOrganizationUpdateParameters.Builder newUsersOrganizationUpdateParametersBuilder() {
        return new UsersOrganizationUpdateParametersImpl.BuilderImpl();
    }

    public Either<AnError, Unit> removeUsersFromOrganization(@Nonnull ApplicationUser user, @Nonnull UsersOrganizationUpdateParameters parameters) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> StepsConverters.newerEither((Either)this.userFactory.wrap((Collection)parameters.users()))).then((checkedUser, users) -> this.memberService.removeUsersFromOrganization(checkedUser, parameters.organization(), (Set)Sets.newHashSet((Iterable)users)).map(unit -> Unit.Unit())).yield((checkedUser, users, unit) -> unit));
    }

    public Either<AnError, Unit> delete(@Nonnull ApplicationUser user, @Nonnull Integer organizationId) {
        Objects.requireNonNull(user);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.customerOrganizationService.getOrganization((CheckedUser)checkedUser, organizationId)).then((checkedUser, organisation) -> this.customerOrganizationService.deleteOrganization((CheckedUser)checkedUser, (CustomerOrganization)organisation).map(unit -> Unit.Unit())).yield((checkedUser, organisation, unit) -> unit));
    }

    public Either<AnError, PagedResponse<CustomerOrganization>> getOrganizations(@Nonnull ApplicationUser user, @Nonnull OrganizationsQuery requestQuery) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(requestQuery);
        if (requestQuery.serviceDeskId().isDefined()) {
            return this.getCustomerOrganizationsInServiceDesk(user, requestQuery);
        }
        return this.getAllOrganizations(user, requestQuery);
    }

    public OrganizationsQuery.Builder newOrganizationsQueryBuilder() {
        return OrganizationsQueryImpl.builder();
    }

    public Either<AnError, Unit> addOrganizationToServiceDesk(@Nonnull ApplicationUser user, @Nonnull OrganizationServiceDeskUpdateParameters organizationServiceDeskUpdateParameters) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(organizationServiceDeskUpdateParameters);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskById(user, (long)organizationServiceDeskUpdateParameters.serviceDeskId().intValue()))).then((checkedUser, serviceDesk) -> this.serviceDeskProjectService.getProjectById((CheckedUser)checkedUser, serviceDesk.getProjectId())).then((checkedUser, inviteParams, project) -> this.customerOrganizationProjectService.addOrganizations((CheckedUser)checkedUser, this.buildInviteOrganisationParams(organizationServiceDeskUpdateParameters.organization().getId(), (Project)project))).then((checkedUser, inviteParams, project, result) -> StepsConverters.newerEither(this.convertInviteCustomerOrganizationResult((InviteCustomerOrganizationsResult)result))).yield((checkedUser, inviteParams, project, result, unit) -> unit));
    }

    public Either<AnError, Unit> removeOrganizationFromServiceDesk(@Nonnull ApplicationUser user, @Nonnull OrganizationServiceDeskUpdateParameters organizationServiceDeskUpdateParameters) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(organizationServiceDeskUpdateParameters);
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskById(user, (long)organizationServiceDeskUpdateParameters.serviceDeskId().intValue()))).then((checkedUser, serviceDesk) -> this.serviceDeskProjectService.getProjectById((CheckedUser)checkedUser, serviceDesk.getProjectId())).then((checkedUser, inviteParams, project) -> this.customerOrganizationProjectService.disassociateOrganization((CheckedUser)checkedUser, (Project)project, organizationServiceDeskUpdateParameters.organization()).map(unit -> Unit.Unit())).yield((checkedUser, inviteParams, project, unit) -> unit));
    }

    public OrganizationServiceDeskUpdateParameters.Builder newOrganizationServiceDeskUpdateParametersBuilder() {
        return OrganizationServiceDeskUpdateParametersImpl.builder();
    }

    private Either<AnError, Unit> convertInviteCustomerOrganizationResult(InviteCustomerOrganizationsResult result) {
        if (result.hasInvalidIds()) {
            return Either.left((Object)this.customerOrganizationError.ORGANISATION_NOT_FOUND(Sets.newHashSet(result.getInvalidIds())));
        }
        return Either.right((Object)Unit.Unit());
    }

    private InviteCustomerOrganizationsParams buildInviteOrganisationParams(Integer organisationId, Project project) {
        return new InviteCustomerOrganizationsParams(Collections.emptySet(), Sets.newHashSet((Object[])new Integer[]{organisationId}), project);
    }

    private Either<AnError, PagedResponse<CustomerOrganization>> getAllOrganizations(@Nonnull ApplicationUser user, @Nonnull OrganizationsQuery query) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.customerOrganizationService.getOrganizations((CheckedUser)checkedUser)).yield((checkedUser, organizations) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)query.pagedRequest(), (List)organizations)));
    }

    private Either<AnError, PagedResponse<CustomerOrganization>> getCustomerOrganizationsInServiceDesk(@Nonnull ApplicationUser user, @Nonnull OrganizationsQuery query) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskById(user, (long)((Integer)query.serviceDeskId().getOrElse((Object)-1)).intValue()))).then((checkedUser, serviceDesk) -> this.serviceDeskProjectService.getProjectById((CheckedUser)checkedUser, serviceDesk.getProjectId())).then((checkedUser, serviceDesk, project) -> this.customerOrganizationProjectService.getOrganizations((CheckedUser)checkedUser, (Project)project)).yield((checkedUser, serviceDesk, project, organizations) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)query.pagedRequest(), (List)Lists.newArrayList((Iterable)organizations))));
    }
}

