/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.organization.CreateOrganizationParameters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationService;
import com.atlassian.servicedesk.internal.feature.organization.UpdateOrganizationParams;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithOtherProjectCount;
import com.atlassian.servicedesk.internal.feature.organization.setting.CustomerOrganizationSettingService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOrganizationServiceImpl
implements CustomerOrganizationService {
    private final FeatureManager featureManager;
    private final CommonErrors commonErrors;
    private final CustomerOrganizationManager customerOrganizationManager;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CustomerOrganizationSettingService organizationSettingService;
    private final CustomerOrganizationError organizationError;
    private final CustomerOrganizationError customerOrganizationError;
    private final CustomerOrganizationMemberManager customerOrganizationMemberManager;

    @Autowired
    public CustomerOrganizationServiceImpl(FeatureManager featureManager, CommonErrors commonErrors, CustomerOrganizationManager customerOrganizationManager, ServiceDeskPermissions serviceDeskPermissions, CustomerOrganizationSettingService organizationSettingService, CustomerOrganizationError organizationError, CustomerOrganizationError customerOrganizationError, CustomerOrganizationMemberManager customerOrganizationMemberManager) {
        this.featureManager = featureManager;
        this.commonErrors = commonErrors;
        this.customerOrganizationManager = customerOrganizationManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.organizationSettingService = organizationSettingService;
        this.organizationError = organizationError;
        this.customerOrganizationError = customerOrganizationError;
        this.customerOrganizationMemberManager = customerOrganizationMemberManager;
    }

    @Override
    public Either<AnError, Unit> deleteOrganization(@Nonnull CheckedUser user, @Nonnull CustomerOrganization organization) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.organizationSettingService.canDeleteOrganizations(user)) {
            return Either.left((Object)this.organizationError.NO_DELETE_ORGANIZATION_PERMISSION());
        }
        this.customerOrganizationManager.deleteOrganization(organization.getId());
        return Either.right((Object)Unit.Unit());
    }

    @Override
    public Either<AnError, CustomerOrganization> getOrganization(@Nonnull CheckedUser checkedUser, int orgId) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.organizationSettingService.canViewAllOrganizations(checkedUser) && !this.customerOrganizationMemberManager.isMemberOfOrganization(checkedUser, orgId)) {
            return Either.left((Object)this.customerOrganizationError.USER_DOES_NOT_HAVE_VIEW_ORGANIZATION_PERMISSION());
        }
        return this.customerOrganizationManager.getOrganizationById(orgId);
    }

    @Override
    public Either<AnError, CustomerOrganization> updateOrganization(CheckedUser user, CustomerOrganization organization, UpdateOrganizationParams updateOrganizationParams) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.organizationSettingService.canManageOrganizations(user)) {
            return Either.left((Object)this.organizationError.NO_MANAGE_ORGANIZATION_PERMISSION());
        }
        return this.customerOrganizationManager.updateOrganization(organization, updateOrganizationParams);
    }

    @Override
    public Either<AnError, List<CustomerOrganization>> getOrganizations(CheckedUser checkedUser) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (this.organizationSettingService.canViewAllOrganizations(checkedUser)) {
            return Either.right(this.customerOrganizationManager.getAllOrganizations());
        }
        return Either.right(this.customerOrganizationMemberManager.getOrganizationsForUser(checkedUser));
    }

    @Override
    public Either<AnError, CustomerOrganizationWithOtherProjectCount> getOrganizationWithOtherProjectCount(@Nonnull CheckedUser checkedUser, @Nonnull Project projectToExcludeFromCount, @Nonnull CustomerOrganization customerOrganization) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewAgentView((SDUser)checkedUser, projectToExcludeFromCount)) {
            return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        return this.customerOrganizationManager.getOrganizationWithOtherProjectCount(projectToExcludeFromCount, customerOrganization);
    }

    @Override
    public Either<AnError, CustomerOrganization> createOrganization(CheckedUser user, CreateOrganizationParameters parameters) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return Steps.begin(this.validate(parameters)).then(success -> this.organizationSettingService.canManageOrganizationsEither(user)).then((success, validation) -> this.customerOrganizationManager.createOrganization(parameters.name())).yield((success, validation, organization) -> organization);
    }

    private Either<AnError, JSDSuccess> validate(CreateOrganizationParameters parameters) {
        if (StringUtils.isEmpty((String)parameters.name())) {
            return Either.left((Object)this.customerOrganizationError.ORGANIZATION_NAME_EMPTY());
        }
        return Either.right((Object)((Object)JSDSuccess.success()));
    }
}

