/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.notificationsubscription.email;

import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.errors.SubscriptionErrors;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionService;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.email.RequestEmailSubscriptionService;
import com.atlassian.servicedesk.internal.notifications.render.InternalUnsubscribeLinkHelper;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestEmailSubscriptionServiceImpl
implements RequestEmailSubscriptionService {
    private final NotificationSubscriptionService notificationSubscriptionService;
    private final InternalUnsubscribeLinkHelper unsubscribeLinkHelper;
    private final SubscriptionErrors subscriptionErrors;

    @Autowired
    public RequestEmailSubscriptionServiceImpl(NotificationSubscriptionService notificationSubscriptionService, InternalUnsubscribeLinkHelper unsubscribeLinkHelper, SubscriptionErrors subscriptionErrors) {
        this.notificationSubscriptionService = notificationSubscriptionService;
        this.unsubscribeLinkHelper = unsubscribeLinkHelper;
        this.subscriptionErrors = subscriptionErrors;
    }

    @Override
    public Either<AnError, Unit> unsubscribeFromEmail(@Nonnull Issue issue, @Nonnull String token, @Nonnull String jsonPayload) {
        Option<CheckedUser> user = this.unsubscribeLinkHelper.getUnsubscribedUser(jsonPayload);
        if (user.isEmpty()) {
            return Either.left((Object)this.subscriptionErrors.CANNOT_NOT_FIND_USER_TO_UNSUBSCRIBE_VIA_EMAIL());
        }
        CheckedUser checkedUser = (CheckedUser)user.get();
        if (!checkedUser.forJIRA().isActive()) {
            return Either.left((Object)this.subscriptionErrors.UNABLE_TO_UNSUBSCRIBE_IN_ACTIVE_USER());
        }
        return this.notificationSubscriptionService.unsubscribe((CheckedUser)user.get(), issue);
    }
}

