/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.notificationsubscription;

import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.errors.SubscriptionErrors;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionManager;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationSubscriptionServiceImpl
implements NotificationSubscriptionService {
    private final NotificationSubscriptionManager subscriptionManager;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final SubscriptionErrors subscriptionErrors;

    @Autowired
    public NotificationSubscriptionServiceImpl(NotificationSubscriptionManager subscriptionManager, ServiceDeskPermissions serviceDeskPermissions, SubscriptionErrors subscriptionErrors) {
        this.subscriptionManager = subscriptionManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.subscriptionErrors = subscriptionErrors;
    }

    @Override
    public Set<CheckedUser> getSubscribers(Issue issue) {
        return this.subscriptionManager.getSubscribers(issue);
    }

    @Override
    public Set<CheckedUser> getUsersWithSubscriptionRecord(Issue issue) {
        return this.subscriptionManager.getUsersWithSubscriptionRecord(issue);
    }

    @Override
    public Either<AnError, Unit> subscribe(CheckedUser checkedUser, Issue issue) {
        return this.updateSubscription(checkedUser, issue, true);
    }

    @Override
    public Either<AnError, Collection<CheckedUser>> subscribe(Collection<CheckedUser> checkedUsers, Issue issue, boolean isOverrideExistingRecord) {
        Collection userToSubscribed;
        Collection qualifiedUsers = checkedUsers.stream().filter(user -> this.canViewOrChangeNotificationSettings((CheckedUser)user, issue)).collect(Collectors.toSet());
        if (!isOverrideExistingRecord) {
            Set<CheckedUser> userWithSubscriptionRecords = this.subscriptionManager.getSubscribers(issue);
            userToSubscribed = CollectionUtils.subtract((Collection)qualifiedUsers, userWithSubscriptionRecords);
        } else {
            userToSubscribed = qualifiedUsers;
        }
        if (userToSubscribed.isEmpty()) {
            return Either.right((Object)Sets.newHashSet());
        }
        this.subscriptionManager.subscribe(userToSubscribed, issue);
        return Either.right((Object)userToSubscribed);
    }

    @Override
    public Either<AnError, Unit> unsubscribe(CheckedUser checkedUser, Issue issue) {
        return this.updateSubscription(checkedUser, issue, false);
    }

    @Override
    public Either<AnError, Boolean> isSubscribed(CheckedUser checkedUser, Issue issue) {
        if (!this.canViewOrChangeNotificationSettings(checkedUser, issue)) {
            return Either.left((Object)this.subscriptionErrors.CANNOT_VIEW_OR_CHANGE_NOTIFICATION_SETTINGS());
        }
        boolean isSubscribed = this.subscriptionManager.isSubscribed(checkedUser, issue);
        return Either.right((Object)isSubscribed);
    }

    private Either<AnError, Unit> updateSubscription(CheckedUser checkedUser, Issue issue, boolean doSubscribe) {
        if (!this.canViewOrChangeNotificationSettings(checkedUser, issue)) {
            return Either.left((Object)this.subscriptionErrors.CANNOT_VIEW_OR_CHANGE_NOTIFICATION_SETTINGS());
        }
        if (doSubscribe) {
            this.subscriptionManager.subscribe(checkedUser, issue);
        } else {
            this.subscriptionManager.unsubscribe(checkedUser, issue);
        }
        return Either.right((Object)Unit.Unit());
    }

    private boolean canViewOrChangeNotificationSettings(CheckedUser checkedUser, Issue issue) {
        return this.serviceDeskPermissions.userIsCustomerOfIssue((SDUser)checkedUser, issue);
    }
}

