/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.notificationsubscription;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.permission.security.CustomerInvolvedService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalManager;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationSubscriptionDefaultHelper {
    private final RequestParticipantsInternalManager participantsInternalManager;
    private final UserFactory userFactory;
    private final CustomerInvolvedService customersInvolvedService;

    @Autowired
    public NotificationSubscriptionDefaultHelper(RequestParticipantsInternalManager participantsInternalManager, UserFactory userFactory, CustomerInvolvedService customersInvolvedService) {
        this.participantsInternalManager = participantsInternalManager;
        this.userFactory = userFactory;
        this.customersInvolvedService = customersInvolvedService;
    }

    public boolean getDefaultValueForUser(CheckedUser user, Issue issue) {
        return this.customersInvolvedService.isUserOfType(user, issue, new CustomerInvolvedType[]{CustomerInvolvedType.REPORTER, CustomerInvolvedType.REQUEST_PARTICIPANT});
    }

    public Set<CheckedUser> getDefaultPotentialSubscribers(Issue issue) {
        List participants = (List)this.participantsInternalManager.getValidParticipants(issue).getOrElse(Collections.emptyList());
        HashSet defaultSubscribers = Sets.newHashSet((Iterable)participants);
        Option<CheckedUser> reporterUser = this.getReporterUser(issue);
        if (reporterUser.isDefined()) {
            defaultSubscribers.add(reporterUser.get());
        }
        return defaultSubscribers;
    }

    private Option<CheckedUser> getReporterUser(Issue issue) {
        ApplicationUser reporterUser = issue.getReporterUser();
        if (reporterUser == null) {
            return Option.none();
        }
        return StepsConverters.newerOption((com.atlassian.fugue.Option)this.userFactory.wrap(reporterUser).toOption());
    }
}

