/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.notificationsubscription;

import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionDao;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionRecord;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class NotificationSubscriptionDaoImpl
implements NotificationSubscriptionDao {
    public static final boolean DEFAULT_VALUE_IF_NO_RECORD = false;

    @Override
    public Collection<NotificationSubscriptionRecord> getAllSubscriptionRecords(Issue issue, DatabaseConnection databaseConnection) {
        try {
            List results = ((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.SUBSCRIPTION.all()).from((Expression)Tables.SUBSCRIPTION)).where((Predicate)Tables.SUBSCRIPTION.ISSUE_ID.eq((Object)issue.getId()))).fetch();
            return results.stream().map(result -> this.tupleToSubscriptionDbObject((Tuple)result)).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get all Subscription Records", ex);
        }
    }

    @Override
    public Collection<NotificationSubscriptionRecord> getSubscriptionRecords(Issue issue, boolean isSubscribed, DatabaseConnection databaseConnection) {
        try {
            List results = ((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.SUBSCRIPTION.all()).from((Expression)Tables.SUBSCRIPTION)).where((Predicate)Tables.SUBSCRIPTION.ISSUE_ID.eq((Object)issue.getId()).and((Predicate)Tables.SUBSCRIPTION.SUBSCRIBED.eq(Boolean.valueOf(isSubscribed))))).fetch();
            return results.stream().map(result -> this.tupleToSubscriptionDbObject((Tuple)result)).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get Subscription Records", ex);
        }
    }

    @Override
    public Option<NotificationSubscriptionRecord> getSubscriptionRecord(CheckedUser user, Issue issue, DatabaseConnection databaseConnection) {
        try {
            Tuple result = (Tuple)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.SUBSCRIPTION.all()).from((Expression)Tables.SUBSCRIPTION)).where((Predicate)Tables.SUBSCRIPTION.ISSUE_ID.eq((Object)issue.getId()).and((Predicate)Tables.SUBSCRIPTION.USER_KEY.eq((Object)user.getKey())))).fetchFirst();
            return result == null ? Option.none() : Option.some((Object)this.tupleToSubscriptionDbObject(result));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get Subscription Records for User", ex);
        }
    }

    @Override
    public boolean isSubscribed(CheckedUser user, Issue issue, DatabaseConnection databaseConnection) {
        try {
            Boolean isSubscribed = (Boolean)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.SUBSCRIPTION.SUBSCRIBED).from((Expression)Tables.SUBSCRIPTION)).where((Predicate)Tables.SUBSCRIPTION.ISSUE_ID.eq((Object)issue.getId()).and((Predicate)Tables.SUBSCRIPTION.USER_KEY.eq((Object)user.getKey())))).fetchFirst();
            return isSubscribed == null ? false : isSubscribed;
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to check if a user is subscribed", ex);
        }
    }

    @Override
    public void createOrUpdateSubscription(CheckedUser subscriber, Issue issue, boolean subscribed, DatabaseConnection databaseConnection) {
        if (this.hasSubscription(subscriber, issue, databaseConnection)) {
            this.updateSubscription(subscriber, issue, subscribed, databaseConnection);
        } else {
            this.createSubscription(subscriber, issue, subscribed, databaseConnection);
        }
    }

    @Override
    public void createOrUpdateSubscriptions(Collection<CheckedUser> subscribers, Issue issue, boolean subscribed, DatabaseConnection databaseConnection) {
        try {
            Set<CheckedUser> usersWithExistingRecords = this.filterUsersWhoAlreadyHasSubscriptionRecords(subscribers, issue, databaseConnection);
            Collection usersWithoutRecords = CollectionUtils.subtract(subscribers, usersWithExistingRecords);
            this.updateBatchSubscription(usersWithExistingRecords, issue, subscribed, databaseConnection);
            this.createBatchSubscription(usersWithoutRecords, issue, subscribed, databaseConnection);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to batch create/update subscription", ex);
        }
    }

    private Set<CheckedUser> filterUsersWhoAlreadyHasSubscriptionRecords(Collection<CheckedUser> subscribers, Issue issue, DatabaseConnection databaseConnection) {
        try {
            Set userKeys = subscribers.stream().map(user -> user.getKey()).collect(Collectors.toSet());
            List userKeysWithExistingRecords = ((SQLQuery)((SQLQuery)databaseConnection.select((Expression)Tables.SUBSCRIPTION.USER_KEY).from((Expression)Tables.SUBSCRIPTION)).where((Predicate)Tables.SUBSCRIPTION.ISSUE_ID.eq((Object)issue.getId()).and((Predicate)Tables.SUBSCRIPTION.USER_KEY.in(userKeys)))).fetch();
            if (CollectionUtils.isEmpty((Collection)userKeysWithExistingRecords)) {
                return new HashSet<CheckedUser>();
            }
            return subscribers.stream().filter(user -> userKeysWithExistingRecords.contains(user.getKey())).collect(Collectors.toSet());
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to filter users who already has subscription", ex);
        }
    }

    private void updateSubscription(CheckedUser subscriber, Issue issue, boolean isSubscribed, DatabaseConnection databaseConnection) {
        try {
            databaseConnection.update((RelationalPath)Tables.SUBSCRIPTION).set((Path)Tables.SUBSCRIPTION.SUBSCRIBED, (Object)isSubscribed).where((Predicate)Tables.SUBSCRIPTION.ISSUE_ID.eq((Object)issue.getId()).and((Predicate)Tables.SUBSCRIPTION.USER_KEY.eq((Object)subscriber.getKey()))).execute();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to update a subscription", ex);
        }
    }

    private void updateBatchSubscription(Collection<CheckedUser> subscribers, Issue issue, boolean isSubscribed, DatabaseConnection databaseConnection) {
        if (subscribers.isEmpty()) {
            return;
        }
        try {
            SQLUpdateClause sqlBatchUpdateClause = databaseConnection.update((RelationalPath)Tables.SUBSCRIPTION);
            subscribers.stream().forEach(user -> {
                sqlBatchUpdateClause.set((Path)Tables.SUBSCRIPTION.SUBSCRIBED, (Object)isSubscribed).where((Predicate)Tables.SUBSCRIPTION.ISSUE_ID.eq((Object)issue.getId()).and((Predicate)Tables.SUBSCRIPTION.USER_KEY.eq((Object)user.getKey())));
                sqlBatchUpdateClause.addBatch();
            });
            sqlBatchUpdateClause.execute();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to update a subscription", ex);
        }
    }

    private boolean hasSubscription(CheckedUser subscriber, Issue issue, DatabaseConnection databaseConnection) {
        try {
            long count = ((SQLQuery)((SQLQuery)databaseConnection.select(Tables.SUBSCRIPTION.ID).from((Expression)Tables.SUBSCRIPTION)).where((Predicate)Tables.SUBSCRIPTION.ISSUE_ID.eq((Object)issue.getId()).and((Predicate)Tables.SUBSCRIPTION.USER_KEY.eq((Object)subscriber.getKey())))).fetchCount();
            return count > 0L;
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to check if user has subscription record", ex);
        }
    }

    private void createSubscription(CheckedUser subscriber, Issue issue, boolean isSubscribed, DatabaseConnection databaseConnection) {
        try {
            databaseConnection.insert((RelationalPath)Tables.SUBSCRIPTION).set(Tables.SUBSCRIPTION.ISSUE_ID, (Object)issue.getId()).set((Path)Tables.SUBSCRIPTION.USER_KEY, (Object)subscriber.getKey()).set((Path)Tables.SUBSCRIPTION.SUBSCRIBED, (Object)isSubscribed).executeWithKey(Tables.SUBSCRIPTION.ID);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to create a subscription", ex);
        }
    }

    private void createBatchSubscription(Collection<CheckedUser> subscribers, Issue issue, boolean isSubscribed, DatabaseConnection databaseConnection) {
        if (subscribers.isEmpty()) {
            return;
        }
        try {
            SQLInsertClause sqlInsertBatchClause = databaseConnection.insert((RelationalPath)Tables.SUBSCRIPTION);
            subscribers.stream().forEach(user -> {
                sqlInsertBatchClause.set(Tables.SUBSCRIPTION.ISSUE_ID, (Object)issue.getId()).set((Path)Tables.SUBSCRIPTION.USER_KEY, (Object)user.getKey()).set((Path)Tables.SUBSCRIPTION.SUBSCRIBED, (Object)isSubscribed);
                sqlInsertBatchClause.addBatch();
            });
            sqlInsertBatchClause.execute();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to create a subscription", ex);
        }
    }

    private NotificationSubscriptionRecord tupleToSubscriptionDbObject(Tuple tuple) {
        return new NotificationSubscriptionRecord((Long)tuple.get(Tables.SUBSCRIPTION.ISSUE_ID), (String)tuple.get((Expression)Tables.SUBSCRIPTION.USER_KEY), (Boolean)tuple.get((Expression)Tables.SUBSCRIPTION.SUBSCRIBED));
    }
}

