/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.language;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.feature.gettingstarted.PostServiceDeskCreationParticipant;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInputBuilderFactory;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
class ServiceDeskLanguagePostCreationParticipant
implements PostServiceDeskCreationParticipant {
    private final LingoProjectLanguageManager lingoProjectLanguageManager;
    private final LingoProjectLanguageInputBuilderFactory inputBuilderFactory;
    private final ApplicationProperties applicationProperties;
    private final FeatureManager featureManager;

    @Autowired
    public ServiceDeskLanguagePostCreationParticipant(LingoProjectLanguageManager lingoProjectLanguageManager, LingoProjectLanguageInputBuilderFactory inputBuilderFactory, ApplicationProperties applicationProperties, FeatureManager featureManager) {
        this.lingoProjectLanguageManager = lingoProjectLanguageManager;
        this.inputBuilderFactory = inputBuilderFactory;
        this.applicationProperties = applicationProperties;
        this.featureManager = featureManager;
    }

    public Either<AnError, Unit> executePostCreationJob(ApplicationUser applicationUser, Project project) {
        if (this.shouldCreateLanguageSetting(project)) {
            Either input = this.inputBuilderFactory.newBuilder(project.getId().longValue()).addLanguage(this.applicationProperties.getDefaultLocale(), true).defaultLanguage(this.applicationProperties.getDefaultLocale()).build();
            return input.map(arg_0 -> ((LingoProjectLanguageManager)this.lingoProjectLanguageManager).storeProjectLanguages(arg_0)).map(configuration -> Unit.Unit());
        }
        return Either.right((Object)Unit.Unit());
    }

    private boolean shouldCreateLanguageSetting(Project project) {
        return this.isManageLanguageFeatureEnabled() && this.hasNoCustomLanguageSetting(project);
    }

    private boolean hasNoCustomLanguageSetting(Project project) {
        return !this.lingoProjectLanguageManager.isCustomLanguageSetting(project.getId().longValue());
    }

    private boolean isManageLanguageFeatureEnabled() {
        return (Boolean)this.featureManager.getFeatureFlag("sd.custom.email.notifications.manage.language").map(arg_0 -> ((FeatureManager)this.featureManager).isEnabled(arg_0)).getOrElse((Object)false);
    }
}

