/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.language;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectConfiguration;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInput;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import com.atlassian.servicedesk.internal.feature.language.ManageLanguageService;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ManageLanguageServiceImpl
implements ManageLanguageService {
    private final LingoProjectLanguageManager lingoProjectLanguageManager;
    private final ServiceDeskService serviceDeskService;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final CommonErrors commonErrors;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public ManageLanguageServiceImpl(LingoProjectLanguageManager lingoProjectLanguageManager, ServiceDeskService serviceDeskService, ServiceDeskPermissionService serviceDeskPermissionService, CommonErrors commonErrors, ErrorResultHelper errorResultHelper) {
        this.lingoProjectLanguageManager = lingoProjectLanguageManager;
        this.serviceDeskService = serviceDeskService;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.commonErrors = commonErrors;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public Either<AnError, LingoProjectConfiguration> getProjectLanguageConfiguration(CheckedUser user, Project project) {
        return this.checkProjectAdminAgentPermission(user, project).map(u -> this.getProjectLanguageConfigurationInternal(project));
    }

    @Override
    public Either<AnError, LingoProjectConfiguration> storeProjectConfiguration(CheckedUser user, Project project, LingoProjectLanguageInput input) {
        return this.checkProjectAdminAgentPermission(user, project).flatMap(u -> this.lingoProjectLanguageManager.storeProjectLanguages(input).toRight(() -> this.errorResultHelper.badRequest400("sd.languages.manage.store.missing.languages", new Object[0]).build()));
    }

    private LingoProjectConfiguration getProjectLanguageConfigurationInternal(Project project) {
        return this.lingoProjectLanguageManager.retrieveLingoProjectConfiguration(project.getId().longValue());
    }

    private Either<AnError, CheckedUser> checkProjectAdminAgentPermission(CheckedUser user, Project project) {
        boolean isAdminAgent2 = (Boolean)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project).flatMap(serviceDesk -> this.serviceDeskPermissionService.isAdminAgent(user.forJIRA(), serviceDesk)).getOrElse((Object)false);
        if (isAdminAgent2) {
            return Either.right((Object)user);
        }
        return Either.left((Object)this.commonErrors.PROJECT_ADMIN_PERMISSION());
    }
}

