/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.gettingstarted;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.requesttype.icons.RequestTypeSystemIcon;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalGettingStartedHelper;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApproversCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.customfields.template.util.CascadingCustomFieldUtil;
import com.atlassian.servicedesk.internal.feature.customfields.template.util.ProjectTemplateCustomFieldsManager;
import com.atlassian.servicedesk.internal.feature.gettingstarted.DefaultFieldConfig;
import com.atlassian.servicedesk.internal.feature.gettingstarted.FieldConfigBuilder;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.DefaultKeys;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeIssueTypeMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectComponentMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectQueueMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectStatusMapping;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeRequestTypeMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeWorkflowPresets;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeWorkflowPresetsEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Maybe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ITILV2ServiceDeskProjectMetadata
implements PremadeProjectMetadata {
    private static final String COMMON_REQUESTS_GROUP_KEY = "sd.project.template.itil.v2.request.type.groups.common";
    private static final String LOGINS_GROUP_KEY = "sd.project.template.itil.v2.request.type.groups.logins";
    private static final String COMPUTERS_GROUP_KEY = "sd.project.template.itil.v2.request.type.groups.computers";
    private static final String APPLICATIONS_GROUP_KEY = "sd.project.template.itil.v2.request.type.groups.applications";
    private static final String SERVERS_GROUP_KEY = "sd.project.template.itil.v2.request.type.groups.servers";
    private static final String REQUEST_DESK_PHONE_RT_KEY = "requestdeskphone";
    private static final String NEW_MOBILE_DEVICE_RT_KEY = "newmobiledevice";
    private static final String PENDING_REASON_SCREEN_NAME = "JIRA Service Desk Pending Reason screen";
    private static final String CHANGE_CREATE_SCREEN_NAME_KEY = "sd.project.template.itil.v2.screens.change.create.name";
    private static final String CHANGE_EDIT_SCREEN_NAME_KEY = "sd.project.template.itil.v2.screens.change.edit.name";
    private static final String INCIDENT_CREATE_SCREEN_NAME_KEY = "sd.project.template.itil.v2.screens.incident.create.name";
    private static final String INCIDENT_EDIT_SCREEN_NAME_KEY = "sd.project.template.itil.v2.screens.incident.edit.name";
    private static final String PROBLEM_CREATE_SCREEN_NAME_KEY = "sd.project.template.itil.v2.screens.problem.create.name";
    private static final String PROBLEM_EDIT_SCREEN_NAME_KEY = "sd.project.template.itil.v2.screens.problem.edit.name";
    private static final String REQUEST_EDIT_SCREEN_NAME_KEY = "sd.project.template.itil.v2.screens.request.edit.name";
    private final I18nHelper i18n;
    private final SearchService searchService;
    private final PriorityManager priorityManager;
    private final ApproversCustomFieldManager approversCustomFieldManager;
    private final ApprovalGettingStartedHelper approvalGettingStartedHelper;
    private final ProjectTemplateCustomFieldsManager customFieldsManager;

    public ITILV2ServiceDeskProjectMetadata(I18nHelper i18n, SearchService searchService, PriorityManager priorityManager, ApproversCustomFieldManager approversCustomFieldManager, ApprovalGettingStartedHelper approvalGettingStartedHelper, ProjectTemplateCustomFieldsManager customFieldsManager) {
        this.i18n = i18n;
        this.searchService = searchService;
        this.priorityManager = priorityManager;
        this.approversCustomFieldManager = approversCustomFieldManager;
        this.approvalGettingStartedHelper = approvalGettingStartedHelper;
        this.customFieldsManager = customFieldsManager;
    }

    @Override
    public List<PremadeProjectComponentMetadata> components(Project project) {
        return this.components();
    }

    @Override
    public List<PremadeIssueTypeMetadata> issueTypes(Project project) {
        return this.issueTypes();
    }

    @Override
    public void addCustomFieldsToScreen(FieldScreen fieldScreen) {
        if (fieldScreen.getName().contains(PENDING_REASON_SCREEN_NAME)) {
            this.handlePendingReasonScreen(fieldScreen);
        } else if (fieldScreen.getName().contains(this.i18n.getText(CHANGE_CREATE_SCREEN_NAME_KEY))) {
            this.handleChangeCreateIssueScreen(fieldScreen);
        } else if (fieldScreen.getName().contains(this.i18n.getText(CHANGE_EDIT_SCREEN_NAME_KEY))) {
            this.handleChangeEditIssueScreen(fieldScreen);
        } else if (fieldScreen.getName().contains(this.i18n.getText(INCIDENT_CREATE_SCREEN_NAME_KEY))) {
            this.handleIncidentCreateIssueScreen(fieldScreen);
        } else if (fieldScreen.getName().contains(this.i18n.getText(INCIDENT_EDIT_SCREEN_NAME_KEY))) {
            this.handleIncidentEditIssueScreen(fieldScreen);
        } else if (fieldScreen.getName().contains(this.i18n.getText(PROBLEM_CREATE_SCREEN_NAME_KEY))) {
            this.handleProblemCreateIssueScreen(fieldScreen);
        } else if (fieldScreen.getName().contains(this.i18n.getText(PROBLEM_EDIT_SCREEN_NAME_KEY))) {
            this.handleProblemEditIssueScreen(fieldScreen);
        } else if (fieldScreen.getName().contains(this.i18n.getText(REQUEST_EDIT_SCREEN_NAME_KEY))) {
            this.handleRequestEditIssueScreen(fieldScreen);
        }
    }

    @Override
    public List<String> getRequestTypeGroupOrder() {
        return Lists.newArrayList((Object[])new String[]{this.i18n.getText(COMMON_REQUESTS_GROUP_KEY), this.i18n.getText(LOGINS_GROUP_KEY), this.i18n.getText(COMPUTERS_GROUP_KEY), this.i18n.getText(APPLICATIONS_GROUP_KEY), this.i18n.getText(SERVERS_GROUP_KEY)});
    }

    private void handlePendingReasonScreen(FieldScreen fieldScreen) {
        io.atlassian.fugue.Option<CustomField> pendingOption = this.customFieldsManager.getOrCreatePendingReasonCustomField();
        if (pendingOption.isDefined()) {
            ProjectTemplateCustomFieldsManager.addCustomFieldToScreen(fieldScreen, (CustomField)pendingOption.get());
        }
    }

    private void addCustomFieldOptionsToFieldScreen(FieldScreen fieldScreen, List<io.atlassian.fugue.Option<CustomField>> customFieldOptions) {
        customFieldOptions.stream().filter(Maybe::isDefined).map(Maybe::get).forEach(customField -> ProjectTemplateCustomFieldsManager.addCustomFieldToScreen(fieldScreen, customField));
    }

    private void handleChangeCreateIssueScreen(FieldScreen fieldScreen) {
        ArrayList customFieldOptions = Lists.newArrayList((Object[])new io.atlassian.fugue.Option[]{this.customFieldsManager.getOrCreateChangeTypeCustomField(), this.customFieldsManager.getOrCreateChangeStartDateCustomField(), this.customFieldsManager.getOrCreateChangeCompletionDateCustomField(), this.customFieldsManager.getOrCreateImpactCustomField(), this.customFieldsManager.getOrCreateUrgencyCustomField(), this.customFieldsManager.getOrCreateChangeRiskCustomField(), this.customFieldsManager.getOrCreateChangeReasonCustomField(), this.customFieldsManager.getOrCreateChangeManagersCustomField(), this.customFieldsManager.getOrCreateCabCustomField()});
        this.addCustomFieldOptionsToFieldScreen(fieldScreen, customFieldOptions);
    }

    private void handleChangeEditIssueScreen(FieldScreen fieldScreen) {
        ArrayList customFieldOptions = Lists.newArrayList((Object[])new io.atlassian.fugue.Option[]{this.customFieldsManager.getOrCreateImpactCustomField(), this.customFieldsManager.getOrCreateUrgencyCustomField(), this.customFieldsManager.getOrCreateChangeTypeCustomField(), this.customFieldsManager.getOrCreateChangeReasonCustomField(), this.customFieldsManager.getOrCreateChangeRiskCustomField(), this.customFieldsManager.getOrCreateChangeStartDateCustomField(), this.customFieldsManager.getOrCreateChangeCompletionDateCustomField(), this.customFieldsManager.getOrCreateCabCustomField(), this.customFieldsManager.getOrCreatePendingReasonCustomField()});
        this.addCustomFieldOptionsToFieldScreen(fieldScreen, customFieldOptions);
    }

    private void handleIncidentCreateIssueScreen(FieldScreen fieldScreen) {
        ArrayList customFieldOptions = Lists.newArrayList((Object[])new io.atlassian.fugue.Option[]{this.customFieldsManager.getOrCreateImpactCustomField(), this.customFieldsManager.getOrCreateUrgencyCustomField(), this.customFieldsManager.getOrCreateProductCategorizationCustomField(), this.customFieldsManager.getOrCreateOperationalCategorizationCustomField(), this.customFieldsManager.getOrCreateSourceCustomField()});
        this.addCustomFieldOptionsToFieldScreen(fieldScreen, customFieldOptions);
    }

    private void handleIncidentEditIssueScreen(FieldScreen fieldScreen) {
        ArrayList customFieldOptions = Lists.newArrayList((Object[])new io.atlassian.fugue.Option[]{this.customFieldsManager.getOrCreateImpactCustomField(), this.customFieldsManager.getOrCreateUrgencyCustomField(), this.customFieldsManager.getOrCreateProductCategorizationCustomField(), this.customFieldsManager.getOrCreateOperationalCategorizationCustomField(), this.customFieldsManager.getOrCreatePendingReasonCustomField(), this.customFieldsManager.getOrCreateSourceCustomField()});
        this.addCustomFieldOptionsToFieldScreen(fieldScreen, customFieldOptions);
    }

    private void handleProblemCreateIssueScreen(FieldScreen fieldScreen) {
        ArrayList customFieldOptions = Lists.newArrayList((Object[])new io.atlassian.fugue.Option[]{this.customFieldsManager.getOrCreateImpactCustomField(), this.customFieldsManager.getOrCreateUrgencyCustomField(), this.customFieldsManager.getOrCreateSourceCustomField(), this.customFieldsManager.getOrCreateInvestigationReasonCustomField(), this.customFieldsManager.getOrCreateProductCategorizationCustomField(), this.customFieldsManager.getOrCreateOperationalCategorizationCustomField(), this.customFieldsManager.getOrCreatePendingReasonCustomField(), this.customFieldsManager.getOrCreateRootCauseCustomField(), this.customFieldsManager.getOrCreateWorkaroundCustomField()});
        this.addCustomFieldOptionsToFieldScreen(fieldScreen, customFieldOptions);
    }

    private void handleProblemEditIssueScreen(FieldScreen fieldScreen) {
        ArrayList customFieldOptions = Lists.newArrayList((Object[])new io.atlassian.fugue.Option[]{this.customFieldsManager.getOrCreateImpactCustomField(), this.customFieldsManager.getOrCreateUrgencyCustomField(), this.customFieldsManager.getOrCreateSourceCustomField(), this.customFieldsManager.getOrCreateInvestigationReasonCustomField(), this.customFieldsManager.getOrCreateProductCategorizationCustomField(), this.customFieldsManager.getOrCreateOperationalCategorizationCustomField(), this.customFieldsManager.getOrCreatePendingReasonCustomField(), this.customFieldsManager.getOrCreateRootCauseCustomField(), this.customFieldsManager.getOrCreateWorkaroundCustomField(), this.customFieldsManager.getOrCreatePendingReasonCustomField()});
        this.addCustomFieldOptionsToFieldScreen(fieldScreen, customFieldOptions);
    }

    private void handleRequestEditIssueScreen(FieldScreen fieldScreen) {
        ArrayList customFieldOptions = Lists.newArrayList((Object[])new io.atlassian.fugue.Option[]{this.customFieldsManager.getOrCreateImpactCustomField(), this.customFieldsManager.getOrCreateUrgencyCustomField(), this.customFieldsManager.getOrCreatePendingReasonCustomField(), this.customFieldsManager.getOrCreateProductCategorizationCustomField(), this.customFieldsManager.getOrCreateOperationalCategorizationCustomField()});
        this.addCustomFieldOptionsToFieldScreen(fieldScreen, customFieldOptions);
    }

    @Override
    public PremadeWorkflowPresets workflow(Project project, boolean allowUnassigned) {
        return new PremadeWorkflowPresets((List<PremadeWorkflowPresetsEntry>)this.getPremadeWorkflowPresetEntries(project), this.i18n.getText("sd.workflow.scheme.name.for.project", project.getKey()), this.i18n.getText("sd.workflow.scheme.desc.for.project", project.getKey()));
    }

    private ImmutableList<PremadeWorkflowPresetsEntry> getPremadeWorkflowPresetEntries(Project project) {
        ArrayList workflows = Lists.newArrayList((Object[])new PremadeWorkflowPresetsEntry[]{this.getServiceRequestPremadeWorkflow(project), this.getServiceRequestWithApprovalsPremadeWorkflow(project), this.getChangePremadeWorkflow(project), this.getIncidentPremadeWorkflow(project), this.getProblemPremadeWorkflow(project), this.getTaskSubtaskPremadeWorkflow(project)});
        return ImmutableList.copyOf((Collection)workflows);
    }

    private PremadeWorkflowPresetsEntry getChangePremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk ITIL V2 Change Workflow.jwb", this.i18n.getText("sd.workflow.itil.v2.name.change", project.getKey()), this.i18n.getText("sd.workflow.itil.v2.desc.change", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.premade.project.servicedesk.issuetype.change.name")));
    }

    private PremadeWorkflowPresetsEntry getIncidentPremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk ITIL V2 Incident Workflow.jwb", this.i18n.getText("sd.workflow.itil.v2.name.incident", project.getKey()), this.i18n.getText("sd.workflow.itil.v2.desc.incident", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.project.template.itil.issuetype.incident.name")));
    }

    private PremadeWorkflowPresetsEntry getProblemPremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk ITIL V2 Problem Workflow.jwb", this.i18n.getText("sd.workflow.itil.v2.name.problem", project.getKey()), this.i18n.getText("sd.workflow.itil.v2.desc.problem", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.project.template.itil.issuetype.problem.name")));
    }

    private PremadeWorkflowPresetsEntry getServiceRequestPremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk Service Request Fulfilment Workflow.jwb", this.i18n.getText("sd.workflow.name.for.service.request", project.getKey()), this.i18n.getText("sd.workflow.desc.for.service.request", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.project.template.itil.issuetype.service.request.name")));
    }

    private PremadeWorkflowPresetsEntry getServiceRequestWithApprovalsPremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk Service Request Fulfilment With Approvals Workflow.jwb", this.i18n.getText("sd.workflow.name.for.service.request.with.approvals", project.getKey()), this.i18n.getText("sd.workflow.desc.for.service.request.with.approvals", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.premade.project.servicedesk.issuetype.service.request.approvals.name")));
    }

    private PremadeWorkflowPresetsEntry getTaskSubtaskPremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk ITIL V2 Task Subtask Workflow.jwb", this.i18n.getText("sd.workflow.itil.v2.name.task", project.getKey()), this.i18n.getText("sd.workflow.itil.v2.desc.task", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.premade.project.servicedesk.issuetype.task.name"), (Object)this.i18n.getText("sd.premade.project.servicedesk.issuetype.subtask.name")));
    }

    @Override
    public List<PremadeProjectQueueMetadata> queuesForEmptyProject(boolean allowUnassigned) {
        ArrayList itilQueues = Lists.newArrayList();
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.queues.all.open"), this.allOpenJQL(), 0, DefaultKeys.defaultItilV2Columns));
        if (allowUnassigned) {
            itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.unassigned.name"), this.unassignedIssueQueueJQL(), 1, DefaultKeys.unassignedColumns));
        }
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.assignedtome.name"), this.assignedToMeQueueJQL(), 2, DefaultKeys.defaultItilV2Columns));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.waitingonme.name"), this.waitingOnMeQueueJQL(), 3));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.incidents.name"), this.incidentQueueJQL(), 4, DefaultKeys.incidentsColumns));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.v2.queues.incidents.reported.60.mins.name"), this.incidentReportedLast60MinutesQueueJQL(), 5, DefaultKeys.incidentsColumns));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.v2.queues.incidents.critical.name"), this.incidentCriticalQueueJQL(), 6, DefaultKeys.incidentsColumns));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.servicerequests.name"), this.serviceRequestQueueJQL(), 7, DefaultKeys.serviceRequestsColumns));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.duesoon.name"), this.dueSoonQueueJQL(), 8, DefaultKeys.serviceRequestsColumns));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.change.name"), this.changeQueueJQL(), 9, DefaultKeys.changeColumns));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.v2.queues.change.ready.name"), this.changeReadyQueueJQL(), 10, DefaultKeys.changeReadyForImplColumns));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.v2.queues.change.emergency.name"), this.changeEmergencyReadyQueueJQL(), 11, DefaultKeys.emergencyChangeColumns));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.problem.name"), this.problemQueueJQL(), 12));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.v2.queues.problem.completed.30.days.name"), this.problemCompletedQueueJQL(), 13));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.recentlyresolved.name"), this.recentlyResolvedQueueJQL(), 14, DefaultKeys.defaultColumnsWithFeedback));
        return itilQueues;
    }

    @Override
    public List<PremadeProjectQueueMetadata> queuesForExistingProject() {
        return Collections.emptyList();
    }

    @Override
    public PremadeProjectStatusMapping statusMapping() {
        return new PremadeProjectStatusMapping((Map<String, String>)ImmutableMap.of());
    }

    @Override
    public Map<String, Object> defaultIssuesVelocityMap(boolean allowUnassigned, CheckedUser user, Project project, Portal portal, String translatedStatus, I18nHelper i18n, WebResourceUrlProvider webResourceUrlProvider, VpOriginCustomFieldService vpOriginCustomFieldService) {
        return this.defaultIssuesVelocityMap(allowUnassigned, user, project, translatedStatus, i18n, webResourceUrlProvider, vpOriginCustomFieldService);
    }

    private PremadeProjectQueueMetadata createChangeApprovedQueue(int order) {
        if (this.approvalGettingStartedHelper.canCreateQueue()) {
            return (PremadeProjectQueueMetadata)this.approvalGettingStartedHelper.changeApprovedQueue(9).get();
        }
        return this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.justapproved.name"), this.newlyApprovedQueueJQL(), 9);
    }

    private String allOpenJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String unassignedIssueQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsEmpty().and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String assignedToMeQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsCurrentUser().and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String waitingOnMeQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsCurrentUser().and().unresolved().and().status().in(new String[]{this.i18n.getText("sd.workflow.itsupport.v2.step.name.waiting.for.support"), this.i18n.getText("sd.workflow.in.progress"), this.i18n.getText("sd.workflow.escalated")}).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String incidentQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.incident.name")).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String incidentReportedLast60MinutesQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.incident.name")).and().created().gtEq("-60m").endWhere().orderBy().createdDate(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String incidentCriticalQueueJQL() {
        List priorities = this.priorityManager.getPriorities();
        String[] priorityNamesForJQL = priorities.size() > 1 ? new String[]{((Priority)priorities.get(0)).getName(), ((Priority)priorities.get(1)).getName()} : new String[]{((Priority)priorities.get(0)).getName()};
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.incident.name")).and().priority().in(priorityNamesForJQL).endWhere().orderBy().createdDate(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String serviceRequestQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.service.request.name")).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String dueSoonQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.service.request.name")).and().due().ltEq("24h").endWhere().orderBy().dueDate(SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String changeQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.change.name")).endWhere().buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String changeReadyQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.change.name")).and().status().eq(this.i18n.getText("sd.workflow.itil.change.status.waiting")).endWhere().orderBy().createdDate(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String changeEmergencyReadyQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.change.name")).endWhere().orderBy().createdDate(SortOrder.DESC).buildQuery();
        Query finalQuery = (Query)this.customFieldsManager.getOrCreateChangeTypeCustomField().fold(() -> jqlQuery, changeTypeField -> (Query)CascadingCustomFieldUtil.getOptionsForCustomField(changeTypeField).fold(() -> jqlQuery, options -> {
            List emergencyOption = options.stream().filter(option -> option.toString().equals(this.i18n.getText("sd.project.template.itil.v2.custom.field.change.type.value.emergency"))).collect(Collectors.toList());
            if (!emergencyOption.isEmpty()) {
                return JqlQueryBuilder.newBuilder((Query)jqlQuery).where().and().field(changeTypeField.getFieldName()).eq(((Option)emergencyOption.get(0)).getValue()).endWhere().buildQuery();
            }
            return jqlQuery;
        }));
        return this.searchService.getJqlString(finalQuery);
    }

    private String newlyApprovedQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.change.name")).and().status().eq(this.i18n.getText("sd.workflow.itil.change.status.approved")).endWhere().orderBy().priority(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String problemQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.problem.name")).endWhere().orderBy().priority(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String problemCompletedQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.problem.name")).and().status().eq(this.i18n.getText("sd.workflow.completed")).and().resolutionDate().gtEq("-30d").endWhere().buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String recentlyResolvedQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().resolutionDate().gtEq("-1w").endWhere().orderBy().resolutionDate(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    List<PremadeProjectComponentMetadata> components() {
        return ImmutableList.of((Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.active"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.analytics"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.billing"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.cloud"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.data"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.email"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.financial"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.hr"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.intranet"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.jira"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.office"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.payroll"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object[])new PremadeProjectComponentMetadata[]{new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.printers"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.public"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.vpn"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.v2.components.webstore"), this.i18n.getText("sd.project.template.itil.components.description"), 0L)});
    }

    List<PremadeIssueTypeMetadata> issueTypes() {
        return ImmutableList.of((Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.itil.issuetype.service.request.name"), this.i18n.getText("sd.project.template.itil.issuetype.service.request.description"), "/servicedesk/issue-type-icons?icon=service-request", this.defaultServiceRequestRequestTypes()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.premade.project.servicedesk.issuetype.service.request.approvals.name"), this.i18n.getText("sd.premade.project.servicedesk.issuetype.service.request.approvals.description"), "/servicedesk/issue-type-icons?icon=request-with-approvals", this.defaultServiceRequestWithApprovalsRequestTypes()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.itil.issuetype.incident.name"), this.i18n.getText("sd.project.template.itil.issuetype.incident.description"), "/servicedesk/issue-type-icons?icon=incident", this.defaultIncidentRequestTypes()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.itil.issuetype.change.name"), this.i18n.getText("sd.project.template.itil.issuetype.change.description"), "/servicedesk/issue-type-icons?icon=change", this.defaultChangeRequestTypes()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.itil.issuetype.problem.name"), this.i18n.getText("sd.project.template.itil.issuetype.problem.description"), "/servicedesk/issue-type-icons?icon=problem", new ArrayList<PremadeRequestTypeMetadata>()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.premade.project.servicedesk.issuetype.task.name"), this.i18n.getText("sd.premade.project.servicedesk.issuetype.task.description"), "/servicedesk/issue-type-icons?icon=task", new ArrayList<PremadeRequestTypeMetadata>()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.premade.project.servicedesk.issuetype.subtask.name"), this.i18n.getText("sd.premade.project.servicedesk.issuetype.subtask.description"), "/servicedesk/issue-type-icons?icon=subtask", new ArrayList<PremadeRequestTypeMetadata>()));
    }

    private List<PremadeRequestTypeMetadata> defaultIncidentRequestTypes() {
        ArrayList fields = Lists.newArrayList((Object[])new DefaultFieldConfig[]{this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summarise.problem"), "", true), this.requestTypeField("description", "", "", false), this.requestTypeField("attachment", "", "", false), this.requestTypeField("components", this.i18n.getText("sd.project.template.itil.field.display.name.select.system"), "", false), this.requestTypeField("priority", this.i18n.getText("sd.project.template.itil.field.display.name.how.urgent"), "", false)});
        io.atlassian.fugue.Option<DefaultFieldConfig> impactOption = this.getImpactField();
        if (impactOption.isDefined()) {
            fields.add(impactOption.get());
        }
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.system.problem.key"), this.i18n.getText("sd.project.template.itil.requesttype.system.problem.name"), this.i18n.getText("sd.project.template.itil.requesttype.system.problem.desc"), "", RequestTypeSystemIcon.ICON_WARNING, this.statusMapping(), fields, (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY), (Object)this.i18n.getText(APPLICATIONS_GROUP_KEY), (Object)this.i18n.getText(SERVERS_GROUP_KEY))));
    }

    private DefaultFieldConfig requestTypeField(String fieldId, String label, String help, boolean required2) {
        return new FieldConfigBuilder().setFieldId(fieldId).setLabel(label).setHelp(help).setRequired(required2).setDisplayed(true).setValues((Map<String, List<String>>)ImmutableMap.of()).build();
    }

    private List<PremadeRequestTypeMetadata> defaultServiceRequestRequestTypes() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.getithelp.key"), this.i18n.getText("sd.project.template.itil.requesttype.getithelp.name"), this.i18n.getText("sd.project.template.itil.requesttype.getithelp.desc"), "", RequestTypeSystemIcon.ICON_QUESTION, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), "", false), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.itil.field.display.name.attachment"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY), (Object)this.i18n.getText(COMPUTERS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.accountproblem.key"), this.i18n.getText("sd.project.template.itil.requesttype.accountproblem.name"), this.i18n.getText("sd.project.template.itil.requesttype.accountproblem.desc"), "", RequestTypeSystemIcon.ICON_CODE, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), "", false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.guestwifi.key"), this.i18n.getText("sd.project.template.itil.requesttype.guestwifi.name"), this.i18n.getText("sd.project.template.itil.requesttype.guestwifi.desc"), "", RequestTypeSystemIcon.ICON_SIGNAL_TOWER, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), "", false), (Object)this.requestTypeField("duedate", this.i18n.getText("sd.project.template.itil.field.display.name.guest.arrival.date"), "", false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.vpn.key"), this.i18n.getText("sd.project.template.itil.requesttype.vpn.name"), this.i18n.getText("sd.project.template.itil.requesttype.vpn.desc"), "", RequestTypeSystemIcon.ICON_PADLOCK, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), "", false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY), (Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.adminaccess.key"), this.i18n.getText("sd.project.template.itil.requesttype.adminaccess.name"), this.i18n.getText("sd.project.template.itil.requesttype.adminaccess.desc"), "", RequestTypeSystemIcon.ICON_GEARS, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), this.i18n.getText("sd.project.template.itil.field.display.help.why.permission"), false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.newaccount.key"), this.i18n.getText("sd.project.template.itil.requesttype.newaccount.name"), this.i18n.getText("sd.project.template.itil.requesttype.newaccount.desc"), "", RequestTypeSystemIcon.ICON_PLUS, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), this.i18n.getText("sd.project.template.itil.field.display.help.create.account"), true), (Object)this.requestTypeField("components", this.i18n.getText("sd.project.template.itil.v2.requesttype.request.new.account.field.components"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.v2.requesttype.request.new.account.field.description"), "", false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY), (Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.newhires.key"), this.i18n.getText("sd.project.template.itil.v2.requesttype.onboard.new.employees.name"), this.i18n.getText("sd.project.template.itil.requesttype.newhires.desc"), "", RequestTypeSystemIcon.ICON_TWO_PEOPLE, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", "", this.i18n.getText("sd.project.template.itil.v2.requesttype.onboard.new.employees.field.summary.help"), true), (Object)this.requestTypeField("duedate", this.i18n.getText("sd.project.template.itil.v2.requesttype.onboard.new.employees.field.duedate"), this.i18n.getText("sd.project.template.itil.v2.requesttype.onboard.new.employees.field.duedate.help"), false), (Object)this.requestTypeField("description", "", "", false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.compsupport.key"), this.i18n.getText("sd.project.template.itil.requesttype.compsupport.name"), this.i18n.getText("sd.project.template.itil.requesttype.compsupport.desc"), "", RequestTypeSystemIcon.ICON_ROBOT, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", "", this.i18n.getText("sd.project.template.itil.field.display.help.laptop.example"), true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.details"), this.i18n.getText("sd.project.template.itil.v2.requesttype.deskptop.laptop.support.description.help"), true), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY), (Object)this.i18n.getText(COMPUTERS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.phoneredirect.key"), this.i18n.getText("sd.project.template.itil.requesttype.phoneredirect.name"), this.i18n.getText("sd.project.template.itil.requesttype.phoneredirect.desc"), "", RequestTypeSystemIcon.ICON_WORKFLOW, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", "", "", true), (Object)this.requestTypeField("description", "", this.i18n.getText("sd.project.template.itil.v2.requesttype.setup.phone.line.redirect.field.description.help"), false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(SERVERS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.newsoftware.key"), this.i18n.getText("sd.project.template.itil.requesttype.newsoftware.name"), this.i18n.getText("sd.project.template.itil.requesttype.newsoftware.desc"), "", RequestTypeSystemIcon.ICON_CD, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summarise.request"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.why"), "", true), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.itil.field.display.name.attachment"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMPUTERS_GROUP_KEY), (Object)this.i18n.getText(APPLICATIONS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.newhardware.key"), this.i18n.getText("sd.project.template.itil.requesttype.newhardware.name"), this.i18n.getText("sd.project.template.itil.requesttype.newhardware.desc"), "", RequestTypeSystemIcon.ICON_KEYBOARD, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.why"), "", true), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.itil.field.display.name.attachment"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMPUTERS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(REQUEST_DESK_PHONE_RT_KEY, this.i18n.getText("sd.project.template.itil.v2.requesttype.request.desk.phone.name"), this.i18n.getText("sd.project.template.itil.v2.requesttype.request.desk.phone.desc"), "", RequestTypeSystemIcon.ICON_LOOP, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.v2.requesttype.request.desk.phone.field.summary"), this.i18n.getText("sd.project.template.itil.v2.requesttype.request.desk.phone.field.summary.help"), true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.v2.requesttype.request.desk.phone.field.description"), this.i18n.getText("sd.project.template.itil.v2.requesttype.request.desk.phone.field.description.help"), false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY))), (Object[])new PremadeRequestTypeMetadata[0]);
    }

    private List<PremadeRequestTypeMetadata> defaultServiceRequestWithApprovalsRequestTypes() {
        io.atlassian.fugue.Option<DefaultFieldConfig> approversOption = this.getApproversField();
        if (approversOption.isDefined()) {
            return ImmutableList.of((Object)new PremadeRequestTypeMetadata(NEW_MOBILE_DEVICE_RT_KEY, this.i18n.getText("sd.project.template.itil.v2.requesttype.new.mobile.device.name"), this.i18n.getText("sd.project.template.itil.v2.requesttype.new.mobile.device.desc"), "", RequestTypeSystemIcon.ICON_SMARTPHONE, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", "", this.i18n.getText("sd.project.template.itil.v2.requesttype.new.mobile.device.field.summary.help"), true), (Object)approversOption.get(), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.v2.requesttype.new.mobile.device.field.description"), this.i18n.getText("sd.project.template.itil.v2.requesttype.new.mobile.device.field.description.help"), false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMPUTERS_GROUP_KEY))));
        }
        return ImmutableList.of();
    }

    private List<PremadeRequestTypeMetadata> defaultChangeRequestTypes() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.upgradeserver.key"), this.i18n.getText("sd.project.template.itil.requesttype.upgradeserver.name"), this.i18n.getText("sd.project.template.itil.requesttype.upgradeserver.desc"), "", RequestTypeSystemIcon.ICON_DATABASE, this.statusMapping(), (List<DefaultFieldConfig>)this.getFieldsForUpgradeServerRT(), (List<String>)ImmutableList.of((Object)this.i18n.getText(SERVERS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.upgradesystem.key"), this.i18n.getText("sd.project.template.itil.requesttype.upgradesystem.name"), this.i18n.getText("sd.project.template.itil.requesttype.upgradesystem.desc"), "", RequestTypeSystemIcon.ICON_POWER_BUTTON, this.statusMapping(), (List<DefaultFieldConfig>)this.getFieldsForUpgradeSystemRT(), (List<String>)ImmutableList.of((Object)this.i18n.getText(APPLICATIONS_GROUP_KEY))));
    }

    private ImmutableList<DefaultFieldConfig> getFieldsForUpgradeServerRT() {
        ArrayList fields = Lists.newArrayList((Object[])new DefaultFieldConfig[]{this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.which.server.why"), "", true), this.requestTypeField("components", "", "", false)});
        ArrayList customFieldOptions = Lists.newArrayList((Object[])new io.atlassian.fugue.Option[]{this.customFieldsManager.getOrCreateChangeTypeCustomField(), this.customFieldsManager.getOrCreateChangeRiskCustomField(), this.customFieldsManager.getOrCreateChangeReasonCustomField(), this.customFieldsManager.getOrCreateChangeStartDateCustomField(), this.customFieldsManager.getOrCreateChangeCompletionDateCustomField()});
        customFieldOptions.stream().filter(Maybe::isDefined).map(Maybe::get).forEach(customField -> fields.add(this.requestTypeField(customField.getId(), "", "", false)));
        fields.add(this.requestTypeField("attachment", "", "", false));
        return ImmutableList.copyOf((Collection)fields);
    }

    private ImmutableList<DefaultFieldConfig> getFieldsForUpgradeSystemRT() {
        ArrayList fields = Lists.newArrayList((Object[])new DefaultFieldConfig[]{this.requestTypeField("summary", "", this.i18n.getText("sd.project.template.itil.field.display.help.upgrade"), true), this.requestTypeField("description", "", this.i18n.getText("sd.project.template.itil.v2.requesttype.upgrade.change.managed.system.field.description.help"), true), this.requestTypeField("components", this.i18n.getText("sd.project.template.itil.v2.requesttype.upgrade.change.managed.system.field.components"), "", true)});
        ArrayList customFieldOptions = Lists.newArrayList((Object[])new io.atlassian.fugue.Option[]{this.customFieldsManager.getOrCreateChangeTypeCustomField(), this.customFieldsManager.getOrCreateChangeRiskCustomField(), this.customFieldsManager.getOrCreateChangeReasonCustomField(), this.customFieldsManager.getOrCreateChangeStartDateCustomField(), this.customFieldsManager.getOrCreateChangeCompletionDateCustomField()});
        customFieldOptions.stream().filter(Maybe::isDefined).map(Maybe::get).forEach(customField -> fields.add(this.requestTypeField(customField.getId(), "", "", false)));
        fields.add(this.requestTypeField("attachment", "", "", false));
        return ImmutableList.copyOf((Collection)fields);
    }

    private io.atlassian.fugue.Option<DefaultFieldConfig> getApproversField() {
        return this.approversCustomFieldManager.getOrCreateApproversCustomField().map(approversField -> new FieldConfigBuilder().setFieldId(approversField.getId()).setLabel(this.i18n.getText("sd.project.template.itil.requesttype.field.approvers")).setHelp("").setRequired(true).setDisplayed(true).setValues((Map<String, List<String>>)ImmutableMap.of()).build());
    }

    private io.atlassian.fugue.Option<DefaultFieldConfig> getImpactField() {
        return this.customFieldsManager.getOrCreateImpactCustomField().map(impactField -> new FieldConfigBuilder().setFieldId(impactField.getId()).setLabel(this.i18n.getText("sd.project.template.itil.v2.requesttype.report.system.problem.field.impact")).setHelp(this.i18n.getText("sd.project.template.itil.v2.requesttype.report.system.problem.field.impact.help")).setRequired(false).setDisplayed(true).setValues((Map<String, List<String>>)ImmutableMap.of()).build());
    }

    private PremadeProjectQueueMetadata createPremadeProjectQueueMetadata(String name, String jql, int order) {
        return new PremadeProjectQueueMetadata(name, jql, order);
    }

    private PremadeProjectQueueMetadata createPremadeProjectQueueMetadata(String name, String jql, int order, List<String> columns) {
        return new PremadeProjectQueueMetadata(name, jql, order, columns);
    }

    @VisibleForTesting
    Map<String, Object> defaultIssuesVelocityMap(boolean allowUnassigned, CheckedUser user, Project project, String translatedStatus, I18nHelper i18n, WebResourceUrlProvider webResourceUrlProvider, VpOriginCustomFieldService vpOriginCustomFieldService) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("issueTypeAsHtml", i18n.getText("sd.project.template.itil.issuetype.service.request.name"));
        map.put("statusAsHtml", translatedStatus);
        map.put("summaryAsHtml", i18n.getText("sd.project.template.default.itil.issue.summary"));
        map.put("descriptionAsHtml", i18n.getText("sd.project.template.default.itil.issue.description"));
        map.put("projectKey", project.getKey());
        map.put("projectName", project.getName());
        map.put("priority", ((Priority)this.priorityManager.getPriorities().get(0)).getId());
        map.put("assignee", allowUnassigned ? null : user.getName());
        map.put("reporter", project.getLeadUserName());
        map.put("requestTypeFieldname", vpOriginCustomFieldService.getVpOriginCustomField().getFieldName());
        map.put("requestTypeValue", project.getKey().toLowerCase() + "/" + i18n.getText("sd.project.template.itil.requesttype.getithelp.key"));
        return Collections.unmodifiableMap(map);
    }
}

