/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.gettingstarted;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.requesttype.icons.RequestTypeSystemIcon;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalGettingStartedHelper;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApproversCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.gettingstarted.DefaultFieldConfig;
import com.atlassian.servicedesk.internal.feature.gettingstarted.FieldConfigBuilder;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.DefaultKeys;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeIssueTypeMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectComponentMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectQueueMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectStatusMapping;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeRequestTypeMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeWorkflowPresets;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeWorkflowPresetsEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ITILServiceDeskProjectMetadata
implements PremadeProjectMetadata {
    private static final String COMMON_REQUESTS_GROUP_KEY = "sd.project.template.itil.request.type.groups.common";
    private static final String LOGINS_GROUP_KEY = "sd.project.template.itil.request.type.groups.logins";
    private static final String COMPUTERS_GROUP_KEY = "sd.project.template.itil.request.type.groups.computers";
    private static final String APPLICATIONS_GROUP_KEY = "sd.project.template.itil.request.type.groups.applications";
    private static final String SERVERS_GROUP_KEY = "sd.project.template.itil.request.type.groups.servers";
    private final I18nHelper i18n;
    private final SearchService searchService;
    private final PriorityManager priorityManager;
    private final ApproversCustomFieldManager approversCustomFieldManager;
    private final ApprovalGettingStartedHelper approvalGettingStartedHelper;

    public ITILServiceDeskProjectMetadata(I18nHelper i18n, SearchService searchService, PriorityManager priorityManager, ApproversCustomFieldManager approversCustomFieldManager, ApprovalGettingStartedHelper approvalGettingStartedHelper) {
        this.i18n = i18n;
        this.searchService = searchService;
        this.priorityManager = priorityManager;
        this.approversCustomFieldManager = approversCustomFieldManager;
        this.approvalGettingStartedHelper = approvalGettingStartedHelper;
    }

    @Override
    public List<PremadeProjectComponentMetadata> components(Project project) {
        return this.components();
    }

    @Override
    public List<PremadeIssueTypeMetadata> issueTypes(Project project) {
        return this.issueTypes();
    }

    @Override
    public void addCustomFieldsToScreen(FieldScreen fieldScreen) {
    }

    @Override
    public List<String> getRequestTypeGroupOrder() {
        return new ArrayList<String>();
    }

    @Override
    public PremadeWorkflowPresets workflow(Project project, boolean allowUnassigned) {
        return new PremadeWorkflowPresets((List<PremadeWorkflowPresetsEntry>)this.getPremadeWorkflowPresetEntries(project, allowUnassigned), this.i18n.getText("sd.workflow.scheme.name.for.project", project.getKey()), this.i18n.getText("sd.workflow.scheme.desc.for.project", project.getKey()));
    }

    private ImmutableList<PremadeWorkflowPresetsEntry> getPremadeWorkflowPresetEntries(Project project, boolean allowUnassigned) {
        ArrayList<PremadeWorkflowPresetsEntry> workflows = new ArrayList<PremadeWorkflowPresetsEntry>();
        workflows.add(this.getItSupportPremadeWorkflow(project, allowUnassigned));
        workflows.add(this.getItilProblemPremadeWorkflow(project));
        workflows.add(this.getItilChangePremadeWorkflow(project));
        return ImmutableList.copyOf(workflows);
    }

    private PremadeWorkflowPresetsEntry getItSupportPremadeWorkflow(Project project, boolean allowUnassigned) {
        return new PremadeWorkflowPresetsEntry(allowUnassigned ? "/project-templates/Service Desk IT Support Workflow (Unassigned allowed).jwb" : "/project-templates/Service Desk IT Support Workflow.jwb", this.i18n.getText("sd.workflow.name.for.project", project.getKey()), this.i18n.getText("sd.workflow.desc.for.project", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.project.template.itil.issuetype.incident.name"), (Object)this.i18n.getText("sd.project.template.itil.issuetype.service.request.name")));
    }

    private PremadeWorkflowPresetsEntry getItilProblemPremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk ITIL Problem Workflow.jwb", this.i18n.getText("sd.workflow.name.for.problem.management", project.getKey()), this.i18n.getText("sd.workflow.desc.for.problem.management", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.project.template.itil.issuetype.problem.name")));
    }

    private PremadeWorkflowPresetsEntry getItilChangePremadeWorkflow(Project project) {
        String workflowLocation = "/project-templates/Service Desk ITIL Change with Approval Workflow.jwb";
        return new PremadeWorkflowPresetsEntry(workflowLocation, this.i18n.getText("sd.workflow.name.for.change.management", project.getKey()), this.i18n.getText("sd.workflow.desc.for.change.management", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.project.template.itil.issuetype.change.name")));
    }

    @Override
    public List<PremadeProjectQueueMetadata> queuesForEmptyProject(boolean allowUnassigned) {
        ArrayList itilQueues = Lists.newArrayList();
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.queues.all.open"), this.allOpenJQL(), 0));
        if (allowUnassigned) {
            itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.unassigned.name"), this.unassignedIssueQueueJQL(), 1));
        }
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.assignedtome.name"), this.assignedToMeQueueJQL(), 2));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.waitingonme.name"), this.waitingOnMeQueueJQL(), 3));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.incidents.name"), this.incidentQueueJQL(), 4));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.urgent.name"), this.urgentQueueJQL(), 5));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.servicerequests.name"), this.serviceRequestQueueJQL(), 6));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.duesoon.name"), this.dueSoonQueueJQL(), 7));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.change.name"), this.changeQueueJQL(), 8));
        itilQueues.add(this.createChangeApprovedQueue(9));
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.problem.name"), this.problemQueueJQL(), 10));
        List<String> columns = DefaultKeys.defaultColumnsWithFeedback;
        itilQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.recentlyresolved.name"), this.recentlyResolvedQueueJQL(), 11, columns));
        return itilQueues;
    }

    @Override
    public List<PremadeProjectQueueMetadata> queuesForExistingProject() {
        return Collections.emptyList();
    }

    @Override
    public PremadeProjectStatusMapping statusMapping() {
        return new PremadeProjectStatusMapping((Map<String, String>)ImmutableMap.of());
    }

    @Override
    public Map<String, Object> defaultIssuesVelocityMap(boolean allowUnassigned, CheckedUser user, Project project, Portal portal, String translatedStatus, I18nHelper i18n, WebResourceUrlProvider webResourceUrlProvider, VpOriginCustomFieldService vpOriginCustomFieldService) {
        return this.defaultIssuesVelocityMap(allowUnassigned, user, project, translatedStatus, i18n, webResourceUrlProvider, vpOriginCustomFieldService);
    }

    private PremadeProjectQueueMetadata createChangeApprovedQueue(int order) {
        if (this.approvalGettingStartedHelper.canCreateQueue()) {
            return (PremadeProjectQueueMetadata)this.approvalGettingStartedHelper.changeApprovedQueue(9).get();
        }
        return this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.justapproved.name"), this.newlyApprovedQueueJQL(), 9);
    }

    private String allOpenJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String unassignedIssueQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsEmpty().and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String assignedToMeQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsCurrentUser().and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String waitingOnMeQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsCurrentUser().and().unresolved().and().status().eq(this.i18n.getText("sd.workflow.itsupport.v2.step.name.waiting.for.support")).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String incidentQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.incident.name")).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String urgentQueueJQL() {
        List priorities = this.priorityManager.getPriorities();
        String[] priorityNamesForJQL = priorities.size() > 1 ? new String[]{((Priority)priorities.get(0)).getName(), ((Priority)priorities.get(1)).getName()} : new String[]{((Priority)priorities.get(0)).getName()};
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.incident.name")).and().priority().in(priorityNamesForJQL).endWhere().buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String serviceRequestQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.service.request.name")).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String dueSoonQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.service.request.name")).and().due().ltEq("24h").endWhere().orderBy().dueDate(SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String changeQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.change.name")).endWhere().buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String newlyApprovedQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.change.name")).and().status().eq(this.i18n.getText("sd.workflow.itil.change.status.approved")).endWhere().orderBy().priority(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String problemQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.itil.issuetype.problem.name")).endWhere().orderBy().priority(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String recentlyResolvedQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().resolutionDate().gtEq("-1w").endWhere().orderBy().resolutionDate(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    List<PremadeProjectComponentMetadata> components() {
        return ImmutableList.of((Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.components.active.directory.name"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.components.intranet.name"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.components.jira.name"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.components.office.network.name"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.components.printers.name"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.components.public.website.name"), this.i18n.getText("sd.project.template.itil.components.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.itil.components.vpn.server.name"), this.i18n.getText("sd.project.template.itil.components.description"), 0L));
    }

    List<PremadeIssueTypeMetadata> issueTypes() {
        return ImmutableList.of((Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.itil.issuetype.incident.name"), this.i18n.getText("sd.project.template.itil.issuetype.incident.description"), "/servicedesk/issue-type-icons?icon=incident", this.defaultIncidentRequestTypes()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.itil.issuetype.service.request.name"), this.i18n.getText("sd.project.template.itil.issuetype.service.request.description"), "/servicedesk/issue-type-icons?icon=service-request", this.defaultServiceRequestRequestTypes()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.itil.issuetype.change.name"), this.i18n.getText("sd.project.template.itil.issuetype.change.description"), "/servicedesk/issue-type-icons?icon=change", this.defaultChangeRequestTypes()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.itil.issuetype.problem.name"), this.i18n.getText("sd.project.template.itil.issuetype.problem.description"), "/servicedesk/issue-type-icons?icon=problem", new ArrayList<PremadeRequestTypeMetadata>()));
    }

    private List<PremadeRequestTypeMetadata> defaultIncidentRequestTypes() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.system.problem.key"), this.i18n.getText("sd.project.template.itil.requesttype.system.problem.name"), this.i18n.getText("sd.project.template.itil.requesttype.system.problem.desc"), "", RequestTypeSystemIcon.ICON_WARNING, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summarise.problem"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), "", false), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.itil.field.display.name.attachment"), "", false), (Object)this.requestTypeField("components", this.i18n.getText("sd.project.template.itil.field.display.name.select.system"), "", false), (Object)this.requestTypeField("priority", this.i18n.getText("sd.project.template.itil.field.display.name.how.urgent"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY), (Object)this.i18n.getText(APPLICATIONS_GROUP_KEY), (Object)this.i18n.getText(SERVERS_GROUP_KEY))));
    }

    private DefaultFieldConfig requestTypeField(String fieldId, String label, String help, boolean required2) {
        return new FieldConfigBuilder().setFieldId(fieldId).setLabel(label).setHelp(help).setRequired(required2).setDisplayed(true).setValues((Map<String, List<String>>)ImmutableMap.of()).build();
    }

    private List<PremadeRequestTypeMetadata> defaultServiceRequestRequestTypes() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.getithelp.key"), this.i18n.getText("sd.project.template.itil.requesttype.getithelp.name"), this.i18n.getText("sd.project.template.itil.requesttype.getithelp.desc"), "", RequestTypeSystemIcon.ICON_QUESTION, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), "", false), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.itil.field.display.name.attachment"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY), (Object)this.i18n.getText(COMPUTERS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.accountproblem.key"), this.i18n.getText("sd.project.template.itil.requesttype.accountproblem.name"), this.i18n.getText("sd.project.template.itil.requesttype.accountproblem.desc"), "", RequestTypeSystemIcon.ICON_CODE, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.guestwifi.key"), this.i18n.getText("sd.project.template.itil.requesttype.guestwifi.name"), this.i18n.getText("sd.project.template.itil.requesttype.guestwifi.desc"), "", RequestTypeSystemIcon.ICON_SIGNAL_TOWER, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), "", false), (Object)this.requestTypeField("duedate", this.i18n.getText("sd.project.template.itil.field.display.name.guest.arrival.date"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.vpn.key"), this.i18n.getText("sd.project.template.itil.requesttype.vpn.name"), this.i18n.getText("sd.project.template.itil.requesttype.vpn.desc"), "", RequestTypeSystemIcon.ICON_PADLOCK, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.adminaccess.key"), this.i18n.getText("sd.project.template.itil.requesttype.adminaccess.name"), this.i18n.getText("sd.project.template.itil.requesttype.adminaccess.desc"), "", RequestTypeSystemIcon.ICON_GEARS, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), this.i18n.getText("sd.project.template.itil.field.display.help.why.permission"), false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.newaccount.key"), this.i18n.getText("sd.project.template.itil.requesttype.newaccount.name"), this.i18n.getText("sd.project.template.itil.requesttype.newaccount.desc"), "", RequestTypeSystemIcon.ICON_ADD_PERSON, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), this.i18n.getText("sd.project.template.itil.field.display.help.create.account"), true)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY), (Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.newhires.key"), this.i18n.getText("sd.project.template.itil.requesttype.newhires.name"), this.i18n.getText("sd.project.template.itil.requesttype.newhires.desc"), "", RequestTypeSystemIcon.ICON_TWO_PEOPLE, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), this.i18n.getText("sd.project.template.itil.field.display.help.new.hire.summary"), true), (Object)this.requestTypeField("duedate", this.i18n.getText("sd.project.template.itil.field.display.name.start.date"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(LOGINS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.compsupport.key"), this.i18n.getText("sd.project.template.itil.requesttype.compsupport.name"), this.i18n.getText("sd.project.template.itil.requesttype.compsupport.desc"), "", RequestTypeSystemIcon.ICON_ROBOT, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), this.i18n.getText("sd.project.template.itil.field.display.help.laptop.example"), true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.details"), this.i18n.getText("sd.project.template.itil.field.display.help.laptop.details"), true)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMPUTERS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.phoneredirect.key"), this.i18n.getText("sd.project.template.itil.requesttype.phoneredirect.name"), this.i18n.getText("sd.project.template.itil.requesttype.phoneredirect.desc"), "", RequestTypeSystemIcon.ICON_WORKFLOW, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), this.i18n.getText("sd.project.template.itil.field.display.help.redirect.details"), true)), (List<String>)ImmutableList.of((Object)this.i18n.getText(SERVERS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.newsoftware.key"), this.i18n.getText("sd.project.template.itil.requesttype.newsoftware.name"), this.i18n.getText("sd.project.template.itil.requesttype.newsoftware.desc"), "", RequestTypeSystemIcon.ICON_CD, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summarise.request"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.why"), "", true), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.itil.field.display.name.attachment"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMPUTERS_GROUP_KEY), (Object)this.i18n.getText(APPLICATIONS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.newhardware.key"), this.i18n.getText("sd.project.template.itil.requesttype.newhardware.name"), this.i18n.getText("sd.project.template.itil.requesttype.newhardware.desc"), "", RequestTypeSystemIcon.ICON_SMARTPHONE, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.why"), "", true), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.itil.field.display.name.attachment"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMPUTERS_GROUP_KEY))));
    }

    private List<PremadeRequestTypeMetadata> defaultChangeRequestTypes() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.upgradeserver.key"), this.i18n.getText("sd.project.template.itil.requesttype.upgradeserver.name"), this.i18n.getText("sd.project.template.itil.requesttype.upgradeserver.desc"), "", RequestTypeSystemIcon.ICON_DATABASE, this.statusMapping(), (List<DefaultFieldConfig>)this.getFieldsForUpgradeServerRT(), (List<String>)ImmutableList.of((Object)this.i18n.getText(SERVERS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(this.i18n.getText("sd.project.template.itil.requesttype.upgradesystem.key"), this.i18n.getText("sd.project.template.itil.requesttype.upgradesystem.name"), this.i18n.getText("sd.project.template.itil.requesttype.upgradesystem.desc"), "", RequestTypeSystemIcon.ICON_POWER_BUTTON, this.statusMapping(), (List<DefaultFieldConfig>)this.getFieldsForUpgradeSystemRT(), (List<String>)ImmutableList.of((Object)this.i18n.getText(APPLICATIONS_GROUP_KEY))));
    }

    private ImmutableList<DefaultFieldConfig> getFieldsForUpgradeServerRT() {
        ArrayList<DefaultFieldConfig> fields = new ArrayList<DefaultFieldConfig>();
        fields.add(this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), "", true));
        fields.add(this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.which.server.why"), "", true));
        this.getApproversField().map(field -> fields.add((DefaultFieldConfig)field));
        return ImmutableList.copyOf(fields);
    }

    private ImmutableList<DefaultFieldConfig> getFieldsForUpgradeSystemRT() {
        ArrayList<DefaultFieldConfig> fields = new ArrayList<DefaultFieldConfig>();
        fields.add(this.requestTypeField("summary", this.i18n.getText("sd.project.template.itil.field.display.name.summary"), this.i18n.getText("sd.project.template.itil.field.display.help.upgrade"), true));
        fields.add(this.requestTypeField("description", this.i18n.getText("sd.project.template.itil.field.display.name.description"), this.i18n.getText("sd.project.template.itil.field.display.help.why.upgrade"), true));
        this.getApproversField().map(field -> fields.add((DefaultFieldConfig)field));
        return ImmutableList.copyOf(fields);
    }

    private Option<DefaultFieldConfig> getApproversField() {
        return this.approversCustomFieldManager.getOrCreateApproversCustomField().map(approversField -> new FieldConfigBuilder().setFieldId(approversField.getId()).setLabel(this.i18n.getText("sd.project.template.itil.requesttype.field.approvers")).setHelp("").setRequired(true).setDisplayed(true).setValues((Map<String, List<String>>)ImmutableMap.of()).build());
    }

    private PremadeProjectQueueMetadata createPremadeProjectQueueMetadata(String name, String jql, int order) {
        return new PremadeProjectQueueMetadata(name, jql, order);
    }

    private PremadeProjectQueueMetadata createPremadeProjectQueueMetadata(String name, String jql, int order, List<String> columns) {
        return new PremadeProjectQueueMetadata(name, jql, order, columns);
    }

    @VisibleForTesting
    Map<String, Object> defaultIssuesVelocityMap(boolean allowUnassigned, CheckedUser user, Project project, String translatedStatus, I18nHelper i18n, WebResourceUrlProvider webResourceUrlProvider, VpOriginCustomFieldService vpOriginCustomFieldService) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("issueTypeAsHtml", i18n.getText("sd.project.template.itil.issuetype.service.request.name"));
        map.put("statusAsHtml", translatedStatus);
        map.put("summaryAsHtml", i18n.getText("sd.project.template.default.itil.issue.summary"));
        map.put("descriptionAsHtml", i18n.getText("sd.project.template.default.itil.issue.description"));
        map.put("projectKey", project.getKey());
        map.put("projectName", project.getName());
        map.put("priority", ((Priority)this.priorityManager.getPriorities().get(0)).getId());
        map.put("assignee", allowUnassigned ? null : user.getName());
        map.put("reporter", project.getLeadUserName());
        map.put("requestTypeFieldname", vpOriginCustomFieldService.getVpOriginCustomField().getFieldName());
        map.put("requestTypeValue", project.getKey().toLowerCase() + "/" + i18n.getText("sd.project.template.itil.requesttype.getithelp.key"));
        return Collections.unmodifiableMap(map);
    }
}

