/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.feedback.report;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import java.util.HashSet;
import java.util.Set;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
public class FeedbackReportDataCallback
implements DataCallback {
    private Set<String> fields = new HashSet<String>();
    private String fieldId;
    private double count;
    private double total;

    public FeedbackReportDataCallback(CustomField feedbackCF) {
        this.fieldId = feedbackCF.getId();
        this.fields.add(this.fieldId);
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        if (fieldName.equals(this.fieldId)) {
            this.count += 1.0;
            this.total += (double)Integer.parseInt(data);
        }
    }

    public void documentComplete(Long issueId, String issueKey) {
    }

    public double getAverageRating() {
        if (this.count > 0.0) {
            return this.total / this.count;
        }
        return 0.0;
    }

    public double getCountRating() {
        return this.count;
    }
}

