/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.feedback;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackParameters;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackToken;
import com.atlassian.servicedesk.internal.api.feedback.ValidatedFeedback;
import com.atlassian.servicedesk.internal.api.feedback.ValidatedFeedbackToken;
import com.atlassian.servicedesk.internal.feature.feedback.FeedbackErrors;
import com.atlassian.servicedesk.internal.feature.feedback.FeedbackSerializer;
import com.atlassian.servicedesk.internal.feature.feedback.ValidatedFeedbackImpl;
import com.atlassian.servicedesk.internal.issueproperty.ServiceDeskIssuePropertyNames;
import io.atlassian.fugue.Either;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestFeedbackValidator {
    private final IssuePropertyService issuePropertyService;
    private final FeedbackErrors feedbackErrors;
    private static final int COMMENT_MAX_LENGTH = 1000;
    private static final int QUESTION_MAX_LENGTH = 255;

    @Autowired
    public RequestFeedbackValidator(IssuePropertyService issuePropertyService, FeedbackErrors feedbackErrors) {
        this.issuePropertyService = issuePropertyService;
        this.feedbackErrors = feedbackErrors;
    }

    public Either<AnError, ValidatedFeedbackToken> validateFeedbackToken(@Nonnull Issue issue, @Nonnull FeedbackToken feedbackToken) {
        Assertions.notNull((String)"Issue shouldn't be null", (Object)issue);
        Assertions.notNull((String)"Feedback token shouldn't be null", (Object)feedbackToken);
        ApplicationUser applicationUser = issue.getReporterUser();
        if (applicationUser == null) {
            return Either.left((Object)this.feedbackErrors.REPORTER_NOT_FOUND());
        }
        io.atlassian.fugue.Option<String> propertyValue = this.getPropertyDirectly(applicationUser, feedbackToken.getIssueID(), ServiceDeskIssuePropertyNames.SD_FEEDBACK_TOKEN_KEY());
        if (!propertyValue.isDefined()) {
            return Either.left((Object)this.feedbackErrors.TOKEN_NOT_FOUND());
        }
        Either<AnError, ValidatedFeedbackToken> tokenEither = FeedbackSerializer.unserializeValue((String)propertyValue.get(), ValidatedFeedbackToken.class, this.feedbackErrors.INVALID_SERVER_TOKEN());
        if (tokenEither.isLeft()) {
            return Either.left((Object)tokenEither.left().get());
        }
        ValidatedFeedbackToken token = (ValidatedFeedbackToken)tokenEither.right().get();
        Long issueId = token.getIssueID();
        String tokenValue = token.getToken();
        if (tokenValue.equals(feedbackToken.getToken()) && issueId.equals(feedbackToken.getIssueID())) {
            return Either.right((Object)token);
        }
        return Either.left((Object)this.feedbackErrors.INVALID_FEEDBACK_TOKEN());
    }

    public Either<AnError, ValidatedFeedback> validateFeedback(@Nonnull FeedbackParameters feedbackParameters) {
        Assertions.notNull((String)"Feedback shouldn't be null", (Object)feedbackParameters);
        if (feedbackParameters.getRating() < 1 || feedbackParameters.getRating() > feedbackParameters.getScale()) {
            return Either.left((Object)this.feedbackErrors.INVALID_RATING());
        }
        String comment = (String)feedbackParameters.getComment().getOrElse((Object)"");
        if (comment.length() > 1000) {
            return Either.left((Object)this.feedbackErrors.INVALID_COMMENT());
        }
        return Either.right((Object)new ValidatedFeedbackImpl(feedbackParameters));
    }

    public Either<AnError, String> validateFeedbackQuestion(@Nonnull String question) {
        if (StringUtils.isBlank((String)question)) {
            return Either.left((Object)this.feedbackErrors.INVALID_QUESTION_BLANK());
        }
        if (question.trim().length() > 255) {
            return Either.left((Object)this.feedbackErrors.INVALID_QUESTION_LENGTH());
        }
        return Either.right((Object)question.trim());
    }

    private io.atlassian.fugue.Option<String> getPropertyDirectly(ApplicationUser user, long issueId, String propertyName) {
        return StepsConverters.newerOption((Option)this.issuePropertyService.getProperty(user, Long.valueOf(issueId), propertyName).getEntityProperty()).map(EntityProperty::getValue);
    }
}

