/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.feedback;

import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.internal.api.feedback.RequestFeedbackTokenManager;
import com.atlassian.servicedesk.internal.api.feedback.ValidatedFeedbackToken;
import com.atlassian.servicedesk.internal.feature.feedback.FeedbackErrors;
import com.atlassian.servicedesk.internal.feature.feedback.FeedbackSerializer;
import com.atlassian.servicedesk.internal.issueproperty.ServiceDeskIssuePropertyNames;
import io.atlassian.fugue.Either;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RequestFeedbackTokenManagerImpl
implements RequestFeedbackTokenManager {
    private final IssuePropertyService issuePropertyService;
    private final FeedbackErrors feedbackErrors;
    private final CustomerContextService customerContextService;
    private final EntityPropertyOptions entityPropertyOptions;

    @Autowired
    public RequestFeedbackTokenManagerImpl(IssuePropertyService issuePropertyService, FeedbackErrors feedbackErrors, CustomerContextService customerContextService) {
        this.issuePropertyService = issuePropertyService;
        this.feedbackErrors = feedbackErrors;
        this.customerContextService = customerContextService;
        this.entityPropertyOptions = new EntityPropertyOptions.Builder().skipPermissionChecks().build();
    }

    public Either<AnError, ValidatedFeedbackToken> generateFeedbackToken(@Nonnull Issue issue) {
        ValidatedFeedbackToken validatedFeedbackToken = new ValidatedFeedbackToken(this.generateToken(), issue.getId());
        return Either.right((Object)validatedFeedbackToken);
    }

    public Either<AnError, ValidatedFeedbackToken> storeFeedbackToken(@Nonnull ApplicationUser applicationUser, @Nonnull ValidatedFeedbackToken validatedFeedbackToken) {
        Either<AnError, String> jSonToken = FeedbackSerializer.serialize(validatedFeedbackToken, this.feedbackErrors.INVALID_FEEDBACK_TOKEN());
        if (jSonToken.isLeft()) {
            return Either.left((Object)jSonToken.left().get());
        }
        EntityPropertyService.PropertyInput propertyInput = new EntityPropertyService.PropertyInput((String)jSonToken.right().get(), ServiceDeskIssuePropertyNames.SD_FEEDBACK_TOKEN_KEY());
        EntityPropertyService.SetPropertyValidationResult validateResult = this.issuePropertyService.validateSetProperty(null, validatedFeedbackToken.getIssueID(), propertyInput, this.entityPropertyOptions);
        if (!validateResult.isValid()) {
            return Either.left((Object)this.feedbackErrors.FEEDBACK_PROPERTY_SET_ERROR(HttpStatusCode.INTERNAL_SERVER_ERROR));
        }
        EntityPropertyService.PropertyResult propertyResult = this.setPropertyInCustomerContext(applicationUser, validateResult);
        if (propertyResult.getErrorCollection().hasAnyErrors()) {
            int httpStatusCode = ErrorCollection.Reason.getWorstReason((Collection)propertyResult.getErrorCollection().getReasons()).getHttpStatusCode();
            return Either.left((Object)this.feedbackErrors.FEEDBACK_PROPERTY_SET_ERROR(httpStatusCode));
        }
        return Either.right((Object)validatedFeedbackToken);
    }

    private EntityPropertyService.PropertyResult setPropertyInCustomerContext(ApplicationUser user, EntityPropertyService.SetPropertyValidationResult validateResult) {
        return (EntityPropertyService.PropertyResult)this.customerContextService.runInCustomerContext(() -> this.issuePropertyService.setProperty(user, validateResult));
    }

    private String generateToken() {
        return DefaultSecureTokenGenerator.getInstance().generateToken();
    }
}

