/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.feedback;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.UpdateIssueRequest;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFManager;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFValue;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackDateCFManager;
import com.atlassian.servicedesk.internal.api.feedback.Feedback;
import com.atlassian.servicedesk.internal.api.feedback.ValidatedFeedback;
import com.atlassian.servicedesk.internal.feature.feedback.FeedbackErrors;
import com.atlassian.servicedesk.internal.feature.feedback.FeedbackImpl;
import com.atlassian.servicedesk.internal.feature.feedback.RequestFeedbackInternalManager;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueManager;
import com.atlassian.servicedesk.internal.util.IssueIndexingHelper;
import com.atlassian.servicedesk.internal.util.JsonSerializer;
import io.atlassian.fugue.Either;
import java.sql.Timestamp;
import java.util.Date;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.joda.time.DateTimeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestFeedbackInternalManagerImpl
implements RequestFeedbackInternalManager {
    private static final String COMMENT_PROPERTY_KEY = "service-request-feedback-comment";
    private static final EntityPropertyOptions ENTITY_PROPERTY_OPTIONS = new EntityPropertyOptions.Builder().skipPermissionChecks().build();
    private final IssuePropertyService issuePropertyService;
    private final RequestFeedbackCFManager requestFeedbackCFManager;
    private final RequestFeedbackDateCFManager requestFeedbackDateCFManager;
    private final ServiceDeskIssueManager issueManager;
    private final IssueIndexManager issueIndexManager;
    private final FeedbackErrors feedbackErrors;
    private final JsonSerializer<CommentProperty> commentSerializer = new JsonSerializer<CommentProperty>(CommentProperty.class);

    @Autowired
    public RequestFeedbackInternalManagerImpl(IssuePropertyService issuePropertyService, RequestFeedbackCFManager requestFeedbackCFManager, RequestFeedbackDateCFManager requestFeedbackDateCFManager, ServiceDeskIssueManager issueManager, IssueIndexManager issueIndexManager, FeedbackErrors feedbackErrors) {
        this.issuePropertyService = issuePropertyService;
        this.requestFeedbackCFManager = requestFeedbackCFManager;
        this.requestFeedbackDateCFManager = requestFeedbackDateCFManager;
        this.issueManager = issueManager;
        this.issueIndexManager = issueIndexManager;
        this.feedbackErrors = feedbackErrors;
    }

    @Override
    public Either<AnError, ValidatedFeedback> storeFeedback(@Nonnull Issue issue, @Nonnull ValidatedFeedback feedback) {
        io.atlassian.fugue.Option<AnError> commentError;
        ApplicationUser reporter = issue.getReporterUser();
        io.atlassian.fugue.Option<AnError> ratingError = this.storeRating(issue, reporter, feedback.getRating());
        if (ratingError.isDefined()) {
            return Either.left((Object)ratingError.get());
        }
        String comment = (String)feedback.getComment().getOrElse((Object)"");
        if (StringUtils.isNotBlank((String)comment) && (commentError = this.storeComment(issue, reporter, comment)).isDefined()) {
            return Either.left((Object)commentError.get());
        }
        return Either.right((Object)feedback);
    }

    private io.atlassian.fugue.Option<AnError> storeRating(@Nonnull Issue issue, @Nonnull ApplicationUser reporter, int rating) {
        MutableIssue mutableIssue = (MutableIssue)issue;
        io.atlassian.fugue.Option requestFeedbackCF = this.requestFeedbackCFManager.getOrCreateRequestFeedbackCF();
        io.atlassian.fugue.Option requestFeedbackDateCF = this.requestFeedbackDateCFManager.getOrCreateRequestFeedbackDateCF();
        if (requestFeedbackCF.isEmpty() || requestFeedbackDateCF.isEmpty()) {
            return io.atlassian.fugue.Option.some((Object)this.feedbackErrors.FEEDBACK_CUSTOM_FIELD_NOT_FOUND());
        }
        mutableIssue.setCustomFieldValue((CustomField)requestFeedbackCF.get(), (Object)new RequestFeedbackCFValue(Integer.valueOf(rating)));
        mutableIssue.setCustomFieldValue((CustomField)requestFeedbackDateCF.get(), (Object)new Timestamp(DateTimeUtils.currentTimeMillis()));
        Either<AnError, Issue> updatedIssue = this.issueManager.updateIssue(reporter, mutableIssue, UpdateIssueRequest.builder().sendMail(false).build());
        if (updatedIssue.isLeft()) {
            return io.atlassian.fugue.Option.some((Object)updatedIssue.left().get());
        }
        IssueIndexingHelper.reindexIssue((Issue)updatedIssue.right().get(), this.issueIndexManager);
        return io.atlassian.fugue.Option.none();
    }

    @Override
    public io.atlassian.fugue.Option<Feedback> getFeedback(@Nonnull Issue issue) {
        ApplicationUser reporter = issue.getReporterUser();
        io.atlassian.fugue.Option<Integer> ratingOpt = this.getRating(issue);
        io.atlassian.fugue.Option<Date> ratingDateOpt = this.getRatingDate(issue);
        io.atlassian.fugue.Option<String> commentOption = this.getComment(reporter, issue);
        if (ratingOpt.isEmpty() || ratingDateOpt.isEmpty()) {
            return io.atlassian.fugue.Option.none();
        }
        Integer rating = (Integer)ratingOpt.get();
        Date ratingDate = (Date)ratingDateOpt.get();
        return io.atlassian.fugue.Option.some((Object)new FeedbackImpl(commentOption, rating, ratingDate));
    }

    private io.atlassian.fugue.Option<AnError> storeComment(Issue issue, ApplicationUser reporter, String comment) {
        String propertyValue = this.commentSerializer.serialize(new CommentProperty(comment));
        EntityPropertyService.PropertyInput propertyInput = new EntityPropertyService.PropertyInput(propertyValue, COMMENT_PROPERTY_KEY);
        EntityPropertyService.SetPropertyValidationResult validationResult = this.issuePropertyService.validateSetProperty(reporter, issue.getId(), propertyInput, ENTITY_PROPERTY_OPTIONS);
        if (!validationResult.isValid()) {
            return io.atlassian.fugue.Option.some((Object)this.feedbackErrors.INVALID_COMMENT());
        }
        this.issuePropertyService.setProperty(reporter, validationResult);
        return io.atlassian.fugue.Option.none();
    }

    private io.atlassian.fugue.Option<Integer> getRating(Issue issue) {
        io.atlassian.fugue.Option feedbackOption = this.requestFeedbackCFManager.getRequestFeedback(issue);
        if (feedbackOption.isDefined()) {
            return io.atlassian.fugue.Option.some((Object)((RequestFeedbackCFValue)feedbackOption.get()).getRate());
        }
        return io.atlassian.fugue.Option.none();
    }

    private io.atlassian.fugue.Option<Date> getRatingDate(Issue issue) {
        io.atlassian.fugue.Option dateOption = this.requestFeedbackDateCFManager.getRequestFeedbackDate(issue);
        if (dateOption.isDefined()) {
            return io.atlassian.fugue.Option.some((Object)dateOption.get());
        }
        return io.atlassian.fugue.Option.none();
    }

    private io.atlassian.fugue.Option<String> getComment(ApplicationUser user, Issue issue) {
        io.atlassian.fugue.Option commentOpt = StepsConverters.newerOption((Option)this.issuePropertyService.getProperty(user, issue.getId(), COMMENT_PROPERTY_KEY, ENTITY_PROPERTY_OPTIONS).getEntityProperty()).map(EntityProperty::getValue);
        if (commentOpt.isDefined()) {
            return io.atlassian.fugue.Option.some((Object)this.commentSerializer.deserialize((String)commentOpt.get()).getComment());
        }
        return io.atlassian.fugue.Option.none();
    }

    @JsonAutoDetect
    private static class CommentProperty {
        private String comment;

        public CommentProperty() {
        }

        public CommentProperty(String comment) {
            this.comment = comment;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

