/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel.healer;

import com.atlassian.fugue.Either;
import com.atlassian.jira.mail.processor.api.channel.connectionverifier.ChannelConnectionTestSuccess;
import com.atlassian.jira.mail.processor.api.channel.connectionverifier.ChannelConnectionVerifier;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannel;
import com.atlassian.servicedesk.internal.feature.emailchannel.healer.EmailChannelSettingValidator;
import com.atlassian.servicedesk.squalor.email.SDMailServerConnectionTestSuccess;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailChannelVerificationManager {
    private final EmailChannelSettingValidator emailChannelSettingValidator;
    private final ChannelConnectionVerifier channelConnectionVerifier;

    @Autowired
    public EmailChannelVerificationManager(EmailChannelSettingValidator emailChannelSettingValidator, ChannelConnectionVerifier channelConnectionVerifier) {
        this.emailChannelSettingValidator = emailChannelSettingValidator;
        this.channelConnectionVerifier = channelConnectionVerifier;
    }

    public io.atlassian.fugue.Either<List<AnError>, SDMailServerConnectionTestSuccess> testEmailChannel(Project project, EmailChannel emailChannel) {
        return Steps.begin(this.emailChannelSettingValidator.verifyEmailChannel(project, emailChannel)).then(validChannel -> StepsConverters.newerEither((Either)this.channelConnectionVerifier.verifyConnectionDefinition(validChannel.definition().getChannelConnectionDefinition())).leftMap(Collections::singletonList)).yield((validChannel, channelConnectionTestSuccess) -> this.convertResult((ChannelConnectionTestSuccess)channelConnectionTestSuccess));
    }

    private SDMailServerConnectionTestSuccess convertResult(ChannelConnectionTestSuccess testResult) {
        return SDMailServerConnectionTestSuccess.success((boolean)testResult.isFolderEmpty(), (String)testResult.getSuccessMessage());
    }
}

