/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelManager;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelService;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSetting;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSettingManager;
import io.atlassian.fugue.Either;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailChannelSettingService {
    private final ServiceDeskLicenseAndPermissionService serviceDeskPermissions;
    private final CommonErrors commonErrors;
    private final EmailChannelSettingManager emailChannelSettingManager;
    private final EmailChannelManager emailChannelManager;
    private final EmailChannelService emailChannelServiceScala;
    private final ErrorResultHelper errorHelper;

    @Autowired
    public EmailChannelSettingService(ServiceDeskLicenseAndPermissionService serviceDeskPermissions, CommonErrors commonErrors, EmailChannelSettingManager emailChannelSettingManager, EmailChannelManager emailChannelManager, EmailChannelService emailChannelServiceScala, ErrorResultHelper errorHelper) {
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.commonErrors = commonErrors;
        this.emailChannelSettingManager = emailChannelSettingManager;
        this.emailChannelManager = emailChannelManager;
        this.emailChannelServiceScala = emailChannelServiceScala;
        this.errorHelper = errorHelper;
    }

    public Either<AnError, List<EmailChannelSetting>> getEmailChannelSettings(CheckedUser user, ServiceDesk serviceDesk, Project project) {
        if (!this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
        }
        return Either.right(this.emailChannelSettingManager.getEmailSettingsByServiceDesk(serviceDesk));
    }

    public Either<AnError, JSDSuccess> removeEmailChannelIfExisting(CheckedUser user, Project project, ServiceDesk serviceDesk, int emailSettingId) {
        if (!this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
        }
        return (Either)this.emailChannelSettingManager.getEmailChannelSettingById(emailSettingId).fold(error -> Either.right((Object)((Object)JSDSuccess.success())), emailChannelSetting -> this.removeEmailChannel(serviceDesk, (EmailChannelSetting)emailChannelSetting));
    }

    private Either<AnError, JSDSuccess> removeEmailChannel(ServiceDesk serviceDesk, EmailChannelSetting emailChannelSetting) {
        if (emailChannelSetting.getServiceDeskId() != serviceDesk.getId()) {
            return Either.left((Object)this.errorHelper.badRequest400("sd.admin.email.settings.servicedesk.mismatch.error", new Object[0]).build());
        }
        return this.emailChannelManager.removeEmailChannel(emailChannelSetting);
    }

    public Either<AnError, JSDSuccess> turnOffEmailChannel(CheckedUser user, ServiceDesk serviceDesk, Project project) {
        if (!this.emailChannelServiceScala.canTurnOnOrOffEmailChannel(user, project, serviceDesk)) {
            return Either.left((Object)this.errorHelper.forbidden403("sd.admin.email.settings.turn.off.error", new Object[0]).build());
        }
        return this.emailChannelManager.turnOffEmailChannel(serviceDesk);
    }

    public Either<AnError, EmailChannelSetting> getEmailChannelById(CheckedUser user, Project project, ServiceDesk serviceDesk, Integer emailSettingId) {
        if (!this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
        }
        return this.emailChannelSettingManager.getEmailChannelSettingById(emailSettingId).flatMap(emailChannelSetting -> this.checkServiceDeskChannelMatch(serviceDesk, (EmailChannelSetting)emailChannelSetting));
    }

    public Either<AnError, JSDSuccess> removeEmailChannelAsJiraAdmin(CheckedUser user, Integer emailSettingId) {
        if (!this.serviceDeskPermissions.canAdministerJIRA((SDUser)user)) {
            return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
        }
        return Steps.begin(this.emailChannelSettingManager.getEmailChannelSettingById(emailSettingId)).then(this.emailChannelManager::removeEmailChannel).yield((emailChannelSetting, jsdSuccess) -> jsdSuccess);
    }

    private Either<AnError, EmailChannelSetting> checkServiceDeskChannelMatch(ServiceDesk serviceDesk, EmailChannelSetting emailChannelSetting) {
        if (emailChannelSetting.getServiceDeskId() != serviceDesk.getId()) {
            return Either.left((Object)this.errorHelper.badRequest400("sd.admin.email.settings.servicedesk.mismatch.error", new Object[0]).build());
        }
        return Either.right((Object)emailChannelSetting);
    }
}

