/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSetting;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSettingQStore;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailChannelSettingQStoreImpl
implements EmailChannelSettingQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public EmailChannelSettingQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public List<EmailChannelSetting> getEmailChannelSettings() {
        return (List)this.databaseAccessor.runInTransaction(db -> ((SQLQuery)db.select(EmailChannelSettingQStoreImpl.emailChannelSettingRecord()).from((Expression)Tables.EMAIL_CHANNEL_SETTING)).fetch());
    }

    @Override
    public List<EmailChannelSetting> getEmailChannelSettingsByEmailAddress(String email) {
        return (List)this.databaseAccessor.runInTransaction(db -> ((SQLQuery)((SQLQuery)db.select(EmailChannelSettingQStoreImpl.emailChannelSettingRecord()).from((Expression)Tables.EMAIL_CHANNEL_SETTING)).where((Predicate)Tables.EMAIL_CHANNEL_SETTING.EMAIL_ADDRESS.eq((Object)email))).fetch());
    }

    @Override
    public List<EmailChannelSetting> getEmailChannelSettingsByServiceDesk(int serviceDeskId) {
        return (List)this.databaseAccessor.runInTransaction(db -> ((SQLQuery)((SQLQuery)db.select(EmailChannelSettingQStoreImpl.emailChannelSettingRecord()).from((Expression)Tables.EMAIL_CHANNEL_SETTING)).where((Predicate)Tables.EMAIL_CHANNEL_SETTING.SERVICE_DESK_ID.eq((Object)serviceDeskId))).fetch());
    }

    @Override
    public List<EmailChannelSetting> getCustomEmailSettingsByServiceDesk(int serviceDeskId) {
        return (List)this.databaseAccessor.runInTransaction(db -> ((SQLQuery)((SQLQuery)db.select(EmailChannelSettingQStoreImpl.emailChannelSettingRecord()).from((Expression)Tables.EMAIL_CHANNEL_SETTING)).where((Predicate)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{Tables.EMAIL_CHANNEL_SETTING.SERVICE_DESK_ID.eq((Object)serviceDeskId), Tables.EMAIL_CHANNEL_SETTING.ON_DEMAND.isFalse()}))).fetch());
    }

    @Override
    public long deleteEmailChannelSetting(int id) {
        return (Long)this.databaseAccessor.runInTransaction(db -> db.delete((RelationalPath)Tables.EMAIL_CHANNEL_SETTING).where((Predicate)Tables.EMAIL_CHANNEL_SETTING.ID.eq((Object)id)).execute());
    }

    @Override
    public Option<EmailChannelSetting> getEmailChannelSettingsByChannelKey(String channelKey) {
        EmailChannelSetting result = (EmailChannelSetting)this.databaseAccessor.runInTransaction(db -> (EmailChannelSetting)((SQLQuery)((SQLQuery)db.select(EmailChannelSettingQStoreImpl.emailChannelSettingRecord()).from((Expression)Tables.EMAIL_CHANNEL_SETTING)).where((Predicate)Tables.EMAIL_CHANNEL_SETTING.MAIL_CHANNEL_KEY.eq((Object)channelKey))).fetchFirst());
        return Option.option((Object)result);
    }

    @Override
    public List<EmailChannelSetting> getEmailChannelSettingsByRequestType(int requestTypeId) {
        return (List)this.databaseAccessor.runInTransaction(db -> ((SQLQuery)((SQLQuery)db.select(EmailChannelSettingQStoreImpl.emailChannelSettingRecord()).from((Expression)Tables.EMAIL_CHANNEL_SETTING)).where((Predicate)Tables.EMAIL_CHANNEL_SETTING.REQUEST_TYPE_ID.eq((Object)requestTypeId))).fetch());
    }

    @Override
    public Option<EmailChannelSetting> createEmailChannelSetting(String emailAddress, String mailChannelKey, int serviceDeskId, int requestTypeId, boolean isOnDemand) {
        int key = (Integer)this.databaseAccessor.runInTransaction(db -> (Integer)db.insert((RelationalPath)Tables.EMAIL_CHANNEL_SETTING).set((Path)Tables.EMAIL_CHANNEL_SETTING.EMAIL_ADDRESS, (Object)emailAddress).set((Path)Tables.EMAIL_CHANNEL_SETTING.MAIL_CHANNEL_KEY, (Object)mailChannelKey).set(Tables.EMAIL_CHANNEL_SETTING.SERVICE_DESK_ID, (Object)serviceDeskId).set(Tables.EMAIL_CHANNEL_SETTING.REQUEST_TYPE_ID, (Object)requestTypeId).set((Path)Tables.EMAIL_CHANNEL_SETTING.ON_DEMAND, (Object)isOnDemand).set(Tables.EMAIL_CHANNEL_SETTING.LAST_PROCEEDED_TIME, (Object)0L).executeWithKey(Tables.EMAIL_CHANNEL_SETTING.ID));
        return this.getEmailChannelSettingsById(key);
    }

    @Override
    public Option<EmailChannelSetting> updateEmailAddressAndRequestTypeById(int id, String emailAddress, int requestTypeId) {
        this.databaseAccessor.runInTransaction(db -> db.update((RelationalPath)Tables.EMAIL_CHANNEL_SETTING).where((Predicate)Tables.EMAIL_CHANNEL_SETTING.ID.eq((Object)id)).set((Path)Tables.EMAIL_CHANNEL_SETTING.EMAIL_ADDRESS, (Object)emailAddress).set(Tables.EMAIL_CHANNEL_SETTING.REQUEST_TYPE_ID, (Object)requestTypeId).execute());
        return this.getEmailChannelSettingsById(id);
    }

    @Override
    public Option<EmailChannelSetting> updateEmailAddress(int id, String emailAddress) {
        this.databaseAccessor.runInTransaction(db -> db.update((RelationalPath)Tables.EMAIL_CHANNEL_SETTING).where((Predicate)Tables.EMAIL_CHANNEL_SETTING.ID.eq((Object)id)).set((Path)Tables.EMAIL_CHANNEL_SETTING.EMAIL_ADDRESS, (Object)emailAddress).execute());
        return this.getEmailChannelSettingsById(id);
    }

    @Override
    public Option<EmailChannelSetting> recordLastProcessedTime(int id, long time) {
        this.databaseAccessor.runInTransaction(db -> db.update((RelationalPath)Tables.EMAIL_CHANNEL_SETTING).where((Predicate)Tables.EMAIL_CHANNEL_SETTING.ID.eq((Object)id)).set(Tables.EMAIL_CHANNEL_SETTING.LAST_PROCEEDED_TIME, (Object)time).execute());
        return this.getEmailChannelSettingsById(id);
    }

    @Override
    public Option<EmailChannelSetting> getEmailChannelSettingsById(int id) {
        EmailChannelSetting result = (EmailChannelSetting)this.databaseAccessor.runInTransaction(db -> (EmailChannelSetting)((SQLQuery)((SQLQuery)db.select(EmailChannelSettingQStoreImpl.emailChannelSettingRecord()).from((Expression)Tables.EMAIL_CHANNEL_SETTING)).where((Predicate)Tables.EMAIL_CHANNEL_SETTING.ID.eq((Object)id))).fetchFirst());
        return Option.option((Object)result);
    }

    private static ConstructorExpression<EmailChannelSetting> emailChannelSettingRecord() {
        return Projections.constructor(EmailChannelSetting.class, (Expression[])new Expression[]{Tables.EMAIL_CHANNEL_SETTING.ID, Tables.EMAIL_CHANNEL_SETTING.EMAIL_ADDRESS, Tables.EMAIL_CHANNEL_SETTING.MAIL_CHANNEL_KEY, Tables.EMAIL_CHANNEL_SETTING.SERVICE_DESK_ID, Tables.EMAIL_CHANNEL_SETTING.REQUEST_TYPE_ID, Tables.EMAIL_CHANNEL_SETTING.ON_DEMAND, Tables.EMAIL_CHANNEL_SETTING.LAST_PROCEEDED_TIME});
    }
}

