/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelHelper;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailConfiguration;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSetting;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSettingManager;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSettingQStore;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class EmailChannelSettingManagerImpl
implements EmailChannelSettingManager {
    private final EmailChannelSettingQStore emailChannelSettingQStore;
    private final EmailChannelHelper emailChannelHelper;
    private final CommonErrors commonErrors;

    @Autowired
    public EmailChannelSettingManagerImpl(EmailChannelSettingQStore emailChannelSettingQStore, EmailChannelHelper emailChannelHelper, CommonErrors commonErrors) {
        this.emailChannelSettingQStore = emailChannelSettingQStore;
        this.emailChannelHelper = emailChannelHelper;
        this.commonErrors = commonErrors;
    }

    @Override
    public Either<AnError, EmailChannelSetting> createEmailChannelSettings(ServiceDesk serviceDesk, RequestType requestType, EmailConfiguration emailConfiguration, String mailChannelKey, boolean isOnDemand) {
        return this.emailChannelSettingQStore.createEmailChannelSetting(emailConfiguration.getEmail(), mailChannelKey, serviceDesk.getId(), requestType.getId(), isOnDemand).toRight(() -> ((CommonErrors)this.commonErrors).EMAIL_CHANNEL_NOT_FOUND());
    }

    @Override
    public Either<AnError, EmailChannelSetting> getEmailChannelSettingsByChannelKey(String channelKey) {
        return this.emailChannelSettingQStore.getEmailChannelSettingsByChannelKey(channelKey).toRight(() -> ((CommonErrors)this.commonErrors).EMAIL_CHANNEL_NOT_FOUND());
    }

    @Override
    public List<EmailChannelSetting> getEmailChannelSettingsByRequestType(RequestType requestType) {
        return this.emailChannelSettingQStore.getEmailChannelSettingsByRequestType(requestType.getId());
    }

    @Override
    public Either<AnError, JSDSuccess> deleteEmailChannelSetting(int id) {
        long rowsDeleted = this.emailChannelSettingQStore.deleteEmailChannelSetting(id);
        if (rowsDeleted > 0L) {
            return Either.right((Object)((Object)JSDSuccess.success()));
        }
        return Either.left((Object)this.commonErrors.EMAIL_CHANNEL_NOT_FOUND());
    }

    @Override
    public Either<AnError, EmailChannelSetting> getEmailChannelSettingById(int id) {
        return this.emailChannelSettingQStore.getEmailChannelSettingsById(id).toRight(() -> ((CommonErrors)this.commonErrors).EMAIL_CHANNEL_NOT_FOUND());
    }

    @Override
    public List<EmailChannelSetting> getEmailChannelSettingsByEmailAddressNotFromCurrentProject(Project project, String email) {
        return this.emailChannelSettingQStore.getEmailChannelSettingsByEmailAddress(email).stream().filter(emailChannelSetting -> !this.projectEquals((EmailChannelSetting)emailChannelSetting, project)).collect(Collectors.toList());
    }

    @Override
    public List<EmailChannelSetting> getEmailChannelSettingsByEmailAddressFromCurrentProject(ServiceDesk servicedesk, Project project, boolean isOndemand) {
        if (isOndemand) {
            return this.emailChannelSettingQStore.getEmailChannelSettingsByServiceDesk(servicedesk.getId()).stream().filter(EmailChannelSetting::isOnDemand).collect(Collectors.toList());
        }
        return this.emailChannelSettingQStore.getCustomEmailSettingsByServiceDesk(servicedesk.getId()).stream().filter(emailChannelSetting -> this.projectEquals((EmailChannelSetting)emailChannelSetting, project)).collect(Collectors.toList());
    }

    @Override
    public Either<AnError, EmailChannelSetting> getEmailChannelSettingByEmailAddress(String email) {
        List<EmailChannelSetting> emailChannelSettings = this.emailChannelSettingQStore.getEmailChannelSettingsByEmailAddress(email);
        if (emailChannelSettings.size() > 0) {
            return Either.right((Object)emailChannelSettings.get(0));
        }
        return Either.left((Object)this.commonErrors.EMAIL_CHANNEL_NOT_FOUND());
    }

    @Override
    public List<EmailChannelSetting> getCustomEmailChannelSettingsByServiceDesk(ServiceDesk serviceDesk) {
        return this.emailChannelSettingQStore.getCustomEmailSettingsByServiceDesk(serviceDesk.getId());
    }

    @Override
    public List<EmailChannelSetting> getEmailSettingsByServiceDesk(ServiceDesk serviceDesk) {
        return this.emailChannelSettingQStore.getEmailChannelSettingsByServiceDesk(serviceDesk.getId());
    }

    @Override
    public List<EmailChannelSetting> getEmailChannelSettings() {
        return this.emailChannelSettingQStore.getEmailChannelSettings();
    }

    @Override
    public Either<AnError, EmailChannelSetting> updateEmailAddressAndRequestType(EmailChannelSetting emailChannelSetting, String emailAddress, RequestType requestType) {
        return this.emailChannelSettingQStore.updateEmailAddressAndRequestTypeById(emailChannelSetting.getId(), emailAddress, requestType.getId()).toRight(() -> ((CommonErrors)this.commonErrors).EMAIL_CHANNEL_NOT_FOUND());
    }

    @Override
    public Either<AnError, EmailChannelSetting> updateEmailAddress(EmailChannelSetting emailChannelSetting, String emailAddress) {
        return this.emailChannelSettingQStore.updateEmailAddress(emailChannelSetting.getId(), emailAddress).toRight(() -> ((CommonErrors)this.commonErrors).EMAIL_CHANNEL_NOT_FOUND());
    }

    @Override
    public Either<AnError, EmailChannelSetting> recordLastProcessedTime(EmailChannelSetting setting, long ms) {
        return this.emailChannelSettingQStore.recordLastProcessedTime(setting.getId(), ms).toRight(() -> ((CommonErrors)this.commonErrors).EMAIL_CHANNEL_NOT_FOUND());
    }

    private boolean projectEquals(EmailChannelSetting emailChannelSetting, Project project) {
        return (Boolean)this.emailChannelHelper.serviceDeskOf(emailChannelSetting).fold(anError -> false, serviceDesk -> Long.valueOf(serviceDesk.getProjectId()).equals(project.getId()));
    }
}

