/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel;

import com.atlassian.mail.MailUtils;
import com.atlassian.mail.converters.HtmlConverter;
import com.atlassian.mail.converters.wiki.HtmlToWikiTextConverter;
import com.atlassian.mail.options.GetBodyOptions;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.emailreply.EmailReplyCleaner;
import com.atlassian.servicedesk.internal.admin.EmailRequestsSettingsManager;
import com.atlassian.servicedesk.internal.admin.EmailTrimmingMode;
import com.atlassian.servicedesk.internal.email.replystripping.EmailReplyCleanerFactory;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailUtil;
import com.atlassian.servicedesk.squalor.email.ServiceDeskMailUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.mail.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IncomingEmailParser {
    private static final Logger log = LoggerFactory.getLogger(IncomingEmailParser.class);
    private final EmailUtil emailUtil;
    private final EmailReplyCleanerFactory quotedEmailCleanerFactory;
    private final ErrorResultHelper errorResultHelper;
    private final EmailRequestsSettingsManager emailRequestsSettingsManager;

    @Autowired
    public IncomingEmailParser(EmailUtil emailUtil, EmailReplyCleanerFactory quotedEmailCleanerFactory, ErrorResultHelper errorResultHelper, EmailRequestsSettingsManager emailRequestsSettingsManager) {
        this.emailUtil = emailUtil;
        this.quotedEmailCleanerFactory = quotedEmailCleanerFactory;
        this.errorResultHelper = errorResultHelper;
        this.emailRequestsSettingsManager = emailRequestsSettingsManager;
    }

    public Either<AnError, ParsedEmail> parse(Message message, boolean applyReplyStripping) {
        try {
            String body;
            ImmutableList attachments = ImmutableList.copyOf((Object[])ServiceDeskMailUtils.getServiceDeskAttachments((Message)message));
            String subject = this.emailUtil.processMessageSubject(message.getSubject());
            boolean shouldParseHtml = this.emailRequestsSettingsManager.getFormattingEnabled();
            if (applyReplyStripping) {
                EmailTrimmingMode trimmingMode = this.emailRequestsSettingsManager.getTrimmingMode();
                EmailReplyCleaner.EmailCleanerResult emailCleanerResult = shouldParseHtml ? this.quotedEmailCleanerFactory.createHtmlInstance(trimmingMode, (HtmlConverter)new HtmlToWikiTextConverter((List)attachments)).cleanQuotedEmail(message) : this.quotedEmailCleanerFactory.createInstance(trimmingMode).cleanQuotedEmail(message);
                body = emailCleanerResult.getBody();
            } else {
                body = shouldParseHtml ? MailUtils.getBody((Message)message, (GetBodyOptions)GetBodyOptions.builder().stripWhitespace().preferHtmlPart().setHtmlConverter((HtmlConverter)new HtmlToWikiTextConverter((List)attachments)).build()) : MailUtils.getBody((Message)message, (GetBodyOptions)GetBodyOptions.PREFER_TEXT_BODY_STRIP_WHITESPACE);
            }
            String processedBody = this.emailUtil.processMessageBody(body);
            return Either.right((Object)new ParsedEmail(subject, processedBody, (List<MailUtils.Attachment>)attachments));
        }
        catch (Exception e) {
            log.warn("Error processing email message", (Throwable)e);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.email.error.message.get.body.error", new Object[0]).build());
        }
    }

    public static class ParsedEmail {
        private String subject;
        private String body;
        private List<MailUtils.Attachment> attachments;

        @VisibleForTesting
        ParsedEmail(String subject, String body, List<MailUtils.Attachment> attachments) {
            this.subject = subject;
            this.body = body;
            this.attachments = attachments;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getBody() {
            return this.body;
        }

        public List<MailUtils.Attachment> getAttachments() {
            return this.attachments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParsedEmail)) {
                return false;
            }
            ParsedEmail that = (ParsedEmail)o;
            return Objects.equal((Object)this.subject, (Object)that.subject) && Objects.equal((Object)this.body, (Object)that.body) && Objects.equal(this.attachments, that.attachments);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.subject, this.body, this.attachments});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("attachments", this.attachments).add("subject", (Object)this.subject).add("body", (Object)this.body).toString();
        }
    }
}

