/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel;

import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailUtil {
    private static final int MAX_SUBJECT_LENGTH = 255;
    private final I18nHelper i18nHelper;
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;

    @Autowired
    public EmailUtil(I18nHelper i18nHelper, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator) {
        this.i18nHelper = i18nHelper;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
    }

    public String processMessageSubject(String subject) {
        String emptySubject;
        String updatedSubject = StringUtils.isBlank((String)subject) ? (StringUtils.isNotBlank((String)(emptySubject = this.i18nHelper.getText("sd.service.request.email.default.subject"))) ? "<" + emptySubject + ">" : subject) : subject;
        return StringUtils.abbreviate((String)updatedSubject, (int)255);
    }

    public String processMessageBody(String body) {
        if (this.textFieldCharacterLengthValidator.isTextTooLong(body)) {
            int max = (int)Math.min(Integer.MAX_VALUE, this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters());
            if (max <= 0) {
                return "";
            }
            if (max < 4) {
                return StringUtils.substring((String)body, (int)0, (int)max);
            }
            return StringUtils.abbreviate((String)body, (int)max);
        }
        return body;
    }

    public static boolean areEmailsEqual(String emailOne, String emailTwo) {
        return EmailUtil.areEmailsEqual(emailOne, emailTwo, true);
    }

    public static boolean areEmailsEqual(String emailOne, String emailTwo, boolean compareIgnoreCase) {
        String emailOneTrimmed = StringUtils.trimToEmpty((String)emailOne);
        if (EmailUtil.isEmailAddressValid(emailOneTrimmed)) {
            String emailTwoTrimmed = StringUtils.trimToEmpty((String)emailTwo);
            return compareIgnoreCase ? emailOneTrimmed.equalsIgnoreCase(emailTwoTrimmed) : emailOneTrimmed.equals(emailTwoTrimmed);
        }
        return false;
    }

    public static Predicate<String> createEmailIsReporterOrExistingParticipantPredicate(@Nonnull Option<String> reporterEmail, @Nonnull List<String> participantEmails) {
        return EmailUtil.createEmailIsReporterOrExistingParticipantPredicate(reporterEmail, participantEmails, true);
    }

    public static Predicate<String> createEmailIsReporterOrExistingParticipantPredicate(@Nonnull Option<String> reporterEmail, @Nonnull List<String> participantEmails, boolean compareIgnoreCase) {
        Assertions.notNull((String)"reporterEmail", reporterEmail);
        Assertions.containsNoNulls((String)"participantEmails", participantEmails);
        String compareReporterEmail = (String)reporterEmail.map(email -> compareIgnoreCase ? StringUtils.lowerCase((String)email) : email).getOrElse((Object)"");
        ImmutableList compareParticipantEmails = ImmutableList.copyOf(compareIgnoreCase ? Lists.transform(participantEmails, StringUtils::lowerCase) : participantEmails);
        return arg_0 -> EmailUtil.lambda$createEmailIsReporterOrExistingParticipantPredicate$1(compareIgnoreCase, compareReporterEmail, (List)compareParticipantEmails, arg_0);
    }

    public static boolean isEmailAddressValidForNewSignup(String email) {
        return EmailUtil.isEmailAddressValid(email) && !StringUtils.contains((String)email, (String)"&");
    }

    public static boolean isEmailAddressValid(String email) {
        String trimmed = StringUtils.trimToEmpty((String)email);
        if (StringUtils.isEmpty((String)trimmed)) {
            return false;
        }
        if (TextUtils.verifyEmail((String)trimmed)) {
            String name = StringUtils.substringBefore((String)trimmed, (String)"@");
            return !StringUtils.startsWith((String)name, (String)".") && !StringUtils.endsWith((String)name, (String)".") && !StringUtils.contains((String)name, (String)"..");
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$createEmailIsReporterOrExistingParticipantPredicate$1(boolean compareIgnoreCase, String compareReporterEmail, List compareParticipantEmails, String email) {
        if (!EmailUtil.isEmailAddressValid(email)) {
            return false;
        }
        String compareEmail = compareIgnoreCase ? StringUtils.lowerCase((String)email) : email;
        return StringUtils.equals((String)compareEmail, (String)compareReporterEmail) || compareParticipantEmails.contains(compareEmail);
    }
}

