/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel;

import com.atlassian.fugue.Either;
import com.atlassian.jira.mail.processor.api.channel.ChannelConnectionDefinition;
import com.atlassian.jira.mail.processor.api.channel.ChannelDefinition;
import com.atlassian.jira.mail.processor.api.channel.ChannelManager;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.emailchannel.EmailChannelManager;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelScala;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailPlatformChannelManager;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class EmailChannelManagerImpl
implements EmailChannelManager {
    private final EmailPlatformChannelManager emailPlatformChannelManager;
    private final ChannelManager channelManager;

    @Autowired
    public EmailChannelManagerImpl(EmailPlatformChannelManager emailPlatformChannelManager, ChannelManager channelManager) {
        this.emailPlatformChannelManager = emailPlatformChannelManager;
        this.channelManager = channelManager;
    }

    public String getEmailChannelAddressForCustomerChannelDialog(ServiceDesk serviceDesk) {
        List<EmailChannelScala> validEmailChannels = this.emailPlatformChannelManager.getValidEmailChannelsByServiceDesk(serviceDesk);
        List enabledEmailChannels = validEmailChannels.stream().filter(EmailChannelScala::isEnabled).collect(Collectors.toList());
        if (enabledEmailChannels.size() >= 2) {
            Optional<EmailChannelScala> personalEmailChannelOpt = enabledEmailChannels.stream().filter(emailChannel -> !emailChannel.isOnDemand()).findFirst();
            if (personalEmailChannelOpt.isPresent()) {
                return personalEmailChannelOpt.get().emailAddress();
            }
            return "";
        }
        if (enabledEmailChannels.size() == 1) {
            return ((EmailChannelScala)enabledEmailChannels.get(0)).emailAddress();
        }
        return "";
    }

    public boolean hasSuitableRequestTypeForEmail(Project project, Portal portal) {
        return this.emailPlatformChannelManager.getFirstSuitableRequestType(project, portal).isRight();
    }

    public io.atlassian.fugue.Either<AnError, ChannelDefinition> updateChannelAddressAndPassword(ChannelDefinition channelDefinition, String newEmailAddress, String newPassword) {
        ChannelConnectionDefinition connDefinition = channelDefinition.getChannelConnectionDefinition();
        ChannelConnectionDefinition updatedConn = connDefinition.getBuilderForUpdate().setEmailAddress(newEmailAddress).setUserName(newEmailAddress).setPassword(newPassword).build();
        ChannelDefinition updatedDef = channelDefinition.getBuilderForUpdate().setChannelConnectionDefinition(updatedConn).build();
        return StepsConverters.newerEither((Either)this.channelManager.update(updatedDef));
    }
}

