/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.errors.ServiceDeskHttpError;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalManager;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelHelper;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSetting;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.utils.Convert;
import io.atlassian.fugue.Either;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class EmailChannelHelperImpl
implements EmailChannelHelper {
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public EmailChannelHelperImpl(InternalServiceDeskProjectManager internalServiceDeskProjectManager, ErrorResultHelper errorResultHelper) {
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public Either<AnError, ServiceDesk> serviceDeskOf(EmailChannelSetting emailChannelSetting) {
        return this.serviceDeskInternalManager().getServiceDeskById(emailChannelSetting.getServiceDeskId(), true);
    }

    @Override
    public Either<AnError, Project> projectOf(EmailChannelSetting emailChannelSetting) {
        return Steps.begin(this.serviceDeskOf(emailChannelSetting)).then(serviceDesk -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(serviceDesk.getProjectId()))).yield((serviceDesk, project) -> project);
    }

    @Override
    public Either<AnError, RequestType> requestTypeOf(EmailChannelSetting emailChannelSetting) {
        return Steps.begin(this.serviceDeskInternalManager().getServiceDeskById(emailChannelSetting.getServiceDeskId(), true)).then(serviceDesk -> this.requestTypeOf(emailChannelSetting, (ServiceDesk)serviceDesk)).yield((serviceDesk, requestType) -> requestType);
    }

    @Override
    public Either<AnError, RequestType> requestTypeOf(EmailChannelSetting emailChannelSetting, ServiceDesk serviceDesk) {
        return Steps.begin((Either)this.internalServiceDeskProjectManager.getProject(Long.valueOf(serviceDesk.getProjectId()))).then(project -> this.requestTypeOf(emailChannelSetting, (Project)project)).yield((project, requestType) -> requestType);
    }

    @Override
    public Either<AnError, RequestType> requestTypeOf(EmailChannelSetting emailChannelSetting, Project project) {
        return this.requestTypeInternalManager().getValidRequestType(emailChannelSetting.getRequestTypeId(), project).leftMap(this::toAnError);
    }

    private ServiceDeskInternalManager serviceDeskInternalManager() {
        return ServiceDeskComponentAccessor.getServiceDeskInternalManager();
    }

    private RequestTypeInternalManager requestTypeInternalManager() {
        return ServiceDeskComponentAccessor.getRequestTypeInternalManager();
    }

    private AnError toAnError(ServiceDeskHttpError serviceDeskHttpError) {
        return Convert.toAnError(serviceDeskHttpError, this.errorResultHelper);
    }
}

